/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SoftValuesLoadingCache<K, V>
extends ForwardingLoadingCache<K, Optional<V>> {
    private final LoadingCache<K, Optional<V>> cache;
    private static final Logger logger = Logger.getLogger(SoftValuesLoadingCache.class);

    public SoftValuesLoadingCache(CacheLoader<K, Optional<V>> loader) {
        this.cache = CacheBuilder.newBuilder().maximumSize(3000L).expireAfterAccess(60L, TimeUnit.MINUTES).softValues().build(loader);
    }

    protected LoadingCache<K, Optional<V>> delegate() {
        return this.cache;
    }

    public V getOrThrow(K key) {
        V v = this.getOrNull(key);
        if (v == null) {
            throw new NullPointerException();
        }
        return v;
    }

    public V getOrNull(K key) {
        try {
            return ((Optional)this.get(key)).orElse(null);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OutOfMemoryError) {
                logger.warn((Object)"Out of memory error: try to increase free memory in launcher options (-xmx param)");
            }
            throw new RuntimeException(e);
        }
        finally {
            return null;
        }
    }

    public V peekIfPresent(K key) {
        Optional value = (Optional)this.getIfPresent(key);
        if (value != null) {
            return value.orElse(null);
        }
        return null;
    }

    public static <K, V> SoftValuesLoadingCache<K, V> from(CacheLoader<K, Optional<V>> loader) {
        return new SoftValuesLoadingCache<K, V>(loader);
    }

    public static <K, V> SoftValuesLoadingCache<K, V> from(Function<K, V> loader) {
        return SoftValuesLoadingCache.from(CacheLoader.from(k -> Optional.ofNullable(loader.apply(k))));
    }
}

