/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.audio;

import mage.client.constants.Constants;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.audio.AudioGroup;
import mage.client.util.audio.LinePool;
import mage.client.util.audio.MageClip;
import org.apache.log4j.Logger;

public class AudioManager {
    private static final Logger log = Logger.getLogger(AudioManager.class);
    private MageClip nextPageClip = null;
    private MageClip prevPageClip = null;
    private MageClip anotherTabClip = null;
    private MageClip nextPhaseClip = null;
    private MageClip endTurnClip = null;
    private MageClip tapPermanentClip = null;
    private MageClip summonClip = null;
    private MageClip diedCreatureClip = null;
    private MageClip drawClip = null;
    private MageClip buttonOkClip = null;
    private MageClip buttonCancelClip = null;
    private MageClip attackClip = null;
    private MageClip blockClip = null;
    private MageClip addPermanentClip = null;
    private MageClip addArtifactClip = null;
    private MageClip updateStackClip = null;
    private MageClip onHover = null;
    private MageClip onSkipButton = null;
    private MageClip onSkipButtonCancel = null;
    private MageClip onCountdown1 = null;
    private MageClip onDraftSelect = null;
    private MageClip tournamentStarted = null;
    private MageClip yourGameStarted = null;
    private MageClip playerJoinedTable = null;
    private MageClip gameCanStart = null;
    private MageClip playerSubmittedDeck = null;
    private MageClip playerWhispered = null;
    private MageClip playerLeft = null;
    private MageClip playerQuitTournament = null;
    private MageClip playerWon = null;
    private MageClip playerLost = null;
    private MageClip feedbackNeeded = null;
    private static final AudioManager audioManager = new AudioManager();
    private LinePool linePool;

    public AudioManager() {
        try {
            this.linePool = new LinePool();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to initialize AudioManager (can't find compatible sound device). No sounds will be played.");
        }
    }

    public static AudioManager getManager() {
        return audioManager;
    }

    public static void playNextPage() {
        if (AudioManager.audioManager.nextPageClip == null) {
            AudioManager.audioManager.nextPageClip = new MageClip(Constants.BASE_SOUND_PATH + "OnPrevPage.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.nextPageClip);
    }

    public static void playPrevPage() {
        if (AudioManager.audioManager.prevPageClip == null) {
            AudioManager.audioManager.prevPageClip = new MageClip(Constants.BASE_SOUND_PATH + "OnPrevPage.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.prevPageClip);
    }

    public static void playAnotherTab() {
        if (AudioManager.audioManager.anotherTabClip == null) {
            AudioManager.audioManager.anotherTabClip = new MageClip(Constants.BASE_SOUND_PATH + "OnNextPage.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.anotherTabClip);
    }

    public static void playNextPhase() {
        if (AudioManager.audioManager.nextPhaseClip == null) {
            AudioManager.audioManager.nextPhaseClip = new MageClip(Constants.BASE_SOUND_PATH + "OnNextPhase.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.nextPhaseClip);
    }

    public static void playEndTurn() {
        if (AudioManager.audioManager.endTurnClip == null) {
            AudioManager.audioManager.endTurnClip = new MageClip(Constants.BASE_SOUND_PATH + "OnEndTurn.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.endTurnClip);
    }

    public static void playTapPermanent() {
        if (AudioManager.audioManager.tapPermanentClip == null) {
            AudioManager.audioManager.tapPermanentClip = new MageClip(Constants.BASE_SOUND_PATH + "OnTapPermanent.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.tapPermanentClip);
    }

    public static void playSummon() {
        if (AudioManager.audioManager.summonClip == null) {
            AudioManager.audioManager.summonClip = new MageClip(Constants.BASE_SOUND_PATH + "OnSummon.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.summonClip);
    }

    public static void playDiedCreature() {
        if (AudioManager.audioManager.diedCreatureClip == null) {
            AudioManager.audioManager.diedCreatureClip = new MageClip(Constants.BASE_SOUND_PATH + "OnSummon-.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.diedCreatureClip);
    }

    public static void playDraw() {
        if (AudioManager.audioManager.drawClip == null) {
            AudioManager.audioManager.drawClip = new MageClip(Constants.BASE_SOUND_PATH + "OnDraw.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.drawClip);
    }

    public static void playButtonOk() {
        if (AudioManager.audioManager.buttonOkClip == null) {
            AudioManager.audioManager.buttonOkClip = new MageClip(Constants.BASE_SOUND_PATH + "OnButtonOk.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.buttonOkClip);
    }

    public static void playButtonCancel() {
        if (AudioManager.audioManager.buttonCancelClip == null) {
            AudioManager.audioManager.buttonCancelClip = new MageClip(Constants.BASE_SOUND_PATH + "OnButtonCancel.wav", AudioGroup.SkipSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.buttonCancelClip);
    }

    public static void playAttack() {
        if (AudioManager.audioManager.attackClip == null) {
            AudioManager.audioManager.attackClip = new MageClip(Constants.BASE_SOUND_PATH + "OnAttack.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.attackClip);
    }

    public static void playBlock() {
        if (AudioManager.audioManager.blockClip == null) {
            AudioManager.audioManager.blockClip = new MageClip(Constants.BASE_SOUND_PATH + "OnBlock.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.blockClip);
    }

    public static void playAddPermanent() {
        if (AudioManager.audioManager.addPermanentClip == null) {
            AudioManager.audioManager.addPermanentClip = new MageClip(Constants.BASE_SOUND_PATH + "OnAddPermanent.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.addPermanentClip);
    }

    public static void playAddArtifact() {
        if (AudioManager.audioManager.addArtifactClip == null) {
            AudioManager.audioManager.addArtifactClip = new MageClip(Constants.BASE_SOUND_PATH + "OnAddArtifact.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.addArtifactClip);
    }

    public static void playStackNew() {
        if (AudioManager.audioManager.updateStackClip == null) {
            AudioManager.audioManager.updateStackClip = new MageClip(Constants.BASE_SOUND_PATH + "OnStackNew.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.updateStackClip);
    }

    public static void playOnHover() {
        if (AudioManager.audioManager.onHover == null) {
            AudioManager.audioManager.onHover = new MageClip(Constants.BASE_SOUND_PATH + "OnHover.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.onHover);
    }

    public static void playOnCountdown1() {
        if (AudioManager.audioManager.onCountdown1 == null) {
            AudioManager.audioManager.onCountdown1 = new MageClip(Constants.BASE_SOUND_PATH + "OnCountdown1.wav", AudioGroup.DraftSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.onCountdown1);
    }

    public static void playOnDraftSelect() {
        if (AudioManager.audioManager.onDraftSelect == null) {
            AudioManager.audioManager.onDraftSelect = new MageClip(Constants.BASE_SOUND_PATH + "OnDraftSelect.wav", AudioGroup.DraftSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.onDraftSelect);
    }

    public static void playOnSkipButton() {
        if (AudioManager.audioManager.onSkipButton == null) {
            AudioManager.audioManager.onSkipButton = new MageClip(Constants.BASE_SOUND_PATH + "OnSkipButton.wav", AudioGroup.SkipSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.onSkipButton);
    }

    public static void playOnSkipButtonCancel() {
        if (AudioManager.audioManager.onSkipButtonCancel == null) {
            AudioManager.audioManager.onSkipButtonCancel = new MageClip(Constants.BASE_SOUND_PATH + "OnSkipButtonCancel.wav", AudioGroup.SkipSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.onSkipButtonCancel);
    }

    public static void playPlayerJoinedTable() {
        if (AudioManager.audioManager.playerJoinedTable == null) {
            AudioManager.audioManager.playerJoinedTable = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerJoined.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerJoinedTable);
    }

    public static void playGameCanStart() {
        if (AudioManager.audioManager.gameCanStart == null) {
            AudioManager.audioManager.gameCanStart = new MageClip(Constants.BASE_SOUND_PATH + "GameCanStart.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.gameCanStart);
    }

    public static void playYourGameStarted() {
        if (AudioManager.audioManager.yourGameStarted == null) {
            AudioManager.audioManager.yourGameStarted = new MageClip(Constants.BASE_SOUND_PATH + "OnGameStart.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.yourGameStarted);
    }

    public static void playTournamentStarted() {
        if (AudioManager.audioManager.tournamentStarted == null) {
            AudioManager.audioManager.tournamentStarted = new MageClip(Constants.BASE_SOUND_PATH + "OnTournamentStart.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.tournamentStarted);
    }

    public static void playPlayerWhispered() {
        if (AudioManager.audioManager.playerWhispered == null) {
            AudioManager.audioManager.playerWhispered = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerWhispered.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerWhispered);
    }

    public static void playPlayerSubmittedDeck() {
        if (AudioManager.audioManager.playerSubmittedDeck == null) {
            AudioManager.audioManager.playerSubmittedDeck = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerSubmittedDeck.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerSubmittedDeck);
    }

    public static void playPlayerLeft() {
        if (AudioManager.audioManager.playerLeft == null) {
            AudioManager.audioManager.playerLeft = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerLeft.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerLeft);
    }

    public static void playPlayerQuitTournament() {
        if (AudioManager.audioManager.playerQuitTournament == null) {
            AudioManager.audioManager.playerQuitTournament = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerQuitTournament.wav", AudioGroup.OtherSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerQuitTournament);
    }

    public static void playPlayerLost() {
        if (AudioManager.audioManager.playerLost == null) {
            AudioManager.audioManager.playerLost = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerLost.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerLost);
    }

    public static void playPlayerWon() {
        if (AudioManager.audioManager.playerWon == null) {
            AudioManager.audioManager.playerWon = new MageClip(Constants.BASE_SOUND_PATH + "OnPlayerWon.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.playerWon);
    }

    public static void playFeedbackNeeded() {
        if (AudioManager.audioManager.feedbackNeeded == null) {
            AudioManager.audioManager.feedbackNeeded = new MageClip(Constants.BASE_SOUND_PATH + "FeedbackNeeded.wav", AudioGroup.GameSounds);
        }
        AudioManager.checkAndPlayClip(AudioManager.audioManager.feedbackNeeded);
    }

    private static boolean audioGroupEnabled(AudioGroup audioGroup) {
        switch (audioGroup) {
            case GameSounds: {
                return "true".equals(PreferencesDialog.getCachedValue("soundsOn", "true"));
            }
            case DraftSounds: {
                return "true".equals(PreferencesDialog.getCachedValue("soundsDraftOn", "true"));
            }
            case SkipSounds: {
                return "true".equals(PreferencesDialog.getCachedValue("soundsSkipButtonsOn", "true"));
            }
            case OtherSounds: {
                return "true".equals(PreferencesDialog.getCachedValue("soundsOtherOn", "true"));
            }
        }
        return false;
    }

    private static void checkAndPlayClip(MageClip mageClip) {
        try {
            if (mageClip == null || mageClip.getBuffer() == null) {
                return;
            }
            if (AudioManager.audioGroupEnabled(mageClip.getAudioGroup())) {
                audioManager.play(mageClip);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error while playing sound clip.", (Throwable)e);
        }
    }

    public void play(MageClip mageClip) {
        if (this.linePool != null) {
            this.linePool.playSound(mageClip);
        }
    }
}

