/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.audio;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import mage.client.util.audio.MageClip;
import mage.util.ThreadUtils;
import org.apache.log4j.Logger;

public class LinePool {
    private final Logger logger = Logger.getLogger(LinePool.class);
    private static final int LINE_CLEANUP_INTERVAL = 30000;
    private static final ThreadPoolExecutor threadPoolSounds;
    private static int threadCount;
    private final Queue<SourceDataLine> freeLines = new ArrayDeque<SourceDataLine>();
    private final Queue<SourceDataLine> activeLines = new ArrayDeque<SourceDataLine>();
    private final Set<SourceDataLine> busyLines = new HashSet<SourceDataLine>();
    private final LinkedList<MageClip> queue = new LinkedList();
    private final Mixer mixer;
    private final int alwaysActive;

    public LinePool() {
        this(new AudioFormat(22050.0f, 16, 1, true, false), 4, 1);
    }

    public LinePool(AudioFormat audioFormat, int size, int alwaysActive) {
        this.alwaysActive = alwaysActive;
        this.mixer = AudioSystem.getMixer(null);
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        for (int i = 0; i < size; ++i) {
            try {
                SourceDataLine line = (SourceDataLine)this.mixer.getLine(lineInfo);
                this.freeLines.add(line);
                continue;
            }
            catch (LineUnavailableException e) {
                this.logger.warn((Object)"Failed to get line from mixer", (Throwable)e);
            }
        }
        new Timer("Line cleanup", true).scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinePool linePool = LinePool.this;
                synchronized (linePool) {
                    for (SourceDataLine sourceDataLine : LinePool.this.freeLines) {
                        if (!sourceDataLine.isOpen()) continue;
                        sourceDataLine.close();
                        LinePool.this.logger.debug((Object)("Closed line " + sourceDataLine));
                    }
                }
            }
        }, 30000L, 30000L);
    }

    private synchronized SourceDataLine borrowLine() {
        SourceDataLine line = this.activeLines.poll();
        if (line == null) {
            line = this.freeLines.poll();
        }
        if (line != null) {
            this.busyLines.add(line);
        }
        return line;
    }

    private synchronized void returnLine(SourceDataLine line) {
        this.busyLines.remove(line);
        if (this.activeLines.size() < this.alwaysActive) {
            this.activeLines.add(line);
        } else {
            this.freeLines.add(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(MageClip mageClip) {
        SourceDataLine line;
        LinePool linePool = this;
        synchronized (linePool) {
            this.logger.debug((Object)("Playing: " + mageClip.getFilename()));
            this.logLineStats();
            line = this.borrowLine();
            if (line == null) {
                this.queue.add(mageClip);
                this.logger.debug((Object)("Sound queued: " + mageClip.getFilename()));
                return;
            }
            this.logLineStats();
        }
        threadPoolSounds.submit(() -> {
            LinePool linePool = this;
            synchronized (linePool) {
                try {
                    if (!line.isOpen()) {
                        line.open();
                        line.addLineListener(event -> {
                            this.logger.debug((Object)("Event: " + event));
                            if (event.getType() != LineEvent.Type.STOP) {
                                return;
                            }
                            LinePool linePool = this;
                            synchronized (linePool) {
                                this.logger.debug((Object)("Before stop on line " + line));
                                this.logLineStats();
                                this.returnLine(line);
                                this.logger.debug((Object)("After stop on line " + line));
                                this.logLineStats();
                                MageClip queuedSound = this.queue.poll();
                                if (queuedSound != null) {
                                    this.logger.debug((Object)("Playing queued sound " + queuedSound));
                                    this.playSound(queuedSound);
                                }
                            }
                        });
                    }
                    line.start();
                }
                catch (LineUnavailableException e) {
                    this.logger.warn((Object)"Failed to open line", (Throwable)e);
                }
            }
            byte[] buffer = mageClip.getBuffer();
            this.logger.debug((Object)("Before write to line " + line));
            line.write(buffer, 0, buffer.length);
            line.drain();
            line.stop();
            this.logger.debug((Object)("Line completed: " + line));
        });
    }

    private void logLineStats() {
        this.logger.debug((Object)String.format("Free lines: %d; Active: %d; Busy: %d", this.freeLines.size(), this.activeLines.size(), this.busyLines.size()));
    }

    static {
        threadCount = 0;
        threadPoolSounds = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                threadCount++;
                Thread thread = new Thread(runnable, "SOUND-" + threadCount);
                thread.setDaemon(true);
                return thread;
            }
        }){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                t = ThreadUtils.findRunnableException(r, t);
                if (t == null || !(t instanceof CancellationException)) {
                    // empty if block
                }
            }
        };
        threadPoolSounds.prestartAllCoreThreads();
    }
}

