/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.audio;

import java.awt.List;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import mage.client.constants.Constants;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.audio.AudioManager;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public class MusicPlayer {
    private static final Logger log = Logger.getLogger(AudioManager.class);
    String filepath;
    String filename;
    final List filelist = new List();
    static MusicPlayer player = null;
    public volatile boolean breaked = false;
    public volatile boolean breaked_out = false;
    public volatile boolean stopped = false;
    public volatile FloatControl volume;
    AudioInputStream audioInputStream;
    AudioFormat audioFormat;
    SourceDataLine sourceDataLine;

    private boolean open() {
        if (!MusicPlayer.isMusicEnabled()) {
            return false;
        }
        String path = PreferencesDialog.getCachedValue("soundsMatchMusicPath", "true");
        this.filepath = path + File.separator;
        if (path == null || path.equals("")) {
            this.filepath = Constants.BASE_MUSICS_PATH;
        }
        this.filelist.removeAll();
        File filedir = new File(this.filepath);
        File[] fileread = filedir.listFiles();
        if (fileread == null) {
            return false;
        }
        if (fileread.length == 0) {
            return false;
        }
        for (File f : fileread) {
            String filename = f.getName().toLowerCase(Locale.ENGLISH);
            if (!filename.endsWith(".mp3") && !filename.endsWith(".wav")) continue;
            this.filelist.add(filename);
        }
        return this.filelist.getItemCount() != 0;
    }

    private static boolean isMusicEnabled() {
        String enabled = PreferencesDialog.getCachedValue("soundsMatchMusicOn", "true");
        return "true".equals(enabled);
    }

    public static void playBGM() {
        MusicPlayer.stopBGM();
        if (player == null) {
            player = new MusicPlayer();
        }
        if (player.open()) {
            player.play();
        }
    }

    public void play() {
        if (MusicPlayer.isMusicEnabled()) {
            MusicPlayer.player.breaked = false;
            MusicPlayer.player.breaked_out = false;
            MusicPlayer.player.stopped = false;
            Thread player = new Thread(new playerThread());
            player.start();
        }
    }

    public static void stopBGM() {
        if (player != null) {
            MusicPlayer.player.stopped = true;
            MusicPlayer.player.breaked_out = true;
            MusicPlayer.player.breaked = true;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (Exception e) {
                log.error((Object)("Thread error: " + e));
            }
        }
    }

    class PlayThread
    extends Thread {
        final byte[] tempBuffer = new byte[320];

        PlayThread() {
        }

        @Override
        public void run() {
            try {
                int len;
                MusicPlayer.this.sourceDataLine.flush();
                while ((len = MusicPlayer.this.audioInputStream.read(this.tempBuffer, 0, this.tempBuffer.length)) != -1 && !MusicPlayer.this.breaked_out) {
                    if (len <= 0) continue;
                    MusicPlayer.this.sourceDataLine.write(this.tempBuffer, 0, len);
                }
                MusicPlayer.this.sourceDataLine.flush();
                MusicPlayer.this.sourceDataLine.close();
                MusicPlayer.this.breaked = true;
            }
            catch (Exception e) {
                log.error((Object)("Thread error: " + e));
            }
        }
    }

    class playerThread
    extends Thread {
        playerThread() {
        }

        private void load(File file) {
            try {
                MusicPlayer.this.audioInputStream = AudioSystem.getAudioInputStream(file);
                MusicPlayer.this.audioFormat = MusicPlayer.this.audioInputStream.getFormat();
                if (MusicPlayer.this.audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    MusicPlayer.this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, MusicPlayer.this.audioFormat.getSampleRate(), 16, MusicPlayer.this.audioFormat.getChannels(), MusicPlayer.this.audioFormat.getChannels() * 2, MusicPlayer.this.audioFormat.getSampleRate(), false);
                    MusicPlayer.this.audioInputStream = AudioSystem.getAudioInputStream(MusicPlayer.this.audioFormat, MusicPlayer.this.audioInputStream);
                }
                DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, MusicPlayer.this.audioFormat, -1);
                MusicPlayer.this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                MusicPlayer.this.sourceDataLine.open(MusicPlayer.this.audioFormat);
                MusicPlayer.this.volume = (FloatControl)MusicPlayer.this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                MusicPlayer.this.sourceDataLine.start();
            }
            catch (Exception e) {
                log.error((Object)("Couldn't load file: " + file + ' ' + e));
            }
        }

        @Override
        public void run() {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!MusicPlayer.this.stopped) {
                int it = (int)Math.abs(RandomUtil.nextDouble() * (double)MusicPlayer.this.filelist.getItemCount());
                File file = new File(MusicPlayer.this.filepath + MusicPlayer.this.filelist.getItem(it));
                this.load(file);
                Thread PlayThread2 = new Thread(new PlayThread());
                PlayThread2.start();
                while (!MusicPlayer.this.breaked && !MusicPlayer.this.breaked_out) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (Exception e) {
                        log.error((Object)("Thread error: " + e));
                    }
                }
                MusicPlayer.this.breaked = false;
            }
        }
    }
}

