/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.gui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Arrow
extends JPanel {
    private static final long serialVersionUID = -4631054277822828303L;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private int bodyWidth = 10;
    private float headSize = 17.0f;
    private Composite composite;
    private Color color = Color.red;
    private Color strokeColor = Color.black;

    public Arrow() {
        this.setOpaque(false);
        this.setOpacity(0.6f);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        float ex = this.endX - this.startX;
        float ey = this.endY - this.startY;
        if (ex == 0.0f && ey == 0.0f) {
            return;
        }
        float length = (float)Math.sqrt(ex * ex + ey * ey);
        float bendPercent = (float)Math.asin(ey / length);
        if (this.endX > this.startX) {
            bendPercent = -bendPercent;
        }
        Area arrow = this.getArrow(length, bendPercent);
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(this.startX, this.startY);
        g2d.rotate(Math.atan2(ey, ex));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(this.composite);
        g2d.setColor(this.color);
        g2d.fill(arrow);
        g2d.setColor(this.strokeColor);
        g2d.draw(arrow);
    }

    private Area getArrow(float length, float bendPercent) {
        float p1x = 0.0f;
        float p1y = 0.0f;
        float p2x = length;
        float p2y = 0.0f;
        float cx = length / 2.0f;
        float cy = length / 8.0f * bendPercent;
        float adjSize = (float)((double)(this.bodyWidth / 2) / Math.sqrt(2.0));
        float ex = p2x - cx;
        float ey = p2y - cy;
        float abs_e = (float)Math.sqrt(ex * ex + ey * ey);
        GeneralPath bodyPath = new GeneralPath();
        bodyPath.moveTo(p2x + ((ey /= abs_e) - (ex /= abs_e)) * adjSize, p2y - (ex + ey) * adjSize);
        bodyPath.quadTo(cx, cy, p1x, p1y - (float)(this.bodyWidth / 2));
        bodyPath.lineTo(p1x, p1y + (float)(this.bodyWidth / 2));
        bodyPath.quadTo(cx, cy, p2x - (ey + ex) * adjSize, p2y + (ex - ey) * adjSize);
        bodyPath.closePath();
        adjSize = (float)((double)this.headSize / Math.sqrt(2.0));
        ex = p2x - cx;
        ey = p2y - cy;
        abs_e = (float)Math.sqrt(ex * ex + ey * ey);
        GeneralPath headPath = new GeneralPath();
        headPath.moveTo(p2x - ((ey /= abs_e) + (ex /= abs_e)) * adjSize, p2y + (ex - ey) * adjSize);
        headPath.lineTo(p2x, p2y);
        headPath.lineTo(p2x + (ey - ex) * adjSize, p2y - (ex + ey) * adjSize);
        headPath.closePath();
        Area area = new Area(headPath);
        area.add(new Area(bodyPath));
        return area;
    }

    public int getBodyWidth() {
        return this.bodyWidth;
    }

    public void setBodyWidth(int bodyWidth) {
        this.bodyWidth = bodyWidth;
    }

    public float getHeadSize() {
        return this.headSize;
    }

    public void setHeadSize(float headSize) {
        this.headSize = headSize;
    }

    public void setArrowLocation(int startX, int startY, int endX, int endY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.repaint();
    }

    public void setOpacity(float opacity) {
        this.composite = AlphaComposite.getInstance(3, opacity);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(2);
        final Arrow arrow = new Arrow();
        frame.add((Component)arrow, "Center");
        frame.setSize(640, 480);
        frame.setResizable(false);
        frame.setVisible(true);
        frame.getContentPane().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                arrow.setArrowLocation(320, 240, e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
    }
}

