/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JPanel;
import mage.client.util.gui.Arrow;

public class ArrowBuilder {
    private static ArrowBuilder instance = new ArrowBuilder();
    private JPanel arrowsManagerPanel;
    private final Map<UUID, JPanel> arrowPanels = new HashMap<UUID, JPanel>();
    private final Map<UUID, Map<Type, List<Arrow>>> map = new HashMap<UUID, Map<Type, List<Arrow>>>();
    private int currentWidth;
    private int currentHeight;

    public static ArrowBuilder getBuilder() {
        return instance;
    }

    public synchronized JPanel getArrowsManagerPanel() {
        if (this.arrowsManagerPanel == null) {
            this.arrowsManagerPanel = new JPanel();
            this.arrowsManagerPanel.setVisible(true);
            this.arrowsManagerPanel.setOpaque(false);
            this.arrowsManagerPanel.setLayout(null);
        }
        return this.arrowsManagerPanel;
    }

    private JPanel getArrowsPanel(UUID gameId) {
        if (!this.arrowPanels.containsKey(gameId)) {
            JPanel arrowPanel = new JPanel();
            arrowPanel.setVisible(true);
            arrowPanel.setOpaque(false);
            arrowPanel.setLayout(null);
            arrowPanel.setSize(this.currentWidth, this.currentHeight);
            this.arrowPanels.put(gameId, arrowPanel);
            this.getArrowsManagerPanel().add(arrowPanel);
            return arrowPanel;
        }
        return this.arrowPanels.get(gameId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArrow(UUID gameId, int startX, int startY, int endX, int endY, Color color, Type type) {
        JPanel p = this.getArrowsPanel(gameId);
        Arrow arrow = new Arrow();
        arrow.setColor(color);
        arrow.setArrowLocation(startX, startY, endX, endY);
        arrow.setBounds(0, 0, Math.max(startX, endX) + 40, Math.max(startY, endY) + 30);
        Map<UUID, Map<Type, List<Arrow>>> map = this.map;
        synchronized (map) {
            p.add(arrow);
            Map innerMap = this.map.computeIfAbsent(gameId, k -> new HashMap());
            List arrows = innerMap.computeIfAbsent(type, k -> new ArrayList());
            arrows.add(arrow);
        }
        p.revalidate();
        p.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllArrows(UUID gameId) {
        Map<UUID, Map<Type, List<Arrow>>> map = this.map;
        synchronized (map) {
            if (this.map.containsKey(gameId)) {
                Map<Type, List<Arrow>> innerMap = this.map.get(gameId);
                JPanel p = this.getArrowsPanel(gameId);
                if (p != null && p.getComponentCount() > 0) {
                    p.removeAll();
                    p.revalidate();
                    p.repaint();
                }
                innerMap.clear();
                this.map.remove(gameId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArrowsByType(UUID gameId, Type type) {
        Map<Type, List<Arrow>> innerMap;
        List<Arrow> arrows;
        if (this.map.containsKey(gameId) && (arrows = (innerMap = this.map.get(gameId)).get((Object)type)) != null && !arrows.isEmpty()) {
            JPanel p = this.getArrowsPanel(gameId);
            Map<UUID, Map<Type, List<Arrow>>> map = this.map;
            synchronized (map) {
                for (Arrow arrow : arrows) {
                    p.remove(arrow);
                }
                innerMap.put(type, new ArrayList());
            }
            p.revalidate();
            p.repaint();
        }
    }

    public void setSize(int width, int height) {
        this.currentWidth = width;
        this.currentHeight = height;
        if (this.arrowsManagerPanel != null) {
            this.arrowsManagerPanel.setSize(width, height);
        }
        for (JPanel arrowPanel : this.arrowPanels.values()) {
            arrowPanel.setSize(width, height);
            arrowPanel.repaint();
        }
    }

    public void hideAllPanels() {
        for (JPanel arrowPanel : this.arrowPanels.values()) {
            arrowPanel.setVisible(false);
        }
    }

    public void showPanel(UUID gameId) {
        if (this.arrowPanels.containsKey(gameId)) {
            this.arrowPanels.get(gameId).setVisible(true);
        }
    }

    public static enum Type {
        PAIRED,
        BANDED,
        SOURCE,
        TARGET,
        COMBAT,
        ENCHANT_PLAYERS;

    }
}

