/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;

public class BufferedImageBuilder {
    private static final int DEFAULT_IMAGE_TYPE = 1;

    private BufferedImageBuilder() {
    }

    public static BufferedImage bufferImage(Image image) {
        return BufferedImageBuilder.bufferImage(image, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage bufferImage(Image image, int type) {
        if (image == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g2 = bufferedImage.createGraphics();
        try {
            g2.drawImage(image, null, null);
        }
        finally {
            g2.dispose();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage bufferImage(Image image, int type, Color color) {
        if (image == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g2 = bufferedImage.createGraphics();
        try {
            g2.drawImage(image, null, null);
            g2.setColor(color);
            g2.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        }
        finally {
            g2.dispose();
        }
        return bufferedImage;
    }

    private void waitForImage(BufferedImage bufferedImage) {
        ImageLoadStatus imageLoadStatus = new ImageLoadStatus();
        bufferedImage.getHeight((img, infoflags, x, y, width, height) -> {
            if (infoflags == 32) {
                imageLoadStatus.heightDone = true;
                return true;
            }
            return false;
        });
        bufferedImage.getWidth((img, infoflags, x, y, width, height) -> {
            if (infoflags == 32) {
                imageLoadStatus.widthDone = true;
                return true;
            }
            return false;
        });
        while (!imageLoadStatus.widthDone && !imageLoadStatus.heightDone) {
            try {
                TimeUnit.MILLISECONDS.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static class ImageLoadStatus {
        public boolean widthDone = false;
        public boolean heightDone = false;

        ImageLoadStatus() {
        }
    }
}

