/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.object;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import mage.utils.StreamUtils;

public final class SaveObjectUtil {
    private static boolean saveIncomeData = false;
    private static final String SAVE_DATA_PROPERTY = "saveObjects";
    private static final String DATE_PATTERN = "[yyyy_MM_dd][H-mm-ss]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObject(Object object, String name) {
        block7: {
            if (saveIncomeData) {
                ObjectOutputStream oos;
                block6: {
                    boolean bCreated;
                    oos = null;
                    File dir = new File("income");
                    if (dir.exists() && (!dir.exists() || !dir.isFile()) || (bCreated = dir.mkdir())) break block6;
                    StreamUtils.closeQuietly(oos);
                    return;
                }
                try {
                    String time = SaveObjectUtil.now(DATE_PATTERN);
                    File f = new File("income" + File.separator + name + '_' + time + ".save");
                    if (!f.exists()) {
                        f.getParentFile().mkdirs();
                        f.createNewFile();
                    }
                    oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeObject(object);
                    oos.close();
                }
                catch (Exception exception) {
                    StreamUtils.closeQuietly(oos);
                    break block7;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(oos);
                    throw throwable;
                }
                StreamUtils.closeQuietly((Closeable)oos);
            }
        }
    }

    public static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    static {
        saveIncomeData = System.getProperty(SAVE_DATA_PROPERTY) != null;
    }
}

