/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.sets;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.RepositoryEvent;
import mage.constants.SetType;
import mage.deck.Standard;
import mage.game.events.Listener;

public final class ConstructedFormats {
    public static final String ALL_SETS = "- All Sets";
    public static final String STANDARD = "- Standard";
    public static final String EXTENDED = "- Extended";
    public static final String FRONTIER = "- Frontier";
    public static final String PIONEER = "- Pioneer";
    public static final String MODERN = "- Modern";
    public static final String VINTAGE_LEGACY = "- Vintage / Legacy";
    public static final String HISTORIC = "- Historic";
    public static final String JOKE = "- Joke Sets";
    public static final String CUSTOM = "- Custom";
    public static final String XMAGE_SETS = "- XMAGE";
    public static final Standard STANDARD_CARDS = new Standard();
    private static final Date extendedDate = new GregorianCalendar(2009, 7, 19).getTime();
    private static final Date frontierDate = new GregorianCalendar(2014, 6, 17).getTime();
    private static final Date pioneerDate = new GregorianCalendar(2012, 9, 4).getTime();
    private static final Date modernDate = new GregorianCalendar(2003, 6, 27).getTime();
    private static final Date historicDate = new GregorianCalendar(2017, 8, 28).getTime();
    private static final List<String> all = new ArrayList<String>();
    private static final Map<String, List<String>> underlyingSetCodesPerFormat = new HashMap<String, List<String>>();
    private static final List<String> formats = new ArrayList<String>();
    private static final Listener<RepositoryEvent> setsDbListener;

    private ConstructedFormats() {
    }

    public static List<String> getTypes(boolean includeInnerSets) {
        ArrayList<String> res = new ArrayList<String>(formats);
        if (!includeInnerSets) {
            res.removeIf(s -> s.equals(XMAGE_SETS));
        }
        return res;
    }

    public static String getDefault() {
        return STANDARD;
    }

    public static List<String> getSetsByFormat(String format) {
        if (!format.equals(ALL_SETS)) {
            return underlyingSetCodesPerFormat.get(format);
        }
        return all;
    }

    public static void ensureLists() {
        if (underlyingSetCodesPerFormat.isEmpty() || underlyingSetCodesPerFormat.values().stream().findFirst().get().isEmpty()) {
            ConstructedFormats.buildLists();
        }
    }

    public static void buildLists() {
        underlyingSetCodesPerFormat.clear();
        underlyingSetCodesPerFormat.put(STANDARD, new ArrayList());
        underlyingSetCodesPerFormat.put(EXTENDED, new ArrayList());
        underlyingSetCodesPerFormat.put(FRONTIER, new ArrayList());
        underlyingSetCodesPerFormat.put(PIONEER, new ArrayList());
        underlyingSetCodesPerFormat.put(MODERN, new ArrayList());
        underlyingSetCodesPerFormat.put(VINTAGE_LEGACY, new ArrayList());
        underlyingSetCodesPerFormat.put(HISTORIC, new ArrayList());
        underlyingSetCodesPerFormat.put(JOKE, new ArrayList());
        underlyingSetCodesPerFormat.put(CUSTOM, new ArrayList());
        underlyingSetCodesPerFormat.put(XMAGE_SETS, new ArrayList());
        HashMap<String, ExpansionInfo> expansionInfo = new HashMap<String, ExpansionInfo>();
        formats.clear();
        if (!ExpansionRepository.instance.instanceInitialized) {
            return;
        }
        underlyingSetCodesPerFormat.get(XMAGE_SETS).add("XMAGE");
        for (ExpansionInfo set : ExpansionRepository.instance.getAll()) {
            expansionInfo.put(set.getName(), set);
            formats.add(set.getName());
            underlyingSetCodesPerFormat.put(set.getName(), new ArrayList());
            underlyingSetCodesPerFormat.get(set.getName()).add(set.getCode());
            if (set.getType().isCustomSet()) {
                underlyingSetCodesPerFormat.get(CUSTOM).add(set.getCode());
                continue;
            }
            if (set.getType().isJokeSet()) {
                underlyingSetCodesPerFormat.get(JOKE).add(set.getCode());
                continue;
            }
            underlyingSetCodesPerFormat.get(VINTAGE_LEGACY).add(set.getCode());
            if (set.getType().isHistoricLegal() && set.getReleaseDate().after(historicDate)) {
                underlyingSetCodesPerFormat.get(HISTORIC).add(set.getCode());
            }
            if (STANDARD_CARDS.getSetCodes().contains(set.getCode())) {
                underlyingSetCodesPerFormat.get(STANDARD).add(set.getCode());
            }
            if (set.getType().isStandardLegal() && set.getReleaseDate().after(extendedDate)) {
                underlyingSetCodesPerFormat.get(EXTENDED).add(set.getCode());
            }
            if (set.getType().isStandardLegal() && set.getReleaseDate().after(frontierDate)) {
                underlyingSetCodesPerFormat.get(FRONTIER).add(set.getCode());
            }
            if (set.getType().isStandardLegal() && set.getReleaseDate().after(pioneerDate)) {
                underlyingSetCodesPerFormat.get(PIONEER).add(set.getCode());
            }
            if (set.getType().isModernLegal() && set.getReleaseDate().after(modernDate)) {
                underlyingSetCodesPerFormat.get(MODERN).add(set.getCode());
            }
            if (set.getType() == SetType.EXPANSION && set.getBlockName() != null) {
                String blockDisplayName = ConstructedFormats.getBlockDisplayName(set.getBlockName());
                underlyingSetCodesPerFormat.computeIfAbsent(blockDisplayName, k -> new ArrayList());
                underlyingSetCodesPerFormat.get(blockDisplayName).add(set.getCode());
                if (expansionInfo.get(blockDisplayName) == null) {
                    expansionInfo.put(blockDisplayName, set);
                    formats.add(blockDisplayName);
                }
                if (((ExpansionInfo)expansionInfo.get(blockDisplayName)).getReleaseDate().after(set.getReleaseDate())) {
                    expansionInfo.put(blockDisplayName, set);
                }
            }
            if (set.getType() != SetType.SUPPLEMENTAL || set.getBlockName() == null) continue;
            expansionInfo.putIfAbsent(set.getBlockName(), set);
            if (!((ExpansionInfo)expansionInfo.get(set.getBlockName())).getReleaseDate().before(set.getReleaseDate())) continue;
            expansionInfo.put(set.getBlockName(), set);
        }
        formats.sort((name1, name2) -> {
            ExpansionInfo expansionInfo1 = (ExpansionInfo)expansionInfo.get(name1);
            ExpansionInfo expansionInfo2 = (ExpansionInfo)expansionInfo.get(name2);
            if (expansionInfo1.getType().compareTo(expansionInfo2.getType()) == 0) {
                SetType setType = expansionInfo1.getType();
                switch (setType) {
                    case EXPANSION: {
                        if (expansionInfo1.getBlockName() == null) {
                            if (expansionInfo2.getBlockName() == null) {
                                return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
                            }
                            return 1;
                        }
                        if (expansionInfo2.getBlockName() == null) {
                            return -1;
                        }
                        if (name1.endsWith("Block") && name2.endsWith("Block")) {
                            return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
                        }
                        if (name1.endsWith("Block") && expansionInfo1.getBlockName().equals(expansionInfo2.getBlockName())) {
                            return -1;
                        }
                        if (name2.endsWith("Block") && expansionInfo1.getBlockName().equals(expansionInfo2.getBlockName())) {
                            return 1;
                        }
                        return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
                    }
                    case SUPPLEMENTAL: {
                        if (expansionInfo1.getBlockName() == null) {
                            if (expansionInfo2.getBlockName() == null) {
                                return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
                            }
                            return -1;
                        }
                        if (expansionInfo2.getBlockName() == null) {
                            return 1;
                        }
                        if (expansionInfo1.getBlockName().equals(expansionInfo2.getBlockName())) {
                            if (expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate()) == 0) {
                                return name1.compareTo((String)name2);
                            }
                            return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
                        }
                        if (expansionInfo1.getBlockName().startsWith("Duel Decks")) {
                            if (expansionInfo1.getBlockName().startsWith("Duel Decks: Anthology")) {
                                return 1;
                            }
                            return 1;
                        }
                        if (expansionInfo2.getBlockName().startsWith("Duel Decks")) {
                            return -1;
                        }
                        ExpansionInfo blockInfo1 = (ExpansionInfo)expansionInfo.get(expansionInfo1.getBlockName());
                        ExpansionInfo blockInfo2 = (ExpansionInfo)expansionInfo.get(expansionInfo2.getBlockName());
                        return blockInfo2.getReleaseDate().compareTo(blockInfo1.getReleaseDate());
                    }
                }
                return expansionInfo2.getReleaseDate().compareTo(expansionInfo1.getReleaseDate());
            }
            return expansionInfo1.getType().compareTo(expansionInfo2.getType());
        });
        if (!formats.isEmpty()) {
            formats.add(0, XMAGE_SETS);
            formats.add(0, CUSTOM);
            formats.add(0, JOKE);
            formats.add(0, HISTORIC);
            formats.add(0, VINTAGE_LEGACY);
            formats.add(0, MODERN);
            formats.add(0, PIONEER);
            formats.add(0, FRONTIER);
            formats.add(0, EXTENDED);
            formats.add(0, STANDARD);
        }
        formats.add(0, ALL_SETS);
    }

    private static String getBlockDisplayName(String blockName) {
        return "* " + blockName + " Block";
    }

    static {
        ConstructedFormats.buildLists();
        setsDbListener = new Listener<RepositoryEvent>(){

            @Override
            public void event(RepositoryEvent event) {
                if (event.getEventType().equals((Object)RepositoryEvent.RepositoryEventType.DB_UPDATED)) {
                    ConstructedFormats.buildLists();
                }
            }
        };
        ExpansionRepository.instance.subscribe(setsDbListener);
    }
}

