/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mage.cards.MageCard;
import mage.cards.MageCardAnimationSettings;
import mage.cards.MageCardLocation;
import mage.cards.MageCardSpace;
import mage.cards.MagePermanent;
import mage.cards.TextPopup;
import mage.cards.action.ActionCallback;
import mage.cards.action.TransferData;
import mage.client.plugins.adapters.MageActionCallback;
import mage.client.plugins.impl.Plugins;
import mage.client.util.GUISizeHelper;
import mage.client.util.audio.AudioManager;
import mage.constants.CardType;
import mage.constants.EnlargeMode;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.view.AbilityView;
import mage.view.CardView;
import mage.view.PermanentView;
import mage.view.StackAbilityView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.Animation;
import org.mage.card.arcane.MageLayer;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public abstract class CardPanel
extends MagePermanent
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = -3272134219262184410L;
    private static final Logger logger = Logger.getLogger(CardPanel.class);
    public static final double TAPPED_ANGLE = 1.5707963267948966;
    public static final double FLIPPED_ANGLE = Math.PI;
    public static final float ASPECT_RATIO = 1.4f;
    public static final int POPUP_X_GAP = 1;
    public static final Rectangle CARD_SIZE_FULL = new Rectangle(101, 149);
    private static final float ROT_CENTER_TO_TOP_CORNER = 1.0295631f;
    private static final float ROT_CENTER_TO_BOTTOM_CORNER = 0.70710677f;
    private CardView gameCard;
    private CardView cardSideMain = null;
    private CardView cardSideOther = null;
    private CardView updateCard;
    private double tappedAngle = 0.0;
    private double flippedAngle = 0.0;
    private final List<MageCard> links = new ArrayList<MageCard>();
    public final JPanel buttonPanel;
    private JButton dayNightButton;
    private JButton showCopySourceButton;
    private boolean displayEnabled = true;
    private boolean isAnimationPanel;
    private int cardWidth;
    private int cardHeight;
    private int symbolWidth;
    private boolean isSelected;
    private boolean isChoosable;
    private boolean showCastingCost;
    private float alpha = 1.0f;
    private ActionCallback callback;
    protected boolean tooltipShowing;
    protected final TextPopup tooltipText;
    protected UUID gameId;
    private TransferData data = new TransferData();
    private boolean isPermanent;
    private boolean hasSickness;
    private Zone zone;
    private int mouseClicksCount = 0;
    private Timer mouseResetTimer = null;
    private static final int MOUSE_DOUBLE_CLICK_RESET_MS = 200;
    private boolean needFullPermanentRender = true;
    public double transformAngle = 1.0;
    private boolean guiTransformed;
    private boolean animationInProgress = false;
    private Container cardContainer;
    private MageCard topPanel;
    private int yCardCaptionOffsetPercent = 8;
    private JPopupMenu popupMenu;

    public CardPanel(CardView newGameCard, UUID gameId, boolean loadImage, ActionCallback callback, boolean foil, Dimension dimension, boolean needFullPermanentRender) {
        this.setGameCard(newGameCard);
        this.setGameCardSides(newGameCard);
        this.callback = callback;
        this.gameId = gameId;
        this.needFullPermanentRender = needFullPermanentRender;
        boolean bl = this.isPermanent = this.getGameCard() instanceof PermanentView && !this.getGameCard().inViewerOnly();
        if (this.isPermanent) {
            this.hasSickness = ((PermanentView)this.getGameCard()).hasSummoningSickness();
        }
        this.setCardBounds(0, 0, dimension.width, dimension.height);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setVisible(true);
        this.add(this.buttonPanel);
        if (this.getGameCard().canTransform()) {
            this.dayNightButton = new JButton("");
            this.dayNightButton.setSize(32, 32);
            this.dayNightButton.setToolTipText("This permanent is a double faced card. To see the card's other face, push this button or move mouse wheel down while hovering over it.");
            BufferedImage day = ImageManagerImpl.instance.getDayImage();
            this.dayNightButton.setIcon(new ImageIcon(day));
            this.dayNightButton.addActionListener(e -> {
                if (this.animationInProgress) {
                    return;
                }
                if (this.isTapped()) {
                    this.getTopPanelRef().toggleTransformed();
                    this.getTopPanelRef().repaint();
                    return;
                }
                Animation.transformCard(this);
            });
            this.buttonPanel.add(this.dayNightButton);
        }
        if (this.getGameCard() instanceof PermanentView) {
            this.showCopySourceButton = new JButton("");
            this.showCopySourceButton.setSize(32, 32);
            this.showCopySourceButton.setToolTipText("This permanent is copying a target. To see original card, push this button or turn mouse wheel down while hovering with the mouse pointer over the permanent.");
            this.showCopySourceButton.setVisible(((PermanentView)this.getGameCard()).isCopy());
            this.showCopySourceButton.setIcon(new ImageIcon(ImageManagerImpl.instance.getCopyInformIconImage()));
            this.showCopySourceButton.addActionListener(e -> {
                ActionCallback callback1 = Plugins.instance.getActionCallback();
                ((MageActionCallback)callback1).enlargeCard(EnlargeMode.COPY);
            });
            this.buttonPanel.add(this.showCopySourceButton);
        }
        this.setBackground(Color.black);
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        String cardType = this.getType(newGameCard);
        this.tooltipText = new TextPopup();
        this.tooltipText.setText(this.getText(cardType, newGameCard));
        this.setTappedAngle(this.isTapped() ? 1.5707963267948966 : 0.0);
        this.setFlippedAngle(this.isFlipped() ? Math.PI : 0.0);
    }

    public void doLayout() {
        this.buttonPanel.setLocation(0, 0);
        this.buttonPanel.setSize(this.cardWidth, this.cardHeight);
        int x = this.cardWidth / 20;
        int y = this.cardHeight / 10;
        if (this.dayNightButton != null) {
            this.dayNightButton.setLocation(x, y);
            y += 25;
            y += 5;
        }
        if (this.showCopySourceButton != null) {
            this.showCopySourceButton.setLocation(x, y);
        }
    }

    public final void initialDraw() {
        if (this.getGameCard().isTransformed() && !this.isTransformed()) {
            this.toggleTransformed();
        } else {
            this.updateArtImage();
        }
    }

    public void setIsPermanent(boolean isPermanent) {
        this.isPermanent = isPermanent;
    }

    public void cleanUp() {
        if (this.dayNightButton != null) {
            for (EventListener eventListener : this.dayNightButton.getActionListeners()) {
                this.dayNightButton.removeActionListener((ActionListener)eventListener);
            }
        }
        for (EventListener eventListener : this.getMouseListeners()) {
            this.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseMotionListeners()) {
            this.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseWheelListeners()) {
            this.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        this.callback = null;
        this.data = null;
    }

    public abstract void transferResources(CardPanel var1);

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setDisplayEnabled(boolean displayEnabled) {
        this.displayEnabled = displayEnabled;
    }

    public boolean isDisplayEnabled() {
        return this.displayEnabled;
    }

    public void setAnimationPanel(boolean isAnimationPanel) {
        this.isAnimationPanel = isAnimationPanel;
    }

    public boolean isAnimationPanel() {
        return this.isAnimationPanel;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public List<MageCard> getLinks() {
        return this.links;
    }

    public MageCardSpace getOuterSpace() {
        return MageCardSpace.empty;
    }

    public void setChoosable(boolean isChoosable) {
        this.isChoosable = isChoosable;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public boolean hasSickness() {
        return this.hasSickness;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void setCardContainerRef(Container cardContainer) {
        this.cardContainer = cardContainer;
    }

    public void setTopPanelRef(MageCard topPanel) {
        this.topPanel = topPanel;
    }

    public MageCard getTopPanelRef() {
        return this.topPanel;
    }

    public void setShowCastingCost(boolean showCastingCost) {
        this.showCastingCost = showCastingCost;
    }

    public boolean getShowCastingCost() {
        return this.showCastingCost;
    }

    protected abstract void paintCard(Graphics2D var1);

    public void paint(Graphics g) {
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.paintCard(g2);
        }
        finally {
            g2.dispose();
        }
    }

    public String toString() {
        return this.getGameCard().toString();
    }

    public void setCardBounds(int x, int y, int cardWidth, int cardHeight) {
        if (cardWidth == this.cardWidth && cardHeight == this.cardHeight) {
            this.setBounds(x, y, this.getWidth(), this.getHeight());
        } else {
            this.cardWidth = cardWidth;
            this.symbolWidth = cardWidth / 7;
            this.cardHeight = cardHeight;
            this.setBounds(x, y, cardWidth, cardHeight);
        }
    }

    public final int getCardX() {
        return this.getX() + this.getOuterSpace().getLeft();
    }

    public final int getCardY() {
        return this.getY() + this.getOuterSpace().getTop();
    }

    public final int getCardWidth() {
        return this.cardWidth;
    }

    public final int getCardHeight() {
        return this.cardHeight;
    }

    public final int getSymbolWidth() {
        return this.symbolWidth;
    }

    public final CardView getCard() {
        return this.getGameCard();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public MageCardAnimationSettings getAnimationSettings(int offsetX, int offsetY, float cardBoundWidth, float cardBoundHeight) {
        MageCardAnimationSettings settings = new MageCardAnimationSettings();
        settings.withVisible(this.displayEnabled);
        if (this.getTappedAngle() + this.getFlippedAngle() > 0.0) {
            double angle = this.getTappedAngle() + (Math.abs(this.getFlippedAngle() - Math.PI) < 0.001 ? 0.0 : this.getFlippedAngle());
            float edgeOffset = cardBoundWidth / 2.0f;
            settings.withRotate(angle, (double)((float)offsetX + edgeOffset), (double)((float)offsetY + cardBoundHeight - edgeOffset));
        }
        if (this.transformAngle < 1.0) {
            float edgeOffset = cardBoundWidth / 2.0f;
            settings.withTranslate((double)((float)offsetX + edgeOffset) * (1.0 - this.transformAngle), 0.0);
            settings.withScale(this.transformAngle, 1.0);
        }
        return settings;
    }

    public final boolean isTapped() {
        if (this.isPermanent && this.getGameCard() instanceof PermanentView) {
            return ((PermanentView)this.getGameCard()).isTapped();
        }
        return false;
    }

    public final boolean isFlipped() {
        if (this.isPermanent && this.getGameCard() instanceof PermanentView) {
            return ((PermanentView)this.getGameCard()).isFlipped();
        }
        return false;
    }

    public final boolean isTransformed() {
        if (this.cardSideMain.isTransformed()) {
            return !this.guiTransformed;
        }
        return this.guiTransformed;
    }

    public void onBeginAnimation() {
        this.animationInProgress = true;
    }

    public void onEndAnimation() {
        this.animationInProgress = false;
    }

    public void update(CardView card) {
        if (card == null) {
            return;
        }
        if (this.guiTransformed && card.equals(this.cardSideMain)) {
            this.isChoosable = card.isChoosable();
            this.isSelected = card.isSelected();
            return;
        }
        this.setUpdateCard(card);
        if (this.isPermanent && card instanceof PermanentView) {
            boolean needsTranforming;
            boolean needsFlipping;
            boolean needsTapping = this.isTapped() != ((PermanentView)card).isTapped();
            boolean bl = needsFlipping = this.isFlipped() != ((PermanentView)card).isFlipped();
            if (needsTapping || needsFlipping) {
                Animation.tapCardToggle(this, needsTapping, needsFlipping);
            }
            if (needsTapping && ((PermanentView)card).isTapped()) {
                AudioManager.playTapPermanent();
            }
            boolean bl2 = needsTranforming = this.isTransformed() != card.isTransformed();
            if (needsTranforming && !this.animationInProgress) {
                Animation.transformCard(this);
            }
        }
        this.isChoosable = card.isChoosable();
        this.isSelected = card.isSelected();
        boolean mustUpdateArt = !this.getGameCard().getName().equals(card.getName()) || this.getGameCard().isFaceDown() != card.isFaceDown();
        this.setGameCard(card);
        this.setGameCardSides(card);
        String cardType = this.getType(card);
        this.tooltipText.setText(this.getText(cardType, card));
        if (mustUpdateArt) {
            this.updateArtImage();
        }
        if (card.canTransform() && this.dayNightButton != null) {
            BufferedImage transformIcon = this.isTransformed() ? ImageManagerImpl.instance.getNightImage() : ImageManagerImpl.instance.getDayImage();
            this.dayNightButton.setVisible(true);
            this.dayNightButton.setIcon(new ImageIcon(transformIcon));
        }
    }

    public CardView getOriginal() {
        return this.cardSideMain;
    }

    @Override
    public void mouseClicked(final MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
            this.callback.popupMenuCard(e, this.data);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.mouseClicksCount = e.getClickCount();
        if (this.mouseClicksCount > 1) {
            if (this.mouseResetTimer != null) {
                this.mouseResetTimer.cancel();
            }
            this.callback.mouseClicked(e, this.data, true);
        } else {
            if (this.mouseResetTimer != null) {
                this.mouseResetTimer.cancel();
            }
            this.mouseResetTimer = new Timer("mouseResetTimer", false);
            this.mouseResetTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (CardPanel.this.callback != null) {
                        if (CardPanel.this.mouseClicksCount == 1) {
                            CardPanel.this.callback.mouseClicked(e, CardPanel.this.data, false);
                        } else if (CardPanel.this.mouseClicksCount > 1) {
                            CardPanel.this.callback.mouseClicked(e, CardPanel.this.data, true);
                        }
                    }
                    CardPanel.this.mouseClicksCount = 0;
                }
            }, 200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        if (this.getGameCard().hideInfo()) {
            return;
        }
        if (!this.tooltipShowing) {
            CardPanel cardPanel = this;
            synchronized (cardPanel) {
                if (!this.tooltipShowing) {
                    TransferData transferData = this.getTransferDataForMouseEntered();
                    if (this.isShowing()) {
                        this.tooltipShowing = true;
                        this.callback.mouseEntered(e, transferData);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        if (this.getGameCard().hideInfo()) {
            return;
        }
        if (this.tooltipShowing) {
            CardPanel cardPanel = this;
            synchronized (cardPanel) {
                if (this.tooltipShowing) {
                    this.tooltipShowing = false;
                    this.data.setComponent((MageCard)this);
                    this.data.setCard(this.getGameCard());
                    this.data.setPopupText(this.tooltipText);
                    this.callback.mouseExited(e, this.data);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        this.callback.mousePressed(e, this.data);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        this.callback.mouseReleased(e, this.data);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        this.callback.mouseDragged(e, this.data);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.callback == null) {
            return;
        }
        if (this.getGameCard().hideInfo()) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        this.callback.mouseMoved(e, this.data);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.callback == null) {
            return;
        }
        if (this.getGameCard().hideInfo()) {
            return;
        }
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setGameId(this.gameId);
        this.callback.mouseWheelMoved(e.getWheelRotation(), this.data);
    }

    private TransferData getTransferDataForMouseEntered() {
        MageCard cardPanel = this.getTopPanelRef();
        this.data.setComponent((MageCard)this);
        this.data.setCard(this.getGameCard());
        this.data.setPopupText(this.tooltipText);
        this.data.setGameId(this.gameId);
        this.data.setLocationOnScreen(cardPanel.getCardLocationOnScreen().getCardPoint());
        this.data.setPopupOffsetX(this.isTapped() ? this.cardHeight + 1 : this.cardWidth + 1);
        this.data.setPopupOffsetY(40);
        return this.data;
    }

    protected final String getType(CardView card) {
        StringBuilder sbType = new StringBuilder();
        for (SuperType superType : card.getSuperTypes()) {
            sbType.append(superType.toString()).append(' ');
        }
        for (CardType cardType : card.getCardTypes()) {
            sbType.append(cardType.toString()).append(' ');
        }
        if (!card.getSubTypes().isEmpty()) {
            sbType.append("- ");
            for (SubType subType : card.getSubTypes()) {
                sbType.append((Object)subType).append(' ');
            }
        }
        return sbType.toString().trim();
    }

    protected final String getText(String cardType, CardView card) {
        StringBuilder sb = new StringBuilder();
        if (card instanceof StackAbilityView || card instanceof AbilityView) {
            for (String rule : card.getRules()) {
                sb.append('\n').append(rule);
            }
        } else {
            sb.append(card.getName());
            if (!card.getManaCostStr().isEmpty()) {
                sb.append('\n').append(card.getManaCostStr());
            }
            sb.append('\n').append(cardType);
            if (card.getColor().hasColor()) {
                sb.append('\n').append(card.getColor().toString());
            }
            if (card.isCreature()) {
                sb.append('\n').append(card.getPower()).append('/').append(card.getToughness());
            } else if (card.isPlaneswalker()) {
                sb.append('\n').append(card.getLoyalty());
            } else if (card.isBattle()) {
                sb.append('\n').append(card.getDefense());
            }
            if (card.getRules() == null) {
                card.overrideRules(new ArrayList());
            }
            for (String rule : card.getRules()) {
                sb.append('\n').append(rule);
            }
            if (card.getExpansionSetCode() != null && !card.getExpansionSetCode().isEmpty()) {
                sb.append('\n').append(card.getCardNumber()).append(" - ");
                sb.append(card.getExpansionSetCode()).append(" - ");
                sb.append(card.getRarity() == null ? "none" : card.getRarity().toString());
            }
        }
        return sb.toString();
    }

    public void update(PermanentView card) {
        this.hasSickness = card.hasSummoningSickness();
        this.showCopySourceButton.setVisible(card.isCopy());
        this.getTopPanelRef().update((CardView)card);
    }

    public PermanentView getOriginalPermanent() {
        if (this.isPermanent) {
            return (PermanentView)this.cardSideMain;
        }
        throw new IllegalStateException("Is not permanent.");
    }

    private void copySelections(CardView source, CardView dest) {
        if (source != null && dest != null) {
            dest.setSelected(source.isSelected());
            dest.setChoosable(source.isChoosable());
            dest.setPlayableStats(source.getPlayableStats());
        }
    }

    public void toggleTransformed() {
        boolean bl = this.guiTransformed = !this.guiTransformed;
        if (this.dayNightButton != null) {
            BufferedImage image = this.isTransformed() ? ImageManagerImpl.instance.getNightImage() : ImageManagerImpl.instance.getDayImage();
            this.dayNightButton.setIcon(new ImageIcon(image));
        }
        if (this.guiTransformed) {
            if (this.cardSideOther == null) {
                logger.error((Object)("can't find second side to toggle transform from main to second: " + this.getCard().getName()));
                return;
            }
            this.copySelections(this.cardSideMain, this.cardSideOther);
            this.update(this.cardSideOther);
            this.getGameCard().setAlternateName(this.cardSideMain.getName());
        } else {
            if (this.cardSideOther == null) {
                logger.error((Object)("can't find second side to toggle transform from second side to main: " + this.getCard().getName()));
                return;
            }
            this.copySelections(this.cardSideOther, this.cardSideMain);
            this.update(this.cardSideMain);
            this.getGameCard().setAlternateName(this.cardSideOther.getName());
        }
        this.updateArtImage();
    }

    public Container getCardContainer() {
        return this.cardContainer;
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        this.doLayout();
        if (this.getUpdateCard() instanceof PermanentView) {
            this.update(this.getUpdateCard());
        }
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    public void setCardCaptionTopOffset(int yOffsetPercent) {
        this.yCardCaptionOffsetPercent = yOffsetPercent;
    }

    public int getCardCaptionTopOffset() {
        return this.yCardCaptionOffsetPercent;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public CardView getGameCard() {
        return this.gameCard;
    }

    public void setGameCard(CardView gameCard) {
        this.gameCard = gameCard;
    }

    private void setGameCardSides(CardView gameCard) {
        CardView original;
        if (this.cardSideMain == null) {
            this.cardSideMain = gameCard;
            this.cardSideOther = gameCard.getSecondCardFace();
        } else if (this.cardSideMain.getName().equals(gameCard.getName())) {
            this.cardSideMain = gameCard;
            this.cardSideOther = gameCard.getSecondCardFace();
        } else {
            this.cardSideOther = gameCard;
            return;
        }
        if ((this.cardSideOther == null || this.cardSideOther.getName().equals(this.cardSideMain.getName())) && this.cardSideMain instanceof PermanentView && (original = ((PermanentView)this.cardSideMain).getOriginal()) != null && !original.getName().equals(this.getName())) {
            this.cardSideOther = original;
        }
    }

    public CardView getUpdateCard() {
        return this.updateCard;
    }

    public void setUpdateCard(CardView updateCard) {
        this.updateCard = updateCard;
    }

    public double getTappedAngle() {
        return this.tappedAngle;
    }

    public void setTappedAngle(double tappedAngle) {
        this.tappedAngle = tappedAngle;
    }

    public double getFlippedAngle() {
        return this.flippedAngle;
    }

    public void setFlippedAngle(double flippedAngle) {
        this.flippedAngle = flippedAngle;
    }

    public boolean contains(int x, int y) {
        MageCardLocation needLocation = this.getCardLocation();
        Rectangle normalRect = new Rectangle(0, 0, needLocation.getCardWidth(), needLocation.getCardHeight());
        Rectangle animatedRect = MageLayer.animateCoords((MageCard)this, normalRect);
        return animatedRect.contains(x, y);
    }

    public Font getFont() {
        Font res = super.getFont();
        if (res == null) {
            res = GUISizeHelper.getCardFont();
        }
        return res;
    }
}

