/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import mage.client.util.GUISizeHelper;
import org.mage.card.arcane.CardRendererUtils;
import org.mage.card.arcane.ManaSymbols;

public final class ManaSymbolsCellRenderer
extends DefaultTableCellRenderer {
    private final JPanel renderPanel = new JPanel();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultTableCellRenderer baseRenderer = (DefaultTableCellRenderer)table.getDefaultRenderer(String.class);
        JLabel baseComp = (JLabel)baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.renderPanel.setOpaque(baseComp.isOpaque());
        this.renderPanel.setForeground(CardRendererUtils.copyColor(baseComp.getForeground()));
        this.renderPanel.setBackground(CardRendererUtils.copyColor(baseComp.getBackground()));
        this.renderPanel.setBorder(baseComp.getBorder());
        int symbolWidth = GUISizeHelper.symbolTableSize;
        int symbolHorizontalMargin = 2;
        String manaCost = (String)value;
        this.renderPanel.removeAll();
        this.renderPanel.setLayout(new BoxLayout(this.renderPanel, 0));
        if (manaCost != null) {
            StringTokenizer tok = new StringTokenizer(manaCost, " ");
            while (tok.hasMoreTokens()) {
                String symbol = tok.nextToken();
                JLabel symbolLabel = new JLabel();
                symbolLabel.setFont(GUISizeHelper.tableFont);
                symbolLabel.setBorder(new EmptyBorder(0, symbolHorizontalMargin, 0, 0));
                BufferedImage image = ManaSymbols.getSizedManaSymbol(symbol, symbolWidth);
                if (image != null) {
                    symbolLabel.setIcon(new ImageIcon(image));
                } else {
                    if (symbol.equals("*")) {
                        symbolLabel.setText(" / ");
                    } else {
                        symbolLabel.setText("{" + symbol + "}");
                    }
                    symbolLabel.setOpaque(false);
                    symbolLabel.setForeground(baseComp.getForeground());
                    symbolLabel.setBackground(baseComp.getBackground());
                }
                this.renderPanel.add(symbolLabel);
            }
        }
        return this.renderPanel;
    }
}

