/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.MageInt;
import mage.ObjectColor;
import mage.cards.ArtRect;
import mage.cards.FrameStyle;
import mage.client.dialog.PreferencesDialog;
import mage.constants.CardType;
import mage.constants.MageObjectType;
import mage.constants.SubType;
import mage.util.SubTypes;
import mage.view.CardView;
import mage.view.PermanentView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.CardPanelAttributes;
import org.mage.card.arcane.CardRenderer;
import org.mage.card.arcane.CardRendererUtils;
import org.mage.card.arcane.GlowText;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.ModernCardResourceLoader;
import org.mage.card.arcane.TextboxBasicManaRule;
import org.mage.card.arcane.TextboxLoyaltyRule;
import org.mage.card.arcane.TextboxRule;
import org.mage.card.arcane.TextboxRuleType;

public class ModernCardRenderer
extends CardRenderer {
    private static final Logger LOGGER = Logger.getLogger(ModernCardRenderer.class);
    private static final GlowText glowTextRenderer = new GlowText();
    public static final Color MANA_ICONS_TEXT_COLOR = Color.DARK_GRAY;
    public static final Paint BG_TEXTURE_WHITE = ModernCardResourceLoader.loadBackgroundTexture("white");
    public static final Paint BG_TEXTURE_BLUE = ModernCardResourceLoader.loadBackgroundTexture("blue");
    public static final Paint BG_TEXTURE_BLACK = ModernCardResourceLoader.loadBackgroundTexture("black");
    public static final Paint BG_TEXTURE_RED = ModernCardResourceLoader.loadBackgroundTexture("red");
    public static final Paint BG_TEXTURE_GREEN = ModernCardResourceLoader.loadBackgroundTexture("green");
    public static final Paint BG_TEXTURE_GOLD = ModernCardResourceLoader.loadBackgroundTexture("gold");
    public static final Paint BG_TEXTURE_ARTIFACT = ModernCardResourceLoader.loadBackgroundTexture("artifact");
    public static final Paint BG_TEXTURE_LAND = ModernCardResourceLoader.loadBackgroundTexture("land");
    public static final Paint BG_TEXTURE_VEHICLE = ModernCardResourceLoader.loadBackgroundTexture("vehicle");
    public static final BufferedImage BG_IMG_WHITE = ModernCardResourceLoader.loadBackgroundImage("white");
    public static final BufferedImage BG_IMG_BLUE = ModernCardResourceLoader.loadBackgroundImage("blue");
    public static final BufferedImage BG_IMG_BLACK = ModernCardResourceLoader.loadBackgroundImage("black");
    public static final BufferedImage BG_IMG_RED = ModernCardResourceLoader.loadBackgroundImage("red");
    public static final BufferedImage BG_IMG_GREEN = ModernCardResourceLoader.loadBackgroundImage("green");
    public static final BufferedImage BG_IMG_GOLD = ModernCardResourceLoader.loadBackgroundImage("gold");
    public static final BufferedImage BG_IMG_ARTIFACT = ModernCardResourceLoader.loadBackgroundImage("artifact");
    public static final BufferedImage BG_IMG_LAND = ModernCardResourceLoader.loadBackgroundImage("land");
    public static final BufferedImage BG_IMG_VEHICLE = ModernCardResourceLoader.loadBackgroundImage("vehicle");
    public static final BufferedImage BG_IMG_COLORLESS = ModernCardResourceLoader.loadBackgroundImage("colorless");
    public static final BufferedImage BG_IMG_EXPEDITION = ModernCardResourceLoader.loadBackgroundImage("expedition");
    public static final BufferedImage FRAME_INVENTION = ModernCardResourceLoader.loadFramePart("invention_frame");
    public static final Color BORDER_WHITE = new Color(216, 203, 188);
    public static final Color BORDER_BLUE = new Color(20, 121, 175);
    public static final Color BORDER_BLACK = new Color(45, 45, 35);
    public static final Color BORDER_RED = new Color(201, 71, 58);
    public static final Color BORDER_GREEN = new Color(4, 136, 69);
    public static final Color BORDER_GOLD = new Color(255, 228, 124);
    public static final Color BORDER_COLORLESS = new Color(208, 212, 212);
    public static final Color BORDER_LAND = new Color(190, 173, 115);
    public static final Color BOX_WHITE = new Color(244, 245, 239);
    public static final Color BOX_BLUE = new Color(201, 223, 237);
    public static final Color BOX_BLACK = new Color(204, 194, 192);
    public static final Color BOX_RED = new Color(246, 208, 185);
    public static final Color BOX_GREEN = new Color(205, 221, 213);
    public static final Color BOX_GOLD = new Color(223, 195, 136);
    public static final Color BOX_COLORLESS = new Color(200, 208, 212);
    public static final Color BOX_LAND = new Color(220, 215, 213);
    public static final Color BOX_INVENTION = new Color(209, 97, 33);
    public static final Color BOX_VEHICLE = new Color(155, 105, 60);
    public static final Color BOX_UST_WHITE = new Color(240, 240, 220);
    public static final Color BOX_UST_BLUE = new Color(10, 100, 180);
    public static final Color BOX_UST_BLACK = new Color(28, 30, 28);
    public static final Color BOX_UST_RED = new Color(229, 74, 32);
    public static final Color BOX_UST_GREEN = new Color(7, 130, 53);
    public static final Color BOX_WHITE_NIGHT = new Color(169, 160, 145);
    public static final Color BOX_BLUE_NIGHT = new Color(46, 133, 176);
    public static final Color BOX_BLACK_NIGHT = new Color(95, 90, 89);
    public static final Color BOX_RED_NIGHT = new Color(188, 87, 57);
    public static final Color BOX_GREEN_NIGHT = new Color(31, 100, 44);
    public static final Color BOX_GOLD_NIGHT = new Color(171, 134, 70);
    public static final Color BOX_COLORLESS_NIGHT = new Color(118, 147, 158);
    public static final Color LAND_TEXTBOX_WHITE = new Color(248, 232, 188, 234);
    public static final Color LAND_TEXTBOX_BLUE = new Color(189, 212, 236, 234);
    public static final Color LAND_TEXTBOX_BLACK = new Color(174, 164, 162, 234);
    public static final Color LAND_TEXTBOX_RED = new Color(242, 168, 133, 234);
    public static final Color LAND_TEXTBOX_GREEN = new Color(198, 220, 198, 234);
    public static final Color LAND_TEXTBOX_GOLD = new Color(236, 229, 207, 234);
    public static final Color LAND_SPIRAL_TEXTBOX_WHITE = new Color(248, 232, 188, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_BLUE = new Color(189, 212, 236, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_BLACK = new Color(174, 164, 162, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_RED = new Color(242, 168, 133, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_GREEN = new Color(198, 220, 198, 220);
    public static final Color TEXTBOX_WHITE = new Color(252, 249, 244, 234);
    public static final Color TEXTBOX_BLUE = new Color(229, 238, 247, 234);
    public static final Color TEXTBOX_BLACK = new Color(241, 241, 240, 234);
    public static final Color TEXTBOX_RED = new Color(243, 224, 217, 234);
    public static final Color TEXTBOX_GREEN = new Color(217, 232, 223, 234);
    public static final Color TEXTBOX_GOLD = new Color(240, 234, 209, 234);
    public static final Color TEXTBOX_COLORLESS = new Color(199, 209, 213, 234);
    public static final Color TEXTBOX_LAND = new Color(218, 214, 212, 234);
    public static final Color ERROR_COLOR = new Color(255, 0, 255);
    static String SUB_TYPE_ADVENTURE = "Adventure";
    static String SUB_TYPE_OMEN = "Omen";
    protected int contentInset;
    protected int totalContentInset;
    protected int contentWidth;
    protected static final float BOX_HEIGHT_FRAC = 0.065f;
    protected static final int BOX_HEIGHT_MIN = 16;
    protected int boxHeight;
    protected static final float TYPE_LINE_Y_FRAC = 0.57f;
    protected static final float TYPE_LINE_Y_FRAC_TOKEN = 0.7f;
    protected static final float TYPE_LINE_Y_FRAC_FULL_ART = 0.74f;
    protected static final float TYPE_LINE_Y_FRAC_BOTTOM = 0.89f;
    protected int typeLineY;
    protected static final int[] RULES_TEXT_FONT_SIZES = new int[]{24, 18, 15, 12, 9};
    protected int boxTextHeight;
    protected int boxTextOffset;
    protected Font boxTextFont;
    protected Font boxTextFontNarrow;
    protected int ptTextHeight;
    protected int ptTextOffset;
    protected Font ptTextFont;
    protected String manaCostString = ManaSymbols.getClearManaCost(this.cardView.getManaCostStr());
    protected boolean isCardWithSpellOption = false;
    protected boolean loyaltyAbilityColorToggle = false;

    public ModernCardRenderer(CardView card) {
        super(card);
        if (this.cardView.isSplitCard()) {
            this.isCardWithSpellOption = this.cardView.getRightSplitTypeLine().contains(SUB_TYPE_ADVENTURE) || this.cardView.getRightSplitTypeLine().contains(SUB_TYPE_OMEN);
        }
    }

    protected boolean isCardWithSpellOption() {
        return this.isCardWithSpellOption;
    }

    @Override
    protected void layout(int cardWidth, int cardHeight) {
        super.layout(cardWidth, cardHeight);
        this.contentInset = this.borderWidth;
        this.totalContentInset = this.borderWidth + this.contentInset;
        this.contentWidth = cardWidth - 2 * this.totalContentInset;
        this.boxHeight = (int)Math.max(16.0f, 0.065f * (float)cardHeight);
        this.typeLineY = (int)(this.getTypeLineYFrac() * (float)cardHeight);
        this.boxTextHeight = ModernCardRenderer.getTextHeightForBoxHeight(this.boxHeight);
        this.boxTextOffset = (this.boxHeight - this.boxTextHeight) / 2;
        this.boxTextFont = new Font("Arial", 0, this.boxTextHeight);
        this.boxTextFontNarrow = new Font("Arial Narrow", 0, this.boxTextHeight);
        this.ptTextHeight = ModernCardRenderer.getPTTextHeightForLineHeight(this.boxHeight);
        this.ptTextOffset = (this.boxHeight - this.ptTextHeight) / 2;
        this.ptTextFont = new Font("Arial", 1, this.ptTextHeight);
    }

    @Override
    protected void drawBorder(Graphics2D g) {
        Color borderColor = this.isSelected ? Color.green : (this.isChoosable ? new Color(250, 250, 0, 230) : (this.cardView.isPlayable() ? new Color(153, 102, 204, 200) : (this.cardView.isCanAttack() ? new Color(255, 50, 50, 230) : (this.cardView.isCanBlock() ? new Color(255, 50, 50, 230) : Color.BLACK))));
        g.setColor(borderColor);
        g.fillRoundRect(0, 0, this.cardWidth, this.cardHeight, this.cornerRadius, this.cornerRadius);
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        if (this.cardView.isFaceDown()) {
            this.drawCardBackTexture(g);
        } else {
            BufferedImage bg;
            if (this.cardView.getFrameStyle() == FrameStyle.UST_FULL_ART_BASIC) {
                return;
            }
            boolean isExped = false;
            if (this.cardView.getExpansionSetCode().equals("EXP")) {
                isExped = true;
            }
            if ((bg = ModernCardRenderer.getBackgroundTexture(this.cardView.getColor(), this.cardView.getCardTypes(), this.cardView.getSubTypes(), isExped)) == null) {
                return;
            }
            int bgw = bg.getWidth();
            int bgh = bg.getHeight();
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(this.borderWidth, this.borderWidth, this.cardWidth - this.borderWidth * 2, this.cardHeight - this.borderWidth * 4 - this.cornerRadius * 2, this.cornerRadius - 1, this.cornerRadius - 1);
            Area a = new Area(rr);
            RoundRectangle2D.Double rr2 = new RoundRectangle2D.Double(this.borderWidth, this.cardHeight - this.borderWidth * 4 - this.cornerRadius * 4, this.cardWidth - this.borderWidth * 2, this.cornerRadius * 4, this.cornerRadius * 2, this.cornerRadius * 2);
            a.add(new Area(rr2));
            Rectangle r = new Rectangle(this.borderWidth + this.contentInset, this.cardHeight - this.borderWidth * 5, this.cardWidth - this.borderWidth * 2 - this.contentInset * 2, this.borderWidth * 2);
            a.add(new Area(r));
            g.setClip(a);
            g.drawImage(bg, 0, 0, this.cardWidth, this.cardHeight, 0, 0, bgw, bgh, BOX_BLUE, null);
            g.setClip(null);
        }
    }

    private Rectangle2D getArtRect() {
        Rectangle2D rect = this.useInventionFrame() ? new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f) : (this.isZendikarFullArtLand() ? new Rectangle2D.Float(0.079f, 0.11f, 0.84f, 0.84f) : (this.isUnstableFullArtLand() ? new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f) : (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_LEFT || this.cardView.getArtRect() == ArtRect.FULL_LENGTH_RIGHT || this.cardView.getArtRect() == ArtRect.RETRO ? this.cardView.getArtRect().rect : (this.cardView.getFrameStyle().isFullArt() || this.cardView.isToken() ? new Rectangle2D.Float(0.079f, 0.11f, 0.84f, 0.63f) : ArtRect.NORMAL.rect))));
        return rect;
    }

    private float getTypeLineYFrac() {
        if (this.cardView.isToken() && this.cardView.getCardNumber().isEmpty()) {
            return 0.7f;
        }
        if (this.cardView.getFrameStyle().isFullArt()) {
            return 0.74f;
        }
        if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_LEFT || this.cardView.getArtRect() == ArtRect.FULL_LENGTH_RIGHT) {
            return 0.89f;
        }
        return 0.57f;
    }

    private boolean isZendikarFullArtLand() {
        return this.cardView.getFrameStyle() == FrameStyle.BFZ_FULL_ART_BASIC || this.cardView.getFrameStyle() == FrameStyle.ZEN_FULL_ART_BASIC;
    }

    private boolean isUnstableFullArtLand() {
        return this.cardView.getFrameStyle() == FrameStyle.UST_FULL_ART_BASIC;
    }

    private boolean isOriginalDualLand() {
        return this.cardView.getFrameStyle() == FrameStyle.LEA_ORIGINAL_DUAL_LAND_ART_BASIC;
    }

    protected boolean isSourceArtFullArt() {
        int color = this.artImage.getRGB(0, this.artImage.getHeight() / 2);
        return (color & 0xFF0000) > 0x200000 || (color & 0xFF00) > 8192 || (color & 0xFF) > 32;
    }

    private boolean useInventionFrame() {
        if (this.cardView.getFrameStyle() != FrameStyle.KLD_INVENTION) {
            return false;
        }
        if (this.artImage == null) {
            return true;
        }
        return this.isSourceArtFullArt();
    }

    @Override
    protected void drawArt(Graphics2D g) {
        if (this.artImage != null) {
            ArtRect rect;
            if (this.useInventionFrame()) {
                this.drawArtIntoRect(g, this.borderWidth, this.borderWidth, this.cardWidth - 2 * this.borderWidth, this.cardHeight - 2 * this.borderWidth, this.getArtRect(), false);
            }
            boolean shouldPreserveAspect = true;
            Rectangle2D sourceRect = this.getArtRect();
            if (this.cardView.getMageObjectType() == MageObjectType.SPELL && (rect = this.cardView.getArtRect()) != ArtRect.NORMAL) {
                sourceRect = rect.rect;
                shouldPreserveAspect = false;
            }
            if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_RIGHT) {
                this.drawArtIntoRect(g, this.contentWidth / 2 + this.totalContentInset + 1, this.totalContentInset + this.boxHeight, this.contentWidth / 2 - 1, this.typeLineY - this.totalContentInset - this.boxHeight, sourceRect, false);
            } else if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_LEFT) {
                this.drawArtIntoRect(g, this.totalContentInset + 1, this.totalContentInset + this.boxHeight, this.contentWidth / 2 - 1, this.typeLineY - this.totalContentInset - this.boxHeight, sourceRect, false);
            } else if (!this.isZendikarFullArtLand()) {
                this.drawArtIntoRect(g, this.totalContentInset + 1, this.totalContentInset + this.boxHeight, this.contentWidth - 2, this.typeLineY - this.totalContentInset - this.boxHeight, sourceRect, shouldPreserveAspect);
            }
        }
    }

    @Override
    protected void drawFrame(Graphics2D g, CardPanelAttributes attribs, BufferedImage image, boolean lessOpaqueRulesTextBox) {
        int y;
        int x;
        ObjectColor frameColors = this.getFrameObjectColor();
        Color boxColor = this.getBoxColor(frameColors, this.cardView.getCardTypes(), attribs.isTransformed);
        Color additionalBoxColor = this.getAdditionalBoxColor(frameColors, this.cardView.getCardTypes(), attribs.isTransformed);
        Paint textboxPaint = ModernCardRenderer.getTextboxPaint(frameColors, this.cardView.getCardTypes(), this.cardWidth, lessOpaqueRulesTextBox);
        Paint borderPaint = ModernCardRenderer.getBorderPaint(frameColors, this.cardView.getCardTypes(), this.cardWidth);
        if (this.cardView.getFrameStyle() == FrameStyle.KLD_INVENTION) {
            boxColor = BOX_INVENTION;
        }
        boolean isZenUst = this.isZendikarFullArtLand() || this.isUnstableFullArtLand();
        boolean isOriginalDual = this.isOriginalDualLand();
        g.setPaint(borderPaint);
        if (this.cardView.getFrameStyle() == FrameStyle.KLD_INVENTION) {
            g.drawImage(FRAME_INVENTION, 3, 3, this.cardWidth - 6, this.cardHeight - 6, null);
            g.drawRect(this.totalContentInset, this.typeLineY, this.contentWidth - 1, this.cardHeight - this.borderWidth * 3 - this.typeLineY - 1);
        } else if (!isZenUst) {
            g.drawRect(this.totalContentInset, this.totalContentInset, this.contentWidth - 1, this.cardHeight - this.borderWidth * 3 - this.totalContentInset - 1);
        }
        if (this.useInventionFrame()) {
            g.setPaint(new Color(255, 255, 255, 150));
        } else {
            g.setPaint(textboxPaint);
        }
        if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_RIGHT) {
            g.fillRect(this.totalContentInset + 2, this.totalContentInset + this.boxHeight, this.contentWidth / 2 - 2, this.typeLineY - this.totalContentInset - this.boxHeight + 2);
        } else if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_LEFT) {
            g.fillRect(this.contentWidth / 2 + this.totalContentInset + 1, this.totalContentInset + this.boxHeight, this.contentWidth / 2 - 2, this.typeLineY - this.totalContentInset - this.boxHeight + 2);
        } else if (!isZenUst) {
            if (this.cardView.getCardTypes().contains((Object)CardType.LAND)) {
                int total_height_of_box = this.cardHeight - this.borderWidth * 3 - this.typeLineY - 2 - this.boxHeight;
                int height_of_spiral = (int)Math.round((double)total_height_of_box / 16.5);
                int total_height_spiral = total_height_of_box;
                List<ObjectColor> twoColors = frameColors.getColors();
                if (twoColors.size() <= 2) {
                    if (isOriginalDual && twoColors.size() == 2) {
                        g.setPaint(ModernCardRenderer.getSpiralLandTextboxColor(twoColors.get(0), twoColors.get(1), false));
                    }
                    g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight + 1, this.contentWidth - 2, total_height_of_box);
                }
                if (frameColors.getColorCount() >= 3) {
                    g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight + 1, this.contentWidth - 2, total_height_of_box);
                }
                if (frameColors.getColorCount() == 2 && isOriginalDual) {
                    g.setPaint(ModernCardRenderer.getSpiralLandTextboxColor(twoColors.get(0), twoColors.get(1), true));
                    g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight + 1, this.contentWidth - 2, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 2 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 2 * height_of_spiral, this.contentWidth - 2 - 4 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 4 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 4 * height_of_spiral, this.contentWidth - 2 - 8 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 6 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 6 * height_of_spiral, this.contentWidth - 2 - 12 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 6 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + total_height_of_box - 7 * height_of_spiral, this.contentWidth - 2 - 12 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 4 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + total_height_of_box - 5 * height_of_spiral, this.contentWidth - 2 - 8 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 2 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + total_height_of_box - 3 * height_of_spiral, this.contentWidth - 2 - 4 * height_of_spiral, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight + 1 + total_height_of_box - height_of_spiral, this.contentWidth - 2, height_of_spiral);
                    g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight + 1, height_of_spiral, total_height_spiral - 1);
                    g.fillRect(this.totalContentInset + 1 + 2 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 2 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 4 * height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 4 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 4 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 8 * height_of_spiral);
                    g.fillRect(this.totalContentInset + 1 + 6 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 6 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 12 * height_of_spiral);
                    g.fillRect(this.totalContentInset + this.contentWidth - 7 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 6 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 12 * height_of_spiral);
                    g.fillRect(this.totalContentInset + this.contentWidth - 5 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 4 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 8 * height_of_spiral);
                    g.fillRect(this.totalContentInset + this.contentWidth - 3 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 2 * height_of_spiral, height_of_spiral, total_height_spiral - 1 - 4 * height_of_spiral);
                    g.fillRect(this.totalContentInset + this.contentWidth - 1 * height_of_spiral, this.typeLineY + this.boxHeight + 1 + 0 * height_of_spiral, height_of_spiral, total_height_spiral - 1);
                }
            } else {
                g.fillRect(this.totalContentInset + 1, this.typeLineY, this.contentWidth - 2, this.cardHeight - this.borderWidth * 3 - this.typeLineY - 1);
            }
        }
        if (this.cardView.isPlaneswalker()) {
            g.setPaint(borderPaint);
            g.fillRect(this.totalContentInset, this.typeLineY + this.boxHeight, this.cardWidth / 16, this.cardHeight - this.typeLineY - this.boxHeight - this.borderWidth * 3);
        }
        if (this.cardView.getFrameStyle() != FrameStyle.KLD_INVENTION && !isZenUst) {
            g.setColor(new Color(0, 0, 0, 100));
            g.fillRect(this.totalContentInset - 1, this.totalContentInset, 1, this.cardHeight - this.borderWidth * 3 - this.totalContentInset - 1);
            g.drawRect(this.totalContentInset + 1, this.totalContentInset + this.boxHeight, this.contentWidth - 3, this.typeLineY - this.totalContentInset - this.boxHeight - 1);
        }
        CardRendererUtils.drawRoundedBox(g, this.borderWidth, this.totalContentInset, this.cardWidth - 2 * this.borderWidth, this.boxHeight, this.contentInset, borderPaint, boxColor);
        if (!isZenUst) {
            CardRendererUtils.drawRoundedBox(g, this.borderWidth, this.typeLineY, this.cardWidth - 2 * this.borderWidth, this.boxHeight, this.contentInset, borderPaint, boxColor);
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(this.totalContentInset - 1, this.totalContentInset - 1, this.contentWidth + 1, 1);
            g.fillRect(this.totalContentInset + 1, this.typeLineY + this.boxHeight, this.contentWidth - 2, 1);
            g.fillRect(this.cardWidth - this.totalContentInset - 1, this.typeLineY + this.boxHeight, 1, this.cardHeight - this.borderWidth * 3 - this.typeLineY - this.boxHeight);
            this.drawTypeLine(g, attribs, this.getCardTypeLine(), this.totalContentInset, this.typeLineY, this.contentWidth, this.boxHeight, true);
        }
        int nameOffset = this.drawTransformationCircle(g, attribs, borderPaint);
        this.drawNameLine(g, attribs, this.cardView.getDisplayName(), this.manaCostString, this.totalContentInset + nameOffset, this.totalContentInset, this.contentWidth - nameOffset, this.boxHeight);
        if (this.isZendikarFullArtLand()) {
            x = this.totalContentInset;
            y = this.typeLineY + this.boxHeight + (this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3) / 2 - this.contentInset;
            int w = this.contentWidth;
            int h = this.boxHeight - 4;
            if (this.cardView.getFrameStyle() == FrameStyle.ZEN_FULL_ART_BASIC) {
                int x2 = x + this.contentWidth;
                int y2 = y;
                int thisy = this.totalContentInset + this.boxHeight;
                this.drawZendikarCurvedFace(g, image, x, thisy, x2, y2, boxColor, borderPaint);
            } else if (this.cardView.getFrameStyle() == FrameStyle.BFZ_FULL_ART_BASIC) {
                int y2 = y;
                int yb = this.totalContentInset + this.boxHeight;
                int topxdelta = 45 * this.contentWidth / 1000;
                int endydelta = 60 * (this.totalContentInset + y2) / 265;
                int x2 = x + this.contentWidth;
                this.drawBFZCurvedFace(g, image, x, yb, x2, y2, topxdelta, endydelta, boxColor, borderPaint);
            }
            if (this.cardView.getExpansionSetCode().equals("EXP")) {
                g.setPaint(textboxPaint);
                float alpha = 0.55f;
                AlphaComposite comp = AlphaComposite.getInstance(3, alpha);
                Composite origc = g.getComposite();
                g.setComposite(comp);
                g.setBackground(new Color(155, 0, 0, 150));
                g.fillRect(this.totalContentInset + 1, this.typeLineY - this.boxHeight, this.contentWidth - 2, this.cardHeight - this.borderWidth * 3 - this.typeLineY - 1);
                g.setComposite(origc);
                g.fillRect(this.totalContentInset - 1, this.totalContentInset - 1, this.contentWidth + 1, 1);
                g.fillRect(this.totalContentInset + 1, this.typeLineY - this.boxHeight, this.contentWidth - 2, 1);
                this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.totalContentInset + 2, this.typeLineY - this.boxHeight, this.contentWidth - 4, this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3, true);
            }
            CardRendererUtils.drawZendikarLandBox(g, x, y, w, h, this.contentInset, borderPaint, boxColor);
            this.drawTypeLine(g, attribs, this.getCardSuperTypeLine(), this.totalContentInset + this.contentInset, this.typeLineY + this.boxHeight + (this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3) / 2 - this.contentInset, this.contentWidth / 2 - this.boxHeight, this.boxHeight - 4, false);
            this.drawTypeLine(g, attribs, this.getCardSubTypeLine(), this.totalContentInset + 4 * this.contentWidth / 7 + this.boxHeight, this.typeLineY + this.boxHeight + (this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3) / 2 - this.contentInset, 3 * this.contentWidth / 7 - this.boxHeight - this.contentInset, this.boxHeight - 4, true);
            this.drawRulesText(g, this.textboxKeywords, this.textboxRules, x, y, w, h, false);
        } else if (this.isUnstableFullArtLand()) {
            x = 0;
            y = 0;
            int w = this.cardWidth;
            int h = this.cardHeight;
            this.drawUSTCurves(g, image, x, y, w, h, 0, 0, additionalBoxColor, borderPaint);
        } else if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_RIGHT) {
            this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.totalContentInset + 4, this.totalContentInset + this.boxHeight + 2, this.contentWidth / 2 - 8, this.typeLineY - this.totalContentInset - this.boxHeight - 6, false);
        } else if (this.cardView.getArtRect() == ArtRect.FULL_LENGTH_LEFT) {
            this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.contentWidth / 2 + this.totalContentInset + 4, this.totalContentInset + this.boxHeight + 2, this.contentWidth / 2 - 8, this.typeLineY - this.totalContentInset - this.boxHeight - 6, false);
        } else if (this.isCardWithSpellOption) {
            this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.contentWidth / 2 + this.totalContentInset + 4, this.typeLineY + this.boxHeight + 2, this.contentWidth / 2 - 8, this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3, false);
        } else if (!isZenUst) {
            this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.totalContentInset + 2, this.typeLineY + this.boxHeight + 2, this.contentWidth - 4, this.cardHeight - this.typeLineY - this.boxHeight - 4 - this.borderWidth * 3, false);
        }
        this.drawBottomRight(g, attribs, borderPaint, boxColor);
    }

    public void drawZendikarCurvedFace(Graphics2D g2, BufferedImage image, int x, int y, int x2, int y2, Color boxColor, Paint paint) {
        if (this.artImage == null) {
            return;
        }
        BufferedImage artToUse = this.artImage;
        int srcW = artToUse.getWidth();
        int srcH = artToUse.getHeight();
        int subx = 19 * srcW / 223;
        int suby = 38 * srcH / 310;
        artToUse = this.artImage.getSubimage(subx, suby, 185 * srcW / 223, 220 * srcH / 310);
        Path2D.Double curve = new Path2D.Double();
        int ew = x2 - x;
        int eh = 700 * (y2 - y) / 335;
        Arc2D.Double arc = new Arc2D.Double(x, y - 197 * eh / 700, ew, eh, 0.0, 360.0, 0);
        Arc2D.Double innerarc = new Arc2D.Double(x + 1, y - 197 * eh / 700 + 1, ew - 2, eh - 2, 0.0, 360.0, 0);
        curve.append(new Rectangle2D.Double(x, y, x2 - x, y2 - y), false);
        g2.setClip(new Rectangle2D.Double(x, y, x2 - x, y2 - y));
        g2.setClip(arc);
        Rectangle2D r = curve.getBounds2D();
        g2.drawImage(artToUse, x, y, x2 - x, y2 - y, null);
        g2.setClip(null);
        g2.setClip(new Rectangle2D.Double(x, y, x2 - x, y2 - y));
        g2.setColor(CardRendererUtils.abitdarker(boxColor));
        g2.draw(arc);
        g2.setColor(Color.black);
        g2.draw(innerarc);
        g2.setClip(null);
    }

    public void drawBFZCurvedFace(Graphics2D g2, BufferedImage image, int x, int y, int x2, int y2, int topxdelta, int endydelta, Color boxColor, Paint paint) {
        if (this.artImage == null) {
            return;
        }
        BufferedImage artToUse = this.artImage;
        int srcW = artToUse.getWidth();
        int srcH = artToUse.getHeight();
        int subx = 19 * srcW / 223;
        int suby = 38 * srcH / 310;
        artToUse = this.artImage.getSubimage(subx, suby, 185 * srcW / 223, 220 * srcH / 310);
        Path2D.Double curve = new Path2D.Double();
        curve.moveTo(x + topxdelta, y);
        curve.quadTo(x, y + endydelta / 2, x, y + endydelta);
        curve.lineTo(x, y2);
        curve.lineTo(x2, y2);
        curve.lineTo(x2, y + endydelta);
        curve.quadTo(x2, y + endydelta / 2, x2 - topxdelta, y);
        curve.lineTo(x + topxdelta, y);
        Path2D.Double innercurve = new Path2D.Double();
        innercurve.moveTo(x + topxdelta, y + 1);
        innercurve.quadTo(x + 1, y + endydelta / 2, x + 1, y + endydelta);
        innercurve.lineTo(x + 1, y2 - 1);
        innercurve.lineTo(x2 - 1, y2 - 1);
        innercurve.lineTo(x2 - 1, y + endydelta);
        innercurve.quadTo(x2 - 1, y + endydelta / 2, x2 - topxdelta, y + 1);
        innercurve.lineTo(x + topxdelta, y + 1);
        Rectangle2D r = curve.getBounds2D();
        int minX = (int)r.getX();
        g2.setClip(curve);
        g2.drawImage(artToUse, minX, y, x2 - x + (x - minX) * 2, y2 - y, null);
        g2.setClip(null);
        g2.setColor(CardRendererUtils.abitdarker(boxColor));
        g2.setPaint(paint);
        g2.draw(curve);
        g2.setColor(Color.black);
        g2.draw(innercurve);
    }

    public void drawUSTCurves(Graphics2D g2, BufferedImage image, int x, int y, int x2, int y2, int topxdelta, int endydelta, Color boxColor, Paint paint) {
        BufferedImage artToUse = this.artImage;
        int srcW = x2;
        int srcH = y2;
        if (artToUse != null) {
            srcW = artToUse.getWidth();
            srcH = artToUse.getHeight();
        }
        g2.setPaint(paint);
        int scan_width = 384;
        int scan_height = 534;
        int scan_ew = 196;
        int scan_eh = 254;
        int offset_ew = 159;
        int offset_eh = 41;
        int middle_ew = 52;
        int middle_eh = 26;
        int ex = (offset_ew - scan_ew) * x2 / scan_width;
        int ey = y2 - (offset_eh + scan_eh) * y2 / scan_height;
        int bot_ey = y2 - offset_eh * y2 / scan_height;
        int ew = scan_ew * x2 / scan_width;
        int eh = scan_eh * y2 / scan_height;
        int end_curve_ex = ex + ew / 2;
        Arc2D.Double arc = new Arc2D.Double(ex, ey, ew, eh, 180.0, 90.0, 0);
        ex = x2 - offset_ew * x2 / scan_width;
        ey = y2 - (offset_eh + scan_eh) * y2 / scan_height;
        bot_ey = y2 - offset_eh * y2 / scan_height;
        Arc2D.Double arc2 = new Arc2D.Double(ex, ey, ew, eh, 270.0, 90.0, 0);
        int mid_ex = x2 / 2 - middle_ew * x2 / (scan_width * 2);
        int mid_ey = bot_ey - middle_eh * y2 / (scan_height * 2);
        int end_mid_ex = x2 / 2 + middle_ew * x2 / (scan_width * 2);
        Arc2D.Double arc3 = new Arc2D.Double(mid_ex, mid_ey, middle_ew * x2 / scan_width, middle_eh * y2 / scan_height, 180.0, -180.0, 0);
        Path2D.Double curve = new Path2D.Double();
        curve.moveTo(0.0, 0.0);
        curve.lineTo(0.0, bot_ey);
        curve.append(arc, true);
        curve.lineTo(mid_ex, bot_ey);
        curve.append(arc3, true);
        curve.lineTo(x2 - ew / 2, bot_ey);
        curve.append(arc2, true);
        curve.lineTo(x2, 0.0);
        curve.lineTo(0.0, 0.0);
        g2.setClip(curve);
        if (artToUse != null) {
            artToUse = this.artImage.getSubimage(0, 0, srcW, srcH);
            g2.drawImage(artToUse, 0, 0, x2, y2, null);
        }
        g2.setClip(null);
        g2.setStroke(new BasicStroke(3.0f));
        g2.draw(arc);
        g2.draw(new Rectangle(end_curve_ex, bot_ey, mid_ex - end_curve_ex, 0));
        g2.draw(arc3);
        g2.draw(new Rectangle(end_mid_ex, bot_ey, mid_ex - end_curve_ex, 0));
        g2.draw(arc2);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(boxColor);
    }

    protected void drawNameLine(Graphics2D g, CardPanelAttributes attribs, String baseName, String manaCost, int x, int y, int w, int h) {
        int manaCostWidth = this.cardView.isAbility() ? 0 : CardRendererUtils.getManaCostWidth(manaCost, this.boxTextHeight);
        int availableWidth = w - manaCostWidth + 2;
        if (!baseName.isEmpty()) {
            AttributedString str = new AttributedString(baseName);
            str.addAttribute(TextAttribute.FONT, this.boxTextFont);
            TextMeasurer measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
            int breakIndex = measure.getLineBreakIndex(0, availableWidth);
            if (breakIndex < baseName.length()) {
                str = new AttributedString(baseName);
                str.addAttribute(TextAttribute.FONT, this.boxTextFontNarrow);
                measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
                breakIndex = measure.getLineBreakIndex(0, availableWidth);
            }
            if (breakIndex > 0) {
                TextLayout layout = measure.getLayout(0, breakIndex);
                g.setColor(this.getBoxTextColor(attribs));
                layout.draw(g, x, y + this.boxTextOffset + this.boxTextHeight - 1);
            }
        }
        if (!this.cardView.isAbility() && !this.cardView.isFaceDown()) {
            ManaSymbols.draw(g, manaCost, x + w - manaCostWidth, y + this.boxTextOffset, this.boxTextHeight, MANA_ICONS_TEXT_COLOR, 2);
        }
    }

    protected void drawTypeLine(Graphics2D g, CardPanelAttributes attribs, String baseTypeLine, int x, int y, int w, int h, boolean withSymbol) {
        int expansionSymbolWidth = 0;
        if (PreferencesDialog.getCachedValue("cardRenderingSetSymbol", "false").equals("false")) {
            if (this.cardView.isAbility()) {
                expansionSymbolWidth = 0;
            } else if (withSymbol) {
                expansionSymbolWidth = this.drawExpansionSymbol(g, x, y, w, h);
            }
        } else {
            expansionSymbolWidth = 0;
        }
        int availableWidth = w - expansionSymbolWidth + 1;
        String types = baseTypeLine;
        g.setFont(this.boxTextFont);
        if (g.getFontMetrics().stringWidth(types) > availableWidth) {
            types = types.replace("Token", "T.");
            types = types.replace("Legendary", "L.");
        }
        if (!types.isEmpty()) {
            AttributedString str = new AttributedString(types);
            str.addAttribute(TextAttribute.FONT, this.boxTextFont);
            TextMeasurer measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
            int breakIndex = measure.getLineBreakIndex(0, availableWidth);
            if (breakIndex < types.length()) {
                str = new AttributedString(types);
                str.addAttribute(TextAttribute.FONT, this.boxTextFontNarrow);
                measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
                breakIndex = measure.getLineBreakIndex(0, availableWidth);
            }
            if (breakIndex > 0) {
                TextLayout layout = measure.getLayout(0, breakIndex);
                g.setColor(this.getBoxTextColor(attribs));
                layout.draw(g, x, y + (h - this.boxTextHeight) / 2 + this.boxTextHeight - 1);
            }
        }
    }

    public void paintOutlineTextByGlow(Graphics2D g, String text, Color color, int x, int y) {
        GlowText label = new GlowText();
        label.setGlow(Color.black, 6, 3.0f);
        label.setText(text);
        label.setFont(g.getFont().deriveFont(1));
        label.setForeground(color);
        Dimension ptSize = label.getPreferredSize();
        label.setSize(ptSize.width, ptSize.height);
        g.drawImage((Image)label.getGlowImage(), x, y, null);
    }

    public void paintOutlineTextByStroke(Graphics2D g, String text, Color color, int x, int y) {
        Color outlineColor = Color.black;
        Color fillColor = color;
        BasicStroke outlineStroke = new BasicStroke(1.0f, 1, 1);
        Color originalColor = g.getColor();
        Stroke originalStroke = g.getStroke();
        RenderingHints originalHints = g.getRenderingHints();
        GlyphVector glyphVector = g.getFont().createGlyphVector(g.getFontRenderContext(), text);
        Shape textShape = glyphVector.getOutline(x, y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(outlineColor);
        g.setStroke(outlineStroke);
        g.draw(textShape);
        g.setColor(fillColor);
        g.fill(textShape);
        g.setColor(originalColor);
        g.setStroke(originalStroke);
        g.setRenderingHints(originalHints);
    }

    protected void drawBottomRight(Graphics2D g, CardPanelAttributes attribs, Paint borderPaint, Color fill) {
        int w;
        if (this.cardView.isAbility()) {
            return;
        }
        int curY = this.cardHeight - (int)(0.03f * (float)this.cardHeight);
        int partBoxWidth = (int)Math.max(30.0f, 0.2f * (float)this.cardWidth);
        boolean isVehicle = this.cardView.getSubTypes().contains((Object)SubType.VEHICLE);
        if (this.cardView.showPT()) {
            boolean defaultTextLight;
            Color defaultTextColor;
            int ptDeviderSpace = 1;
            String ptText1 = this.cardView.getPower();
            String ptText2 = "/";
            String ptText3 = CardRendererUtils.getCardLifeWithDamage(this.cardView);
            int ptTextWidth1 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText1);
            int ptTextWidth2 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText2) + 2 * ptDeviderSpace;
            int ptTextWidth3 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText3);
            int ptContentWidth = this.contentInset + ptTextWidth1 + ptDeviderSpace + ptTextWidth2 + ptDeviderSpace + ptTextWidth3 + this.contentInset;
            partBoxWidth = Math.max(ptContentWidth, partBoxWidth);
            int x = this.cardWidth - this.borderWidth - partBoxWidth;
            CardRendererUtils.drawRoundedBox(g, x, curY - this.boxHeight, partBoxWidth, this.boxHeight, this.contentInset, borderPaint, isVehicle ? BOX_VEHICLE : fill);
            g.setColor(new Color(0, 0, 0, 150));
            g.fillRect(x + this.contentInset, curY - this.boxHeight - 1, partBoxWidth - 2 * this.contentInset, 1);
            if (isVehicle) {
                boolean isAnimated = !(this.cardView instanceof PermanentView) || this.cardView.isCreature();
                defaultTextColor = isAnimated ? Color.white : new Color(180, 180, 180);
                defaultTextLight = true;
            } else {
                defaultTextColor = this.getBoxTextColor(attribs);
                defaultTextLight = !defaultTextColor.equals(Color.black);
            }
            g.setColor(defaultTextColor);
            g.setFont(this.ptTextFont);
            MageInt currentPower = this.cardView.getOriginalPower();
            MageInt currentToughness = this.cardView.getOriginalToughness();
            int ptEmptySpace = (partBoxWidth - ptContentWidth) / 2;
            int ptPosStart1 = x + this.contentInset + ptEmptySpace;
            int ptPosStart2 = ptPosStart1 + ptTextWidth1 + ptDeviderSpace;
            int ptPosStart3 = ptPosStart2 + ptTextWidth2 + ptDeviderSpace;
            g.setColor(CardRendererUtils.getCardTextColor(currentPower, false, defaultTextColor, defaultTextLight));
            g.drawString(ptText1, ptPosStart1, curY - this.ptTextOffset - 1);
            g.setColor(defaultTextColor);
            g.drawString(ptText2, ptPosStart2, curY - this.ptTextOffset - 1);
            g.setColor(CardRendererUtils.getCardTextColor(currentToughness, CardRendererUtils.isCardWithDamage(this.cardView), defaultTextColor, defaultTextLight));
            g.drawString(ptText3, ptPosStart3, curY - this.ptTextOffset - 1);
            g.setColor(defaultTextColor);
            curY -= this.boxHeight;
        }
        if (this.cardView.isPlaneswalker() && (this.cardView instanceof PermanentView || !this.cardView.getStartingLoyalty().equals("0"))) {
            w = partBoxWidth;
            int h = partBoxWidth / 2;
            int x = this.cardWidth - partBoxWidth - this.borderWidth;
            int y = curY - h;
            Polygon symbol = new Polygon();
            symbol.addPoint(x + w / 2, y + h);
            symbol.addPoint((int)((double)x + (double)w * 0.9), (int)((double)y + 0.8 * (double)h));
            symbol.addPoint(x + w, y);
            symbol.addPoint((int)((double)x + (double)w * 0.6), (int)((double)y - 0.2 * (double)h));
            symbol.addPoint(x + w / 2, y);
            symbol.addPoint((int)((double)x + (double)w * 0.4), (int)((double)y - 0.2 * (double)h));
            symbol.addPoint(x, y);
            symbol.addPoint((int)((double)x + (double)w * 0.1), (int)((double)y + 0.8 * (double)h));
            g.setColor(Color.black);
            g.fillPolygon(symbol);
            g.setColor(new Color(200, 200, 200));
            g.setStroke(new BasicStroke(2.0f));
            g.drawPolygon(symbol);
            g.setStroke(new BasicStroke(1.0f));
            String loyalty = this.cardView instanceof PermanentView ? this.cardView.getLoyalty() : this.cardView.getStartingLoyalty();
            g.setFont(this.ptTextFont);
            g.setColor(Color.white);
            int loyaltyWidth = g.getFontMetrics().stringWidth(loyalty);
            g.drawString(loyalty, x + (w - loyaltyWidth) / 2, y + this.ptTextHeight + (h - this.ptTextHeight) / 2);
            curY -= (int)(1.2 * (double)y);
        }
        if (this.cardView.isBattle() && (this.cardView instanceof PermanentView || !this.cardView.getStartingDefense().equals("0"))) {
            w = 3 * partBoxWidth / 4;
            int h = 3 * partBoxWidth / 4;
            int x = this.cardWidth - w - this.borderWidth;
            int y = curY - h;
            Polygon symbol = new Polygon();
            symbol.addPoint(x + 0 * w / 80, y + 2 * h / 80);
            symbol.addPoint(x + 12 * w / 80, y + 30 * h / 80);
            symbol.addPoint(x + 3 * w / 80, y + 40 * h / 80);
            symbol.addPoint(x + 12 * w / 80, y + 50 * h / 80);
            symbol.addPoint(x + 0 * w / 80, y + 78 * h / 80);
            symbol.addPoint(x + 30 * w / 80, y + 71 * h / 80);
            symbol.addPoint(x + 40 * w / 80, y + 80 * h / 80);
            symbol.addPoint(x + 50 * w / 80, y + 71 * h / 80);
            symbol.addPoint(x + 80 * w / 80, y + 78 * h / 80);
            symbol.addPoint(x + 68 * w / 80, y + 50 * h / 80);
            symbol.addPoint(x + 77 * w / 80, y + 40 * h / 80);
            symbol.addPoint(x + 68 * w / 80, y + 30 * h / 80);
            symbol.addPoint(x + 80 * w / 80, y + 2 * h / 80);
            symbol.addPoint(x + 48 * w / 80, y + 9 * h / 80);
            symbol.addPoint(x + 40 * w / 80, y + 0 * h / 80);
            symbol.addPoint(x + 32 * w / 80, y + 9 * h / 80);
            g.setColor(Color.black);
            g.fillPolygon(symbol);
            g.setColor(new Color(200, 200, 200));
            g.setStroke(new BasicStroke(2.0f));
            g.drawPolygon(symbol);
            g.setStroke(new BasicStroke(1.0f));
            String defense = this.cardView instanceof PermanentView ? this.cardView.getDefense() : this.cardView.getStartingDefense();
            g.setFont(this.ptTextFont);
            g.setColor(Color.white);
            int defenseWidth = g.getFontMetrics().stringWidth(defense);
            g.drawString(defense, x + 1 + (w - defenseWidth) / 2, y - 1 + this.ptTextHeight + (h - this.ptTextHeight) / 2);
            curY -= (int)(1.2 * (double)y);
        }
        if (this.cardView instanceof PermanentView && ((PermanentView)this.cardView).getDamage() > 0) {
            int x = this.cardWidth - partBoxWidth - this.borderWidth;
            int y = curY - this.boxHeight;
            String damage = String.valueOf(((PermanentView)this.cardView).getDamage());
            g.setFont(this.ptTextFont);
            int txWidth = g.getFontMetrics().stringWidth(damage);
            g.setColor(Color.red);
            g.fillRect(x, y, partBoxWidth, this.boxHeight);
            g.setColor(Color.white);
            g.drawRect(x, y, partBoxWidth, this.boxHeight);
            g.drawString(damage, x + (partBoxWidth - txWidth) / 2, curY - 1);
        }
    }

    protected RuleLayout layoutRules(Graphics2D g, List<TextboxRule> rules, int w, int h, int fontSize) {
        Font font = new Font("Arial", 0, fontSize);
        Font fontItalic = new Font("Arial", 2, fontSize);
        ArrayList<AttributedString> attributedRules = new ArrayList<AttributedString>();
        boolean fits = true;
        int remaining = h;
        for (TextboxRule rule : rules) {
            AttributedString attributed = rule.generateAttributedString(font, fontItalic);
            attributedRules.add(attributed);
            if ((remaining -= this.drawSingleRule(g, attributed, rule, 0, 0, w, remaining, false)) >= 0) continue;
            fits = false;
            break;
        }
        RuleLayout layout = new RuleLayout();
        layout.attributedRules = attributedRules;
        layout.remainingHeight = remaining;
        layout.fits = fits;
        layout.font = font;
        layout.fontItalic = fontItalic;
        return layout;
    }

    /*
     * WARNING - void declaration
     */
    protected void drawRulesText(Graphics2D g, List<TextboxRule> keywords, List<TextboxRule> rules, int x, int y, int w, int h, boolean forceRules) {
        void var11_15;
        ArrayList<TextboxRule> allRules = new ArrayList<TextboxRule>(rules);
        if (!keywords.isEmpty()) {
            String keywordRulesString = ModernCardRenderer.getKeywordRulesString(keywords);
            TextboxRule textboxRule = new TextboxRule(keywordRulesString, new ArrayList<TextboxRule.AttributeRegion>());
            allRules.add(0, textboxRule);
        }
        if (this.isUnstableFullArtLand()) {
            return;
        }
        if (!forceRules && (allRules.size() == 1 && allRules.get(0) instanceof TextboxBasicManaRule && this.cardView.isLand() || this.isZendikarFullArtLand())) {
            if (!this.isZendikarFullArtLand()) {
                this.drawBasicManaTextbox(g, x, y, w, h, ((TextboxBasicManaRule)allRules.get(0)).getBasicManaSymbol());
                return;
            }
            if (allRules.size() == 1) {
                if (allRules.get(0) instanceof TextboxBasicManaRule) {
                    this.drawBasicManaSymbol(g, x + w / 2 - 9 * h / 8 + 1, y - 3 * h / 4, 9 * h / 4, 9 * h / 4, ((TextboxBasicManaRule)allRules.get(0)).getBasicManaSymbol());
                } else {
                    this.drawBasicManaSymbol(g, x + w / 2 - h - h / 8, y - 3 * h / 4, 9 * h / 4, 9 * h / 4, this.cardView.getFrameColor().toString());
                }
                return;
            }
            if (allRules.size() > 1) {
                this.drawBasicManaSymbol(g, x + w / 2 - h - h / 8, y - 3 * h / 4, 9 * h / 4, 9 * h / 4, this.cardView.getFrameColor().toString());
            }
            return;
        }
        RuleLayout bestLayout = null;
        for (int fontSize : RULES_TEXT_FONT_SIZES) {
            bestLayout = this.layoutRules(g, allRules, w, h, fontSize);
            if (bestLayout.fits) break;
        }
        if (bestLayout == null) {
            return;
        }
        if (bestLayout.fits) {
            int n = (int)((float)bestLayout.remainingHeight / (float)(1 + allRules.size()));
        } else {
            boolean bl = false;
        }
        this.loyaltyAbilityColorToggle = false;
        g.setColor(Color.black);
        int curY = y + var11_15;
        for (int i = 0; i < bestLayout.attributedRules.size(); ++i) {
            AttributedString attributedRule = bestLayout.attributedRules.get(i);
            TextboxRule rule = (TextboxRule)allRules.get(i);
            int adv = this.drawSingleRule(g, attributedRule, rule, x, curY, w, h, true);
            curY += adv + var11_15;
            if ((h -= adv) < 0) break;
        }
    }

    private void drawBasicManaTextbox(Graphics2D g, int x, int y, int w, int h, String symbol) {
        String symbs = symbol;
        int symbHeight = (int)(0.8 * (double)h);
        int manaCostWidth = CardRendererUtils.getManaCostWidth(symbs, symbHeight);
        ManaSymbols.draw(g, symbs, x + (w - manaCostWidth) / 2, y + (h - symbHeight) / 2, symbHeight, MANA_ICONS_TEXT_COLOR, 2);
    }

    private void drawBasicManaSymbol(Graphics2D g, int x, int y, int w, int h, String symbol) {
        String symbs2;
        String symbs = symbol;
        if (ManaSymbols.getSizedManaSymbol(symbol) != null) {
            ManaSymbols.draw(g, symbs, x, y, w, MANA_ICONS_TEXT_COLOR, 2);
        }
        if (symbol.length() == 2 && ManaSymbols.getSizedManaSymbol(symbs2 = "" + symbol.charAt(1) + symbol.charAt(0)) != null) {
            ManaSymbols.draw(g, symbs2, x, y, w, MANA_ICONS_TEXT_COLOR, 2);
        }
    }

    private static String getKeywordRulesString(List<TextboxRule> keywords) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keywords.size(); ++i) {
            builder.append(keywords.get((int)i).text);
            if (i == keywords.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private int drawSingleRule(Graphics2D g, AttributedString text, TextboxRule rule, int x, int y, int w, int h, boolean doDraw) {
        int availWidth;
        int inset = 0;
        if (rule != null && rule.type == TextboxRuleType.LOYALTY) {
            inset = this.cardWidth / 12;
        }
        if ((availWidth = w - inset) < 0) {
            return 0;
        }
        FontRenderContext frc = g.getFontRenderContext();
        AttributedCharacterIterator textIter = text.getIterator();
        LineBreakMeasurer measure = new LineBreakMeasurer(textIter, frc);
        float yPos = y;
        float remain = h;
        AttributedCharacterIterator newLineCheck = text.getIterator();
        while (measure.getPosition() < textIter.getEndIndex()) {
            char ch;
            newLineCheck.setIndex(measure.getPosition());
            while ((ch = newLineCheck.next()) != '\uffff' && ch != '\n') {
            }
            TextLayout layout = measure.nextLayout(availWidth, newLineCheck.getIndex(), false);
            float ascent = layout.getAscent();
            yPos += ascent;
            if ((remain -= ascent) < 0.0f) break;
            if (doDraw) {
                g.setColor(Color.black);
                layout.draw(g, x + inset, yPos);
            }
            yPos += layout.getDescent() + layout.getLeading() - 2.0f;
        }
        int advance = (int)Math.ceil(yPos) - y;
        if (rule != null && rule.type == TextboxRuleType.LOYALTY) {
            TextboxLoyaltyRule loyaltyRule = (TextboxLoyaltyRule)rule;
            int symbolWidth = x + inset - this.borderWidth - 4;
            int symbolHeight = (int)(0.7f * (float)symbolWidth);
            if (symbolHeight > advance) {
                advance = symbolHeight;
            }
            int symbolX = x - this.borderWidth;
            int symbolY = y + (advance - symbolHeight) / 2;
            if (doDraw) {
                Polygon symbol = loyaltyRule.loyaltyChange < 0 || loyaltyRule.loyaltyChange == 100 ? new Polygon(new int[]{symbolX, symbolX + symbolWidth, symbolX + symbolWidth, symbolX + symbolWidth / 2, symbolX}, new int[]{symbolY, symbolY, symbolY + symbolHeight - 3, symbolY + symbolHeight + 3, symbolY + symbolHeight - 3}, 5) : (loyaltyRule.loyaltyChange > 0 ? new Polygon(new int[]{symbolX, symbolX + symbolWidth / 2, symbolX + symbolWidth, symbolX + symbolWidth, symbolX}, new int[]{symbolY + 3, symbolY - 3, symbolY + 3, symbolY + symbolHeight, symbolY + symbolHeight}, 5) : new Polygon(new int[]{symbolX, symbolX + symbolWidth, symbolX + symbolWidth, symbolX}, new int[]{symbolY, symbolY, symbolY + symbolHeight, symbolY + symbolHeight}, 4));
                g.setColor(new Color(0, 0, 0, 128));
                g.fillRect(x + 2, y + advance + 1, w - 2, 1);
                g.setColor(Color.black);
                g.fillPolygon(symbol);
                g.setColor(new Color(200, 200, 200));
                g.setStroke(new BasicStroke(2.0f));
                g.drawPolygon(symbol);
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.white);
                g.setFont(this.boxTextFont);
                String loyaltyString = loyaltyRule.getChangeString();
                int textWidth = g.getFontMetrics().stringWidth(loyaltyString);
                g.drawString(loyaltyString, symbolX + (symbolWidth - textWidth) / 2, symbolY + symbolHeight - (symbolHeight - this.boxTextHeight) / 2);
                advance += 3;
                this.loyaltyAbilityColorToggle = !this.loyaltyAbilityColorToggle;
            }
        }
        return advance;
    }

    protected boolean isTransformCard(CardPanelAttributes attribs) {
        return this.cardView.canTransform() || attribs.isTransformed;
    }

    protected int drawTransformationCircle(Graphics2D g, CardPanelAttributes attribs, Paint borderPaint) {
        int transformCircleOffset = 0;
        if (this.isTransformCard(attribs)) {
            transformCircleOffset = this.boxHeight - this.contentInset;
            g.setPaint(borderPaint);
            g.drawOval(this.borderWidth, this.totalContentInset, this.boxHeight - 1, this.boxHeight - 1);
            g.setColor(Color.black);
            g.fillOval(this.borderWidth + 1, this.totalContentInset + 1, this.boxHeight - 2, this.boxHeight - 2);
            g.setColor(Color.white);
            if (attribs.isTransformed) {
                g.fillArc(this.borderWidth + 3, this.totalContentInset + 3, this.boxHeight - 6, this.boxHeight - 6, 90, 270);
                g.setColor(Color.black);
                g.fillArc(this.borderWidth + 3 + 3, this.totalContentInset + 3, this.boxHeight - 6 - 3, this.boxHeight - 6, 90, 270);
            } else {
                g.fillOval(this.borderWidth + 3, this.totalContentInset + 3, this.boxHeight - 6, this.boxHeight - 6);
            }
        }
        return transformCircleOffset;
    }

    protected static int getTextHeightForBoxHeight(int h) {
        if (h < 15) {
            return h - 3;
        }
        return (int)Math.ceil(0.6 * (double)h);
    }

    protected static int getPTTextHeightForLineHeight(int h) {
        return h - 4;
    }

    protected Color getBoxTextColor(CardPanelAttributes attribs) {
        if (attribs.isTransformed) {
            return Color.white;
        }
        if (this.cardView.isAbility()) {
            return Color.white;
        }
        return Color.black;
    }

    protected ObjectColor getFrameObjectColor() {
        return this.cardView.getColor().union(this.cardView.getFrameColor());
    }

    protected static Paint getBackgroundPaint(ObjectColor colors, Collection<CardType> types, SubTypes subTypes) {
        if (subTypes.contains((Object)SubType.VEHICLE)) {
            return BG_TEXTURE_VEHICLE;
        }
        if (types.contains((Object)CardType.LAND)) {
            return BG_TEXTURE_LAND;
        }
        if (types.contains((Object)CardType.ARTIFACT)) {
            return BG_TEXTURE_ARTIFACT;
        }
        if (colors.isMulticolored()) {
            return BG_TEXTURE_GOLD;
        }
        if (colors.isWhite()) {
            return BG_TEXTURE_WHITE;
        }
        if (colors.isBlue()) {
            return BG_TEXTURE_BLUE;
        }
        if (colors.isBlack()) {
            return BG_TEXTURE_BLACK;
        }
        if (colors.isRed()) {
            return BG_TEXTURE_RED;
        }
        if (colors.isGreen()) {
            return BG_TEXTURE_GREEN;
        }
        return new Color(71, 86, 101);
    }

    protected static BufferedImage getBackgroundTexture(ObjectColor colors, Collection<CardType> types, SubTypes subTypes, boolean isExped) {
        if (subTypes.contains((Object)SubType.VEHICLE)) {
            return BG_IMG_VEHICLE;
        }
        if (types.contains((Object)CardType.LAND)) {
            if (isExped) {
                return BG_IMG_EXPEDITION;
            }
            return BG_IMG_LAND;
        }
        if (types.contains((Object)CardType.ARTIFACT)) {
            return BG_IMG_ARTIFACT;
        }
        if (colors.isMulticolored()) {
            return BG_IMG_GOLD;
        }
        if (colors.isWhite()) {
            return BG_IMG_WHITE;
        }
        if (colors.isBlue()) {
            return BG_IMG_BLUE;
        }
        if (colors.isBlack()) {
            return BG_IMG_BLACK;
        }
        if (colors.isRed()) {
            return BG_IMG_RED;
        }
        if (colors.isGreen()) {
            return BG_IMG_GREEN;
        }
        return BG_IMG_COLORLESS;
    }

    protected Color getBoxColor(ObjectColor colors, Collection<CardType> types, boolean isNightCard) {
        if (this.cardView.isAbility()) {
            return Color.BLACK;
        }
        if (colors.getColorCount() == 2 && types.contains((Object)CardType.LAND)) {
            return BOX_LAND;
        }
        if (colors.isMulticolored()) {
            return isNightCard ? BOX_GOLD_NIGHT : BOX_GOLD;
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return BOX_LAND;
            }
            return isNightCard ? BOX_COLORLESS_NIGHT : BOX_COLORLESS;
        }
        if (colors.isWhite()) {
            return isNightCard ? BOX_WHITE_NIGHT : BOX_WHITE;
        }
        if (colors.isBlue()) {
            return isNightCard ? BOX_BLUE_NIGHT : BOX_BLUE;
        }
        if (colors.isBlack()) {
            return isNightCard ? BOX_BLACK_NIGHT : BOX_BLACK;
        }
        if (colors.isRed()) {
            return isNightCard ? BOX_RED_NIGHT : BOX_RED;
        }
        if (colors.isGreen()) {
            return isNightCard ? BOX_GREEN_NIGHT : BOX_GREEN;
        }
        return ERROR_COLOR;
    }

    protected Color getAdditionalBoxColor(ObjectColor colors, Collection<CardType> types, boolean isNightCard) {
        if (this.isUnstableFullArtLand()) {
            if (colors.isWhite()) {
                return BOX_UST_WHITE;
            }
            if (colors.isBlue()) {
                return BOX_UST_BLUE;
            }
            if (colors.isBlack()) {
                return BOX_UST_BLACK;
            }
            if (colors.isRed()) {
                return BOX_UST_RED;
            }
            if (colors.isGreen()) {
                return BOX_UST_GREEN;
            }
        }
        return this.getBoxColor(colors, types, isNightCard);
    }

    protected static Color getBorderColor(ObjectColor color) {
        if (color.isWhite()) {
            return BORDER_WHITE;
        }
        if (color.isBlue()) {
            return BORDER_BLUE;
        }
        if (color.isBlack()) {
            return BORDER_BLACK;
        }
        if (color.isRed()) {
            return BORDER_RED;
        }
        if (color.isGreen()) {
            return BORDER_GREEN;
        }
        return ERROR_COLOR;
    }

    protected static Paint getBorderPaint(ObjectColor colors, Collection<CardType> types, int width) {
        if (colors.isMulticolored()) {
            if (colors.getColorCount() == 2) {
                List<ObjectColor> twoColors = colors.getColors();
                Color color1 = twoColors.get(0).isWhite() ? new Color(240, 240, 240) : ModernCardRenderer.getBorderColor(twoColors.get(0));
                Color color2 = twoColors.get(1).isWhite() ? new Color(240, 240, 240) : ModernCardRenderer.getBorderColor(twoColors.get(1));
                return new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.4f, 0.6f}, new Color[]{color1, color2});
            }
            return BORDER_GOLD;
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return BORDER_LAND;
            }
            return BORDER_COLORLESS;
        }
        return ModernCardRenderer.getBorderColor(colors);
    }

    protected static Color getTextboxColor(ObjectColor color) {
        if (color.isWhite()) {
            return TEXTBOX_WHITE;
        }
        if (color.isBlue()) {
            return TEXTBOX_BLUE;
        }
        if (color.isBlack()) {
            return TEXTBOX_BLACK;
        }
        if (color.isRed()) {
            return TEXTBOX_RED;
        }
        if (color.isGreen()) {
            return TEXTBOX_GREEN;
        }
        return ERROR_COLOR;
    }

    protected static Color getSpiralLandTextboxColor(ObjectColor color, ObjectColor secondColor, boolean firstOne) {
        boolean green;
        boolean white = color.isWhite() || secondColor.isWhite();
        boolean blue = color.isBlue() || secondColor.isBlue();
        boolean black = color.isBlack() || secondColor.isBlack();
        boolean red = color.isRed() || secondColor.isRed();
        boolean bl = green = color.isGreen() || secondColor.isGreen();
        if (white && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_WHITE : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (white && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_WHITE : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        if (black && white) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_WHITE;
        }
        if (red && white) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_WHITE;
        }
        if (blue && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLUE : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (black && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        if (black && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (red && black) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_BLACK;
        }
        if (red && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (red && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        return ModernCardRenderer.getLandTextboxColor(color);
    }

    protected static Color getLandTextboxColor(ObjectColor color) {
        if (color.isWhite()) {
            return LAND_TEXTBOX_WHITE;
        }
        if (color.isBlue()) {
            return LAND_TEXTBOX_BLUE;
        }
        if (color.isBlack()) {
            return LAND_TEXTBOX_BLACK;
        }
        if (color.isRed()) {
            return LAND_TEXTBOX_RED;
        }
        if (color.isGreen()) {
            return LAND_TEXTBOX_GREEN;
        }
        return ERROR_COLOR;
    }

    private static Color getLessOpaqueColor(Color color, boolean lessOpaqueRulesTextBox) {
        if (lessOpaqueRulesTextBox) {
            Color lessOpaque = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() - 50);
            return lessOpaque;
        }
        return color;
    }

    protected static Paint getTextboxPaint(ObjectColor colors, Collection<CardType> types, int width, boolean lessOpaqueRulesTextBox) {
        if (colors.isMulticolored()) {
            if (colors.getColorCount() == 2) {
                List<ObjectColor> twoColors = colors.getColors();
                Color[] translatedColors = types.contains((Object)CardType.LAND) ? new Color[]{ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getLandTextboxColor(twoColors.get(0)), lessOpaqueRulesTextBox), ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getLandTextboxColor(twoColors.get(1)), lessOpaqueRulesTextBox)} : new Color[]{ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getTextboxColor(twoColors.get(0)), lessOpaqueRulesTextBox), ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getTextboxColor(twoColors.get(1)), lessOpaqueRulesTextBox)};
                return new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.4f, 0.6f}, translatedColors);
            }
            if (types.contains((Object)CardType.LAND)) {
                return ModernCardRenderer.getLessOpaqueColor(LAND_TEXTBOX_GOLD, lessOpaqueRulesTextBox);
            }
            return ModernCardRenderer.getLessOpaqueColor(TEXTBOX_GOLD, lessOpaqueRulesTextBox);
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return ModernCardRenderer.getLessOpaqueColor(TEXTBOX_LAND, lessOpaqueRulesTextBox);
            }
            return ModernCardRenderer.getLessOpaqueColor(TEXTBOX_COLORLESS, lessOpaqueRulesTextBox);
        }
        if (types.contains((Object)CardType.LAND)) {
            return ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getLandTextboxColor(colors), lessOpaqueRulesTextBox);
        }
        return ModernCardRenderer.getLessOpaqueColor(ModernCardRenderer.getTextboxColor(colors), lessOpaqueRulesTextBox);
    }

    private static class RuleLayout {
        public List<AttributedString> attributedRules;
        public int remainingHeight;
        public boolean fits;
        public Font font;
        public Font fontItalic;

        private RuleLayout() {
        }
    }
}

