/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.mage.card.arcane.CardRendererUtils;

public class ModernCardResourceLoader {
    private static final Logger LOGGER = Logger.getLogger(ModernCardResourceLoader.class);

    protected static TexturePaint loadBackgroundTexture(String name) {
        URL url = ModernCardResourceLoader.class.getResource("/cardrender/background_texture_" + name + ".png");
        ImageIcon icon = new ImageIcon(url);
        BufferedImage img = CardRendererUtils.toBufferedImage(icon.getImage());
        return new TexturePaint(img, new Rectangle(0, 0, img.getWidth(), img.getHeight()));
    }

    protected static BufferedImage loadBackgroundImage(String name) {
        URL url = ModernCardResourceLoader.class.getResource("/cardrender/background_texture_" + name + ".png");
        ImageIcon icon = new ImageIcon(url);
        BufferedImage img = CardRendererUtils.toBufferedImage(icon.getImage());
        return img;
    }

    protected static BufferedImage loadFramePart(String name) {
        URL url = ModernCardResourceLoader.class.getResource("/cardrender/" + name + ".png");
        ImageIcon icon = new ImageIcon(url);
        return CardRendererUtils.toBufferedImage(icon.getImage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Font loadFont(String name) {
        try (InputStream in = ModernCardResourceLoader.class.getResourceAsStream("/cardrender/" + name + ".ttf");){
            Font font = Font.createFont(0, in);
            return font;
        }
        catch (IOException e) {
            LOGGER.info((Object)("Failed to load font `" + name + "`, couldn't find resource."));
            return new Font("Arial", 0, 1);
        }
        catch (FontFormatException e) {
            LOGGER.info((Object)("Failed to load font `" + name + "`, bad format."));
        }
        return new Font("Arial", 0, 1);
    }
}

