/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.MageInt;
import mage.ObjectColor;
import mage.cards.ArtRect;
import mage.cards.FrameStyle;
import mage.client.dialog.PreferencesDialog;
import mage.constants.CardType;
import mage.constants.MageObjectType;
import mage.constants.SubType;
import mage.view.CardView;
import mage.view.PermanentView;
import org.mage.card.arcane.CardPanelAttributes;
import org.mage.card.arcane.CardRenderer;
import org.mage.card.arcane.CardRendererUtils;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.ModernCardResourceLoader;
import org.mage.card.arcane.TextboxBasicManaRule;
import org.mage.card.arcane.TextboxLoyaltyRule;
import org.mage.card.arcane.TextboxRule;
import org.mage.card.arcane.TextboxRuleType;

public class RetroCardRenderer
extends CardRenderer {
    public static final Color MANA_ICONS_TEXT_COLOR = Color.DARK_GRAY;
    public static final BufferedImage BG_IMG_WHITE = ModernCardResourceLoader.loadBackgroundImage("white_retro");
    public static final BufferedImage BG_IMG_BLUE = ModernCardResourceLoader.loadBackgroundImage("blue_retro");
    public static final BufferedImage BG_IMG_BLACK = ModernCardResourceLoader.loadBackgroundImage("black_retro");
    public static final BufferedImage BG_IMG_RED = ModernCardResourceLoader.loadBackgroundImage("red_retro");
    public static final BufferedImage BG_IMG_GREEN = ModernCardResourceLoader.loadBackgroundImage("green_retro");
    public static final BufferedImage BG_IMG_GOLD = ModernCardResourceLoader.loadBackgroundImage("gold_retro");
    public static final BufferedImage BG_IMG_ARTIFACT = ModernCardResourceLoader.loadBackgroundImage("artifact_retro");
    public static final BufferedImage BG_IMG_LAND = ModernCardResourceLoader.loadBackgroundImage("land_retro");
    public static final BufferedImage BG_IMG_COLORLESS = ModernCardResourceLoader.loadBackgroundImage("colorless_retro");
    public static final Color BORDER_WHITE = new Color(168, 159, 156);
    public static final Color BORDER_BLUE = new Color(29, 107, 124);
    public static final Color BORDER_BLACK = new Color(77, 71, 73);
    public static final Color BORDER_RED = new Color(200, 71, 58);
    public static final Color BORDER_GREEN = new Color(91, 136, 62, 255);
    public static final Color BORDER_GOLD = new Color(244, 172, 65);
    public static final Color BORDER_COLORLESS = new Color(208, 212, 212);
    public static final Color BORDER_LAND = new Color(190, 173, 115);
    public static final Color BOX_WHITE = new Color(248, 247, 245);
    public static final Color BOX_BLUE = new Color(200, 226, 235);
    public static final Color BOX_BLACK = new Color(230, 191, 134);
    public static final Color BOX_RED = new Color(203, 141, 117);
    public static final Color BOX_GREEN = new Color(234, 187, 134);
    public static final Color BOX_GOLD = new Color(154, 142, 145);
    public static final Color BOX_COLORLESS = new Color(190, 183, 178);
    public static final Color BOX_LAND = new Color(220, 215, 213);
    public static final Color BOX_INVENTION = new Color(209, 97, 33);
    public static final Color BOX_VEHICLE = new Color(155, 105, 60);
    public static final Color LAND_TEXTBOX_WHITE = new Color(248, 232, 188, 234);
    public static final Color LAND_TEXTBOX_BLUE = new Color(189, 212, 236, 234);
    public static final Color LAND_TEXTBOX_BLACK = new Color(174, 164, 162, 234);
    public static final Color LAND_TEXTBOX_RED = new Color(242, 168, 133, 234);
    public static final Color LAND_TEXTBOX_GREEN = new Color(198, 220, 198, 234);
    public static final Color LAND_TEXTBOX_GOLD = new Color(236, 229, 207, 234);
    public static final Color LAND_SPIRAL_TEXTBOX_WHITE = new Color(248, 232, 188, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_BLUE = new Color(189, 212, 236, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_BLACK = new Color(174, 164, 162, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_RED = new Color(242, 168, 133, 220);
    public static final Color LAND_SPIRAL_TEXTBOX_GREEN = new Color(198, 220, 198, 220);
    public static final Color TEXTBOX_WHITE = new Color(248, 247, 245);
    public static final Color TEXTBOX_BLUE = new Color(200, 226, 235);
    public static final Color TEXTBOX_BLACK = new Color(230, 191, 134);
    public static final Color TEXTBOX_RED = new Color(203, 141, 117);
    public static final Color TEXTBOX_GREEN = new Color(234, 187, 134);
    public static final Color TEXTBOX_GOLD = new Color(154, 142, 145);
    public static final Color TEXTBOX_COLORLESS = new Color(190, 183, 178);
    public static final Color TEXTBOX_LAND = new Color(211, 151, 92, 255);
    public static final Color ERROR_COLOR = new Color(255, 0, 255);
    protected int contentInset;
    protected int totalContentInset;
    protected int frameInset;
    protected int contentWidth;
    protected int innerContentWidth;
    protected int artHeight;
    protected static final float BOX_HEIGHT_FRAC = 0.051f;
    protected static final float PT_BOX_HEIGHT_FRAC = 0.065f;
    protected static final int BOX_HEIGHT_MIN = 8;
    protected int boxHeight;
    protected int ptBoxHeight;
    protected static final float TYPE_LINE_Y_FRAC = 0.525f;
    protected int typeLineY;
    protected static final float INSET_WIDTH_FRAC = 0.055f;
    protected int insetWidth;
    protected static final int[] RULES_TEXT_FONT_SIZES = new int[]{24, 18, 15, 12, 9};
    protected int boxTextHeight;
    protected int boxTextOffset;
    protected Font boxTextFont;
    protected Font boxTextFontNarrow;
    protected int ptTextHeight;
    protected int ptTextOffset;
    protected Font ptTextFont;
    protected String manaCostString = ManaSymbols.getClearManaCost(this.cardView.getManaCostStr());
    protected Color frameTopRightColor;
    protected Color frameBottomLeftColor;
    protected boolean loyaltyAbilityColorToggle = false;

    public RetroCardRenderer(CardView card) {
        super(card);
    }

    @Override
    protected void layout(int cardWidth, int cardHeight) {
        super.layout(cardWidth, cardHeight);
        this.borderWidth = (int)Math.max(2.0, 0.048 * (double)cardWidth);
        this.frameInset = (int)Math.max(2.0, 0.012 * (double)cardWidth);
        this.insetWidth = (int)Math.max(2.0f, 0.055f * (float)cardWidth);
        this.contentInset = this.borderWidth + this.insetWidth;
        this.totalContentInset = this.borderWidth + this.contentInset;
        this.contentWidth = cardWidth - 2 * this.totalContentInset;
        this.boxHeight = (int)Math.max(8.0f, 0.051f * (float)cardHeight);
        this.ptBoxHeight = (int)Math.max(16.0f, 0.065f * (float)cardHeight);
        this.typeLineY = (int)(0.525f * (float)cardHeight);
        this.innerContentWidth = (int)((float)cardWidth * 0.8f);
        if (this.innerContentWidth < 160) {
            this.innerContentWidth += 2;
        }
        this.artHeight = this.typeLineY - (this.borderWidth + this.boxHeight);
        this.boxTextHeight = RetroCardRenderer.getTextHeightForBoxHeight(this.boxHeight);
        this.boxTextOffset = (this.boxHeight - this.boxTextHeight) / 2;
        this.boxTextFont = new Font("Arial", 0, this.boxTextHeight);
        this.boxTextFontNarrow = new Font("Arial Narrow", 0, this.boxTextHeight);
        this.ptTextHeight = RetroCardRenderer.getPTTextHeightForLineHeight(this.ptBoxHeight);
        this.ptTextOffset = (this.ptBoxHeight - this.ptTextHeight) / 2;
        this.ptTextFont = new Font("Arial", 1, this.ptTextHeight);
        this.frameTopRightColor = this.getFrameColor(true);
        this.frameBottomLeftColor = this.getFrameColor(false);
    }

    @Override
    protected void drawBorder(Graphics2D g) {
        Color borderColor = this.isSelected ? Color.green : (this.isChoosable ? new Color(250, 250, 0, 230) : (this.cardView.isPlayable() ? new Color(153, 102, 204, 200) : (this.cardView.isCanAttack() ? new Color(255, 50, 50, 230) : (this.cardView.isCanBlock() ? new Color(255, 50, 50, 230) : Color.BLACK))));
        g.setColor(borderColor);
        g.fillRoundRect(0, 0, this.cardWidth, this.cardHeight, this.cornerRadius, this.cornerRadius);
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        if (this.cardView.isFaceDown()) {
            this.drawCardBackTexture(g);
        } else {
            BufferedImage bg = RetroCardRenderer.getBackgroundTexture(this.cardView.getColor(), this.cardView.getCardTypes());
            if (bg == null) {
                return;
            }
            int bgw = bg.getWidth();
            int bgh = bg.getHeight();
            Rectangle bgRect = new Rectangle(this.borderWidth, this.borderWidth, this.cardWidth - this.borderWidth * 2, this.cardHeight - this.borderWidth * 2);
            Area area = new Area(bgRect);
            g.setClip(area);
            g.drawImage(bg, 0, 0, this.cardWidth, this.cardHeight, 0, 0, bgw, bgh, BOX_BLUE, null);
        }
    }

    private boolean isOriginalDualLand() {
        return this.cardView.getFrameStyle() == FrameStyle.LEA_ORIGINAL_DUAL_LAND_ART_BASIC;
    }

    @Override
    protected void drawArt(Graphics2D g) {
        if (this.artImage != null) {
            ArtRect rect;
            boolean shouldPreserveAspect = true;
            Rectangle2D sourceRect = ArtRect.RETRO.rect;
            if (this.cardView.getFrameStyle() != FrameStyle.RETRO) {
                sourceRect = new Rectangle2D.Double(sourceRect.getX(), sourceRect.getY() + 0.01, sourceRect.getWidth(), sourceRect.getHeight());
            }
            if (this.cardView.getMageObjectType() == MageObjectType.SPELL && (rect = this.cardView.getArtRect()) != ArtRect.NORMAL) {
                sourceRect = rect.rect;
            }
            this.drawArtIntoRect(g, this.contentInset + this.frameInset, this.borderWidth + this.boxHeight + this.frameInset, this.innerContentWidth - this.frameInset * 2, this.artHeight - this.frameInset * 2, sourceRect, shouldPreserveAspect);
        }
    }

    @Override
    protected void drawFrame(Graphics2D g, CardPanelAttributes attribs, BufferedImage image, boolean lessOpaqueRulesTextBox) {
        ObjectColor frameColors = this.getFrameObjectColor();
        Color boxColor = this.getBoxColor(frameColors, this.cardView.getCardTypes());
        Paint textboxPaint = RetroCardRenderer.getTextboxPaint(frameColors, this.cardView.getCardTypes(), this.cardWidth, lessOpaqueRulesTextBox);
        Paint borderPaint = RetroCardRenderer.getBorderPaint(frameColors, this.cardView.getCardTypes(), this.cardWidth);
        if (this.cardView.getFrameStyle() == FrameStyle.KLD_INVENTION) {
            boxColor = BOX_INVENTION;
        }
        this.drawTextboxBackground(g, textboxPaint, frameColors, borderPaint, this.isOriginalDualLand());
        this.drawInsetFrame(g, this.contentInset, this.borderWidth + this.boxHeight, this.innerContentWidth, this.artHeight, borderPaint, this.cardView.getCardTypes().contains((Object)CardType.LAND));
        this.drawTypeLine(g, attribs, this.getCardTypeLine(), this.contentInset, this.typeLineY, this.innerContentWidth, this.boxHeight);
        int nameOffset = this.drawTransformationCircle(g, attribs, borderPaint);
        this.drawNameLine(g, attribs, this.cardView.getDisplayName(), this.manaCostString, this.contentInset + nameOffset, this.borderWidth, this.innerContentWidth);
        this.drawRulesText(g, this.textboxKeywords, this.textboxRules, this.contentInset + 2, this.typeLineY + this.boxHeight + 2, this.innerContentWidth - 4, (int)((float)(this.cardHeight - this.borderWidth * 2) * 0.32f));
        this.drawBottomRight(g, attribs, borderPaint, boxColor);
    }

    private void drawInsetFrame(Graphics2D g2, int x, int y, int width, int height, Paint borderPaint, boolean isLand) {
        int x1 = x + width;
        int y1 = y + height;
        int xi0 = x + this.frameInset;
        int yi0 = y + this.frameInset;
        int xi1 = x + width - this.frameInset;
        int yi1 = y + height - this.frameInset;
        Color topColor = this.frameTopRightColor;
        Color leftColor = this.frameBottomLeftColor;
        Path2D.Double top = new Path2D.Double();
        ((Path2D)top).moveTo(x, y);
        ((Path2D)top).lineTo(x1, y);
        ((Path2D)top).lineTo(xi1, yi0);
        ((Path2D)top).lineTo(xi0, yi0);
        top.closePath();
        Path2D.Double left = new Path2D.Double();
        ((Path2D)left).moveTo(x, y);
        ((Path2D)left).lineTo(xi0, yi0);
        ((Path2D)left).lineTo(xi0, yi1);
        ((Path2D)left).lineTo(x, y1);
        left.closePath();
        Path2D.Double right = new Path2D.Double();
        ((Path2D)right).moveTo(x1, y);
        ((Path2D)right).lineTo(x1, y1);
        ((Path2D)right).lineTo(xi1, yi1);
        ((Path2D)right).lineTo(xi1, yi0);
        right.closePath();
        Path2D.Double bottom = new Path2D.Double();
        ((Path2D)bottom).moveTo(x, y1);
        ((Path2D)bottom).lineTo(x1, y1);
        ((Path2D)bottom).lineTo(xi1, yi1);
        ((Path2D)bottom).lineTo(xi0, yi1);
        bottom.closePath();
        if (isLand) {
            g2.draw(top);
            g2.draw(left);
            g2.draw(right);
            g2.draw(bottom);
            if (this.cardView.getFrameColor().getColorCount() > 1) {
                g2.setColor(BORDER_LAND);
            } else {
                g2.setPaint(borderPaint);
            }
        } else {
            g2.setColor(topColor);
            g2.fill(top);
            g2.fill(right);
            g2.setColor(leftColor);
            g2.fill(left);
            g2.fill(bottom);
            g2.setColor(CardRendererUtils.abitdarker(topColor));
        }
        g2.setStroke(new BasicStroke(1.5f));
        g2.drawRect(--x, --y, x1 - x, y1 - y);
        g2.setStroke(new BasicStroke(1.0f));
    }

    private void drawTextboxBackground(Graphics2D g, Paint textboxPaint, ObjectColor frameColors, Paint borderPaint, boolean isOriginalDual) {
        g.setPaint(textboxPaint);
        int x = this.contentInset;
        int backgroundHeight = (int)((float)(this.cardHeight - this.borderWidth * 2) * 0.33f);
        if (this.cardView.getCardTypes().contains((Object)CardType.LAND)) {
            int height_of_spiral = (int)((double)(backgroundHeight - this.frameInset * 2) * 0.06);
            List<ObjectColor> twoColors = frameColors.getColors();
            g.setPaint(borderPaint);
            g.fillRect(x, this.typeLineY + this.boxHeight + 1, this.innerContentWidth, backgroundHeight);
            g.setColor(Color.black);
            g.drawRect(x, this.typeLineY + this.boxHeight + 1, this.innerContentWidth, backgroundHeight);
            g.setPaint(textboxPaint);
            if (twoColors.size() <= 2) {
                if (isOriginalDual && twoColors.size() == 2) {
                    g.setPaint(RetroCardRenderer.getSpiralLandTextboxColor(twoColors.get(0), twoColors.get(1), false));
                }
                g.fillRect(x + this.frameInset, this.typeLineY + this.boxHeight + 1 + this.frameInset, this.innerContentWidth - this.frameInset * 2, backgroundHeight - this.frameInset * 2);
                g.setColor(Color.black);
                g.drawRect(x + this.frameInset, this.typeLineY + this.boxHeight + 1 + this.frameInset, this.innerContentWidth - this.frameInset * 2, backgroundHeight - this.frameInset * 2);
            }
            if (frameColors.getColorCount() >= 3) {
                g.fillRect(x, this.typeLineY + this.boxHeight + 1, this.innerContentWidth - 4, backgroundHeight);
            }
            if (frameColors.getColorCount() == 2 && isOriginalDual) {
                for (int i = 0; i < 8; ++i) {
                    int offset = height_of_spiral * i;
                    int inset = this.frameInset + offset;
                    int width = this.innerContentWidth - this.frameInset * 2 - height_of_spiral * i * 2;
                    int height = backgroundHeight - this.frameInset * 2 - height_of_spiral * i * 2;
                    boolean useFirstColor = i % 2 == 0;
                    g.setPaint(RetroCardRenderer.getSpiralLandTextboxColor(twoColors.get(0), twoColors.get(1), useFirstColor));
                    g.fillRect(x + inset, this.typeLineY + this.boxHeight + 1 + inset, width, height);
                }
            }
        } else {
            g.fillRect(x, this.typeLineY + this.boxHeight, this.innerContentWidth, backgroundHeight);
            g.setColor(Color.black);
            g.drawRect(x, this.typeLineY + this.boxHeight, this.innerContentWidth, backgroundHeight);
        }
    }

    protected void drawNameLine(Graphics2D g, CardPanelAttributes attribs, String baseName, String manaCost, int x, int y, int w) {
        int manaCostWidth = this.cardView.isAbility() ? 0 : CardRendererUtils.getManaCostWidth(manaCost, this.boxTextHeight);
        int availableWidth = w - manaCostWidth + 2;
        if (!baseName.isEmpty()) {
            AttributedString str = new AttributedString(baseName);
            str.addAttribute(TextAttribute.FONT, this.boxTextFont);
            TextMeasurer measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
            int breakIndex = measure.getLineBreakIndex(0, availableWidth);
            if (breakIndex < baseName.length()) {
                str = new AttributedString(baseName);
                str.addAttribute(TextAttribute.FONT, this.boxTextFontNarrow);
                measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
                breakIndex = measure.getLineBreakIndex(0, availableWidth);
            }
            if (breakIndex > 0) {
                TextLayout layout = measure.getLayout(0, breakIndex);
                int drawY = y + this.boxTextOffset + this.boxTextHeight - 1;
                g.setColor(this.getBoxTextColor(attribs));
                layout.draw(g, x, drawY);
            }
        }
        if (!this.cardView.isAbility() && !this.cardView.isFaceDown()) {
            ManaSymbols.draw(g, manaCost, x + w - manaCostWidth, y + this.boxTextOffset, this.boxTextHeight, MANA_ICONS_TEXT_COLOR, 2);
        }
    }

    protected void drawTypeLine(Graphics2D g, CardPanelAttributes attribs, String baseTypeLine, int x, int y, int w, int h) {
        int expansionSymbolWidth = 0;
        if (PreferencesDialog.getCachedValue("cardRenderingSetSymbol", "false").equals("false")) {
            expansionSymbolWidth = this.drawExpansionSymbol(g, x, y, w, h);
        }
        int availableWidth = w - expansionSymbolWidth + 1;
        String types = baseTypeLine;
        g.setFont(this.boxTextFont);
        if (g.getFontMetrics().stringWidth(types) > availableWidth) {
            types = types.replace("Token", "T.");
            types = types.replace("Legendary", "L.");
        }
        if (!types.isEmpty()) {
            AttributedString str = new AttributedString(types);
            str.addAttribute(TextAttribute.FONT, this.boxTextFont);
            TextMeasurer measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
            int breakIndex = measure.getLineBreakIndex(0, availableWidth);
            if (breakIndex < types.length()) {
                str = new AttributedString(types);
                str.addAttribute(TextAttribute.FONT, this.boxTextFontNarrow);
                measure = new TextMeasurer(str.getIterator(), g.getFontRenderContext());
                breakIndex = measure.getLineBreakIndex(0, availableWidth);
            }
            if (breakIndex > 0) {
                TextLayout layout = measure.getLayout(0, breakIndex);
                g.setColor(this.getBoxTextColor(attribs));
                layout.draw(g, x, (float)y + (float)(h - this.boxTextHeight) / 2.0f + (float)this.boxTextHeight - 1.0f);
            }
        }
    }

    protected void drawBottomRight(Graphics2D g, CardPanelAttributes attribs, Paint borderPaint, Color fill) {
        int w;
        if (this.cardView.isAbility()) {
            return;
        }
        int contentInset = this.borderWidth - this.frameInset;
        int curY = this.cardHeight - (int)(0.03f * (float)this.cardHeight);
        int partBoxWidth = (int)Math.max(30.0f, 0.2f * (float)this.cardWidth);
        boolean isVehicle = this.cardView.getSubTypes().contains((Object)SubType.VEHICLE);
        if (this.cardView.showPT()) {
            int ptDeviderSpace = 1;
            String ptText1 = this.cardView.getPower();
            String ptText2 = "/";
            String ptText3 = CardRendererUtils.getCardLifeWithDamage(this.cardView);
            int ptTextWidth1 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText1);
            int ptTextWidth2 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText2) + 2 * ptDeviderSpace;
            int ptTextWidth3 = g.getFontMetrics(this.ptTextFont).stringWidth(ptText3);
            int ptContentWidth = contentInset + ptTextWidth1 + ptDeviderSpace + ptTextWidth2 + ptDeviderSpace + ptTextWidth3 + contentInset;
            partBoxWidth = Math.max(ptContentWidth, partBoxWidth);
            int x = this.cardWidth - this.borderWidth - partBoxWidth;
            CardRendererUtils.drawRoundedBox(g, x, curY - this.ptBoxHeight, partBoxWidth, this.ptBoxHeight, contentInset, borderPaint, isVehicle ? BOX_VEHICLE : fill);
            Color defaultTextColor = Color.black;
            boolean defaultTextLight = this.cardView.getColor().isMulticolored() || this.cardView.getColor().equals(ObjectColor.RED) || this.cardView.getColor().equals(ObjectColor.COLORLESS);
            g.setFont(this.ptTextFont);
            MageInt currentPower = this.cardView.getOriginalPower();
            MageInt currentToughness = this.cardView.getOriginalToughness();
            int ptEmptySpace = (partBoxWidth - ptContentWidth) / 2;
            int ptPosStart1 = x + contentInset + ptEmptySpace;
            int ptPosStart2 = ptPosStart1 + ptTextWidth1 + ptDeviderSpace;
            int ptPosStart3 = ptPosStart2 + ptTextWidth2 + ptDeviderSpace;
            g.setColor(CardRendererUtils.getCardTextColor(currentPower, false, defaultTextColor, defaultTextLight));
            g.drawString(ptText1, ptPosStart1, curY - this.ptTextOffset - 1);
            g.setColor(defaultTextColor);
            g.drawString(ptText2, ptPosStart2, curY - this.ptTextOffset - 1);
            g.setColor(CardRendererUtils.getCardTextColor(currentToughness, CardRendererUtils.isCardWithDamage(this.cardView), defaultTextColor, defaultTextLight));
            g.drawString(ptText3, ptPosStart3, curY - this.ptTextOffset - 1);
            g.setColor(defaultTextColor);
            curY -= this.ptBoxHeight;
        }
        if (this.cardView.isPlaneswalker() && (this.cardView instanceof PermanentView || !this.cardView.getStartingLoyalty().equals("0"))) {
            w = partBoxWidth;
            int h = partBoxWidth / 2;
            int x = this.cardWidth - partBoxWidth - this.borderWidth;
            int y = curY - h;
            Polygon symbol = new Polygon();
            symbol.addPoint(x + w / 2, y + h);
            symbol.addPoint((int)((double)x + (double)w * 0.9), (int)((double)y + 0.8 * (double)h));
            symbol.addPoint(x + w, y);
            symbol.addPoint((int)((double)x + (double)w * 0.6), (int)((double)y - 0.2 * (double)h));
            symbol.addPoint(x + w / 2, y);
            symbol.addPoint((int)((double)x + (double)w * 0.4), (int)((double)y - 0.2 * (double)h));
            symbol.addPoint(x, y);
            symbol.addPoint((int)((double)x + (double)w * 0.1), (int)((double)y + 0.8 * (double)h));
            g.setColor(Color.black);
            g.fillPolygon(symbol);
            g.setColor(new Color(200, 200, 200));
            g.setStroke(new BasicStroke(2.0f));
            g.drawPolygon(symbol);
            g.setStroke(new BasicStroke(1.0f));
            String loyalty = this.cardView instanceof PermanentView ? this.cardView.getLoyalty() : this.cardView.getStartingLoyalty();
            g.setFont(this.ptTextFont);
            g.setColor(Color.white);
            int loyaltyWidth = g.getFontMetrics().stringWidth(loyalty);
            g.drawString(loyalty, x + (w - loyaltyWidth) / 2, y + this.ptTextHeight + (h - this.ptTextHeight) / 2);
            curY -= (int)(1.2 * (double)y);
        }
        if (this.cardView.isBattle() && (this.cardView instanceof PermanentView || !this.cardView.getStartingDefense().equals("0"))) {
            w = 3 * partBoxWidth / 4;
            int h = 3 * partBoxWidth / 4;
            int x = this.cardWidth - w - this.borderWidth;
            int y = curY - h;
            Polygon symbol = new Polygon();
            symbol.addPoint(x + 0 * w / 80, y + 2 * h / 80);
            symbol.addPoint(x + 12 * w / 80, y + 30 * h / 80);
            symbol.addPoint(x + 3 * w / 80, y + 40 * h / 80);
            symbol.addPoint(x + 12 * w / 80, y + 50 * h / 80);
            symbol.addPoint(x + 0 * w / 80, y + 78 * h / 80);
            symbol.addPoint(x + 30 * w / 80, y + 71 * h / 80);
            symbol.addPoint(x + 40 * w / 80, y + 80 * h / 80);
            symbol.addPoint(x + 50 * w / 80, y + 71 * h / 80);
            symbol.addPoint(x + 80 * w / 80, y + 78 * h / 80);
            symbol.addPoint(x + 68 * w / 80, y + 50 * h / 80);
            symbol.addPoint(x + 77 * w / 80, y + 40 * h / 80);
            symbol.addPoint(x + 68 * w / 80, y + 30 * h / 80);
            symbol.addPoint(x + 80 * w / 80, y + 2 * h / 80);
            symbol.addPoint(x + 48 * w / 80, y + 9 * h / 80);
            symbol.addPoint(x + 40 * w / 80, y + 0 * h / 80);
            symbol.addPoint(x + 32 * w / 80, y + 9 * h / 80);
            g.setColor(Color.black);
            g.fillPolygon(symbol);
            g.setColor(new Color(200, 200, 200));
            g.setStroke(new BasicStroke(2.0f));
            g.drawPolygon(symbol);
            g.setStroke(new BasicStroke(1.0f));
            String defense = this.cardView instanceof PermanentView ? this.cardView.getDefense() : this.cardView.getStartingDefense();
            g.setFont(this.ptTextFont);
            g.setColor(Color.white);
            int defenseWidth = g.getFontMetrics().stringWidth(defense);
            g.drawString(defense, x + 1 + (w - defenseWidth) / 2, y - 1 + this.ptTextHeight + (h - this.ptTextHeight) / 2);
            curY -= (int)(1.2 * (double)y);
        }
        if (this.cardView instanceof PermanentView && ((PermanentView)this.cardView).getDamage() > 0) {
            int x = this.cardWidth - partBoxWidth - this.borderWidth;
            int y = curY - this.ptBoxHeight;
            String damage = String.valueOf(((PermanentView)this.cardView).getDamage());
            g.setFont(this.ptTextFont);
            int txWidth = g.getFontMetrics().stringWidth(damage);
            g.setColor(Color.red);
            g.fillRect(x, y, partBoxWidth, this.ptBoxHeight);
            g.setColor(Color.white);
            g.drawRect(x, y, partBoxWidth, this.ptBoxHeight);
            g.drawString(damage, x + (partBoxWidth - txWidth) / 2, curY - 1);
        }
    }

    protected RuleLayout layoutRules(Graphics2D g, List<TextboxRule> rules, int w, int h, int fontSize) {
        Font font = new Font("Arial", 0, fontSize);
        Font fontItalic = new Font("Arial", 2, fontSize);
        ArrayList<AttributedString> attributedRules = new ArrayList<AttributedString>();
        boolean fits = true;
        int remaining = h;
        for (TextboxRule rule : rules) {
            AttributedString attributed = rule.generateAttributedString(font, fontItalic);
            attributedRules.add(attributed);
            if ((remaining -= this.drawSingleRule(g, attributed, rule, 0, 0, w, remaining, false)) >= 0) continue;
            fits = false;
            break;
        }
        RuleLayout layout = new RuleLayout();
        layout.attributedRules = attributedRules;
        layout.remainingHeight = remaining;
        layout.fits = fits;
        layout.font = font;
        layout.fontItalic = fontItalic;
        return layout;
    }

    /*
     * WARNING - void declaration
     */
    protected void drawRulesText(Graphics2D g, List<TextboxRule> keywords, List<TextboxRule> rules, int x, int y, int w, int h) {
        void var10_14;
        ArrayList<TextboxRule> allRules = new ArrayList<TextboxRule>(rules);
        if (this.cardView.getCardTypes().contains((Object)CardType.LAND)) {
            x += this.frameInset;
            y += this.frameInset;
            h -= this.frameInset;
            w -= this.frameInset;
        }
        if (!keywords.isEmpty()) {
            String keywordRulesString = RetroCardRenderer.getKeywordRulesString(keywords);
            TextboxRule textboxRule = new TextboxRule(keywordRulesString, new ArrayList<TextboxRule.AttributeRegion>());
            allRules.add(0, textboxRule);
        }
        if (allRules.size() == 1 && allRules.get(0) instanceof TextboxBasicManaRule && this.cardView.isLand()) {
            this.drawBasicManaTextbox(g, x, y, w, h, ((TextboxBasicManaRule)allRules.get(0)).getBasicManaSymbol());
            return;
        }
        RuleLayout bestLayout = null;
        for (int fontSize : RULES_TEXT_FONT_SIZES) {
            bestLayout = this.layoutRules(g, allRules, w, h, fontSize);
            if (bestLayout.fits) break;
        }
        if (bestLayout == null) {
            return;
        }
        if (bestLayout.fits) {
            int n = (int)((float)bestLayout.remainingHeight / (float)(1 + allRules.size()));
        } else {
            boolean bl = false;
        }
        this.loyaltyAbilityColorToggle = false;
        g.setColor(Color.black);
        int curY = y + var10_14;
        for (int i = 0; i < bestLayout.attributedRules.size(); ++i) {
            AttributedString attributedRule = bestLayout.attributedRules.get(i);
            TextboxRule rule = (TextboxRule)allRules.get(i);
            int adv = this.drawSingleRule(g, attributedRule, rule, x, curY, w, h, true);
            curY += adv + var10_14;
            if ((h -= adv) < 0) break;
        }
    }

    private void drawBasicManaTextbox(Graphics2D g, int x, int y, int w, int h, String symbol) {
        String symbs = symbol;
        int symbHeight = (int)(0.8 * (double)h);
        int manaCostWidth = CardRendererUtils.getManaCostWidth(symbs, symbHeight);
        ManaSymbols.draw(g, symbs, x + (w - manaCostWidth) / 2, y + (h - symbHeight) / 2, symbHeight, MANA_ICONS_TEXT_COLOR, 2);
    }

    private static String getKeywordRulesString(List<TextboxRule> keywords) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keywords.size(); ++i) {
            builder.append(keywords.get((int)i).text);
            if (i == keywords.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private int drawSingleRule(Graphics2D g, AttributedString text, TextboxRule rule, int x, int y, int w, int h, boolean doDraw) {
        int availWidth;
        int inset = 0;
        if (rule != null && rule.type == TextboxRuleType.LOYALTY) {
            inset = this.cardWidth / 12;
        }
        if ((availWidth = w - inset) < 0) {
            return 0;
        }
        FontRenderContext frc = g.getFontRenderContext();
        AttributedCharacterIterator textIter = text.getIterator();
        LineBreakMeasurer measure = new LineBreakMeasurer(textIter, frc);
        float yPos = y;
        float remain = h;
        AttributedCharacterIterator newLineCheck = text.getIterator();
        while (measure.getPosition() < textIter.getEndIndex()) {
            char ch;
            newLineCheck.setIndex(measure.getPosition());
            while ((ch = newLineCheck.next()) != '\uffff' && ch != '\n') {
            }
            TextLayout layout = measure.nextLayout(availWidth, newLineCheck.getIndex(), false);
            float ascent = layout.getAscent();
            yPos += ascent;
            if ((remain -= ascent) < 0.0f) break;
            if (doDraw) {
                g.setColor(Color.black);
                layout.draw(g, x + inset, yPos);
            }
            yPos += layout.getDescent() + layout.getLeading() - 2.0f;
        }
        int advance = (int)Math.ceil(yPos) - y;
        if (rule != null && rule.type == TextboxRuleType.LOYALTY) {
            TextboxLoyaltyRule loyaltyRule = (TextboxLoyaltyRule)rule;
            int symbolWidth = x + inset - this.borderWidth - 4;
            int symbolHeight = (int)(0.7f * (float)symbolWidth);
            if (symbolHeight > advance) {
                advance = symbolHeight;
            }
            int symbolX = x - this.borderWidth - this.frameInset;
            int symbolY = y + (advance - symbolHeight) / 2;
            if (doDraw) {
                Polygon symbol = loyaltyRule.loyaltyChange < 0 || loyaltyRule.loyaltyChange == 100 ? new Polygon(new int[]{symbolX, symbolX + symbolWidth, symbolX + symbolWidth, symbolX + symbolWidth / 2, symbolX}, new int[]{symbolY, symbolY, symbolY + symbolHeight - 3, symbolY + symbolHeight + 3, symbolY + symbolHeight - 3}, 5) : (loyaltyRule.loyaltyChange > 0 ? new Polygon(new int[]{symbolX, symbolX + symbolWidth / 2, symbolX + symbolWidth, symbolX + symbolWidth, symbolX}, new int[]{symbolY + 3, symbolY - 3, symbolY + 3, symbolY + symbolHeight, symbolY + symbolHeight}, 5) : new Polygon(new int[]{symbolX, symbolX + symbolWidth, symbolX + symbolWidth, symbolX}, new int[]{symbolY, symbolY, symbolY + symbolHeight, symbolY + symbolHeight}, 4));
                g.setColor(new Color(0, 0, 0, 128));
                if ((float)(y + advance + 1) <= yPos) {
                    g.fillRect(x + 2, y + advance + 1, w - 2, 1);
                }
                g.setColor(Color.black);
                g.fillPolygon(symbol);
                g.setColor(new Color(200, 200, 200));
                g.setStroke(new BasicStroke(2.0f));
                g.drawPolygon(symbol);
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.white);
                g.setFont(this.boxTextFont);
                String loyaltyString = loyaltyRule.getChangeString();
                int textWidth = g.getFontMetrics().stringWidth(loyaltyString);
                g.drawString(loyaltyString, symbolX + (symbolWidth - textWidth) / 2, symbolY + symbolHeight - (symbolHeight - this.boxTextHeight) / 2);
                advance += 3;
                this.loyaltyAbilityColorToggle = !this.loyaltyAbilityColorToggle;
            }
        }
        return advance;
    }

    protected boolean isTransformCard(CardPanelAttributes attribs) {
        return this.cardView.canTransform() || attribs.isTransformed;
    }

    protected int drawTransformationCircle(Graphics2D g, CardPanelAttributes attribs, Paint borderPaint) {
        int transformCircleOffset = 0;
        int y = this.totalContentInset / 2 + this.frameInset;
        int height = (this.boxHeight - this.boxTextHeight) / 2 + this.boxTextHeight - 1;
        if (this.isTransformCard(attribs)) {
            transformCircleOffset = height - this.contentInset * 2;
            g.setPaint(borderPaint);
            g.drawOval(this.borderWidth, y, height - 1, height - 1);
            g.setColor(Color.black);
            g.fillOval(this.borderWidth + 1, y + 1, height - 2, height - 2);
            g.setColor(Color.white);
            if (attribs.isTransformed) {
                g.fillArc(this.borderWidth + 3, y + 3, height - 6, height - 6, 90, 270);
                g.setColor(Color.black);
                g.fillArc(this.borderWidth + 3 + 3, y + 3, height - 6 - 3, height - 6, 90, 270);
            } else {
                g.fillOval(this.borderWidth + 3, y + 3, height - 6, height - 6);
            }
        }
        return transformCircleOffset;
    }

    protected static int getTextHeightForBoxHeight(int h) {
        return Math.max(10, (int)Math.ceil(0.95 * (double)h));
    }

    protected static int getPTTextHeightForLineHeight(int h) {
        return h - 4;
    }

    protected Color getFrameColor(boolean isTop) {
        ObjectColor color = this.cardView.getColor();
        if (color.isMulticolored()) {
            return isTop ? new Color(118, 98, 43) : new Color(228, 221, 182);
        }
        if (color.isBlack()) {
            return isTop ? new Color(34, 34, 34) : new Color(122, 121, 113);
        }
        if (color.isWhite()) {
            return isTop ? new Color(187, 171, 144) : new Color(253, 247, 226);
        }
        if (color.isBlue()) {
            return isTop ? new Color(40, 112, 110) : new Color(146, 202, 219);
        }
        if (color.isGreen()) {
            return isTop ? new Color(59, 79, 46) : new Color(122, 154, 106);
        }
        if (color.isRed()) {
            return isTop ? new Color(117, 57, 25) : new Color(245, 146, 107);
        }
        if (this.cardView.getCardTypes().contains((Object)CardType.ARTIFACT)) {
            return isTop ? new Color(85, 68, 32) : new Color(152, 124, 107);
        }
        if (this.cardView.getCardTypes().contains((Object)CardType.LAND)) {
            return isTop ? new Color(73, 55, 30) : new Color(140, 107, 52);
        }
        return isTop ? new Color(139, 130, 130) : new Color(165, 165, 169);
    }

    protected Color getBoxTextColor(CardPanelAttributes attribs) {
        if (!this.cardView.getColor().isMulticolored() && this.cardView.getColor().isWhite()) {
            return Color.black;
        }
        if (attribs.isTransformed) {
            return Color.white;
        }
        if (this.cardView.isAbility()) {
            return Color.white;
        }
        return Color.white;
    }

    protected ObjectColor getFrameObjectColor() {
        return this.cardView.getColor().union(this.cardView.getFrameColor());
    }

    protected static BufferedImage getBackgroundTexture(ObjectColor colors, Collection<CardType> types) {
        if (types.contains((Object)CardType.LAND)) {
            return BG_IMG_LAND;
        }
        if (colors.isMulticolored()) {
            return BG_IMG_GOLD;
        }
        if (colors.isWhite()) {
            return BG_IMG_WHITE;
        }
        if (colors.isBlue()) {
            return BG_IMG_BLUE;
        }
        if (colors.isBlack()) {
            return BG_IMG_BLACK;
        }
        if (colors.isRed()) {
            return BG_IMG_RED;
        }
        if (colors.isGreen()) {
            return BG_IMG_GREEN;
        }
        if (types.contains((Object)CardType.ARTIFACT)) {
            return BG_IMG_ARTIFACT;
        }
        return BG_IMG_COLORLESS;
    }

    protected Color getBoxColor(ObjectColor colors, Collection<CardType> types) {
        if (this.cardView.isAbility()) {
            return Color.BLACK;
        }
        if (colors.getColorCount() == 2 && types.contains((Object)CardType.LAND)) {
            return BOX_LAND;
        }
        if (colors.isMulticolored()) {
            return BOX_GOLD;
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return BOX_LAND;
            }
            return BOX_COLORLESS;
        }
        if (colors.isWhite()) {
            return BOX_WHITE;
        }
        if (colors.isBlue()) {
            return BOX_BLUE;
        }
        if (colors.isBlack()) {
            return BOX_BLACK;
        }
        if (colors.isRed()) {
            return BOX_RED;
        }
        if (colors.isGreen()) {
            return BOX_GREEN;
        }
        return ERROR_COLOR;
    }

    protected static Color getBorderColor(ObjectColor color) {
        if (color.isWhite()) {
            return BORDER_WHITE;
        }
        if (color.isBlue()) {
            return BORDER_BLUE;
        }
        if (color.isBlack()) {
            return BORDER_BLACK;
        }
        if (color.isRed()) {
            return BORDER_RED;
        }
        if (color.isGreen()) {
            return BORDER_GREEN;
        }
        return ERROR_COLOR;
    }

    protected static Paint getBorderPaint(ObjectColor colors, Collection<CardType> types, int width) {
        if (colors.isMulticolored()) {
            if (colors.getColorCount() == 2) {
                List<ObjectColor> twoColors = colors.getColors();
                Color color1 = twoColors.get(0).isWhite() ? new Color(240, 240, 240) : RetroCardRenderer.getBorderColor(twoColors.get(0));
                Color color2 = twoColors.get(1).isWhite() ? new Color(240, 240, 240) : RetroCardRenderer.getBorderColor(twoColors.get(1));
                return new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.4f, 0.6f}, new Color[]{color1, color2});
            }
            return BORDER_GOLD;
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return BORDER_LAND;
            }
            return BORDER_COLORLESS;
        }
        return RetroCardRenderer.getBorderColor(colors);
    }

    protected static Color getTextboxColor(ObjectColor color) {
        if (color.isWhite()) {
            return TEXTBOX_WHITE;
        }
        if (color.isBlue()) {
            return TEXTBOX_BLUE;
        }
        if (color.isBlack()) {
            return TEXTBOX_BLACK;
        }
        if (color.isRed()) {
            return TEXTBOX_RED;
        }
        if (color.isGreen()) {
            return TEXTBOX_GREEN;
        }
        return ERROR_COLOR;
    }

    protected static Color getSpiralLandTextboxColor(ObjectColor color, ObjectColor secondColor, boolean firstOne) {
        boolean green;
        boolean white = color.isWhite() || secondColor.isWhite();
        boolean blue = color.isBlue() || secondColor.isBlue();
        boolean black = color.isBlack() || secondColor.isBlack();
        boolean red = color.isRed() || secondColor.isRed();
        boolean bl = green = color.isGreen() || secondColor.isGreen();
        if (white && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_WHITE : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (white && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_WHITE : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        if (black && white) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_WHITE;
        }
        if (red && white) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_WHITE;
        }
        if (blue && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLUE : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (black && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        if (black && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_BLACK : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (red && black) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_BLACK;
        }
        if (red && green) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_GREEN;
        }
        if (red && blue) {
            return firstOne ? LAND_SPIRAL_TEXTBOX_RED : LAND_SPIRAL_TEXTBOX_BLUE;
        }
        return RetroCardRenderer.getLandTextboxColor(color);
    }

    protected static Color getLandTextboxColor(ObjectColor color) {
        if (color.isWhite()) {
            return LAND_TEXTBOX_WHITE;
        }
        if (color.isBlue()) {
            return LAND_TEXTBOX_BLUE;
        }
        if (color.isBlack()) {
            return LAND_TEXTBOX_BLACK;
        }
        if (color.isRed()) {
            return LAND_TEXTBOX_RED;
        }
        if (color.isGreen()) {
            return LAND_TEXTBOX_GREEN;
        }
        return ERROR_COLOR;
    }

    private static Color getLessOpaqueColor(Color color, boolean lessOpaqueRulesTextBox) {
        if (lessOpaqueRulesTextBox) {
            Color lessOpaque = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() - 50);
            return lessOpaque;
        }
        return color;
    }

    protected static Paint getTextboxPaint(ObjectColor colors, Collection<CardType> types, int width, boolean lessOpaqueRulesTextBox) {
        if (colors.isMulticolored()) {
            if (colors.getColorCount() == 2 && types.contains((Object)CardType.LAND)) {
                List<ObjectColor> twoColors = colors.getColors();
                Color[] translatedColors = new Color[]{RetroCardRenderer.getLessOpaqueColor(RetroCardRenderer.getLandTextboxColor(twoColors.get(0)), lessOpaqueRulesTextBox), RetroCardRenderer.getLessOpaqueColor(RetroCardRenderer.getLandTextboxColor(twoColors.get(1)), lessOpaqueRulesTextBox)};
                return new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.4f, 0.6f}, translatedColors);
            }
            if (types.contains((Object)CardType.LAND)) {
                return RetroCardRenderer.getLessOpaqueColor(LAND_TEXTBOX_GOLD, lessOpaqueRulesTextBox);
            }
            return RetroCardRenderer.getLessOpaqueColor(TEXTBOX_GOLD, lessOpaqueRulesTextBox);
        }
        if (colors.isColorless()) {
            if (types.contains((Object)CardType.LAND)) {
                return RetroCardRenderer.getLessOpaqueColor(TEXTBOX_LAND, lessOpaqueRulesTextBox);
            }
            return RetroCardRenderer.getLessOpaqueColor(TEXTBOX_COLORLESS, lessOpaqueRulesTextBox);
        }
        if (types.contains((Object)CardType.LAND)) {
            return RetroCardRenderer.getLessOpaqueColor(RetroCardRenderer.getLandTextboxColor(colors), lessOpaqueRulesTextBox);
        }
        return RetroCardRenderer.getLessOpaqueColor(RetroCardRenderer.getTextboxColor(colors), lessOpaqueRulesTextBox);
    }

    private static class RuleLayout {
        public List<AttributedString> attributedRules;
        public int remainingHeight;
        public boolean fits;
        public Font font;
        public Font fontItalic;

        private RuleLayout() {
        }
    }
}

