/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import mage.client.util.TransformedImageCache;

public class ScaledImagePanel
extends JPanel {
    private static final long serialVersionUID = -1523279873208605664L;
    private volatile BufferedImage srcImage;

    public ScaledImagePanel() {
        super(false);
        this.setOpaque(false);
    }

    public void clearImage() {
        this.srcImage = null;
        this.repaint();
    }

    public void setImage(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public boolean hasImage() {
        return this.srcImage != null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.srcImage == null) {
            return;
        }
        Insets border = this.getInsets();
        int x = border.left;
        int y = border.top;
        int width = this.getWidth() - border.left - border.right;
        int height = this.getHeight() - border.top - border.bottom;
        g.drawImage(TransformedImageCache.getResizedImage(this.srcImage, width, height), x, y, width, height, null);
        super.paint(g);
    }

    public BufferedImage getSrcImage() {
        return this.srcImage;
    }
}

