/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Font;
import java.awt.Paint;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.List;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.TextboxRuleType;

public class TextboxRule {
    public final String text;
    public final TextboxRuleType type;
    private final List<AttributeRegion> regions;

    protected TextboxRule(String text, List<AttributeRegion> regions, TextboxRuleType type) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Empty rule");
        }
        this.text = text;
        this.type = type;
        this.regions = regions;
    }

    public TextboxRule(String text, List<AttributeRegion> regions) {
        this(text, regions, TextboxRuleType.NORMAL);
    }

    public AttributedString generateAttributedString(Font normal, Font italic) {
        AttributedString attributedRule = new AttributedString(this.text);
        if (!this.text.isEmpty()) {
            attributedRule.addAttribute(TextAttribute.FONT, normal);
            for (int i = this.regions.size() - 1; i >= 0; --i) {
                this.regions.get(i).applyToAttributedString(attributedRule, normal, italic);
            }
        }
        return attributedRule;
    }

    public static class EmbeddedSymbol
    implements AttributeRegion {
        private final String symbol;
        private final int location;

        EmbeddedSymbol(String symbol, int location) {
            this.symbol = symbol;
            this.location = location;
        }

        @Override
        public void applyToAttributedString(AttributedString str, Font normal, Font italic) {
            BufferedImage symbolImage = ManaSymbols.getSizedManaSymbol(this.symbol.replace("/", ""), normal.getSize());
            if (symbolImage != null) {
                ImageGraphicAttribute imgAttr = new ImageGraphicAttribute(symbolImage, -2);
                str.addAttribute(TextAttribute.CHAR_REPLACEMENT, imgAttr, this.location, this.location + 1);
            }
        }
    }

    public static class ColorRegion
    implements AttributeRegion {
        private final int start;
        private final int end;
        private final Paint color;

        ColorRegion(int start, int end, Paint color) {
            this.start = start;
            this.end = end;
            this.color = color;
        }

        @Override
        public void applyToAttributedString(AttributedString str, Font normal, Font italic) {
            if (this.end > this.start + 1) {
                str.addAttribute(TextAttribute.FOREGROUND, this.color, this.start, this.end);
            }
        }
    }

    public static class ItalicRegion
    implements AttributeRegion {
        private final int start;
        private final int end;

        ItalicRegion(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void applyToAttributedString(AttributedString str, Font normal, Font italic) {
            if (this.end > this.start + 1) {
                str.addAttribute(TextAttribute.FONT, italic, this.start, this.end);
            }
        }
    }

    @FunctionalInterface
    public static interface AttributeRegion {
        public void applyToAttributedString(AttributedString var1, Font var2, Font var3);
    }
}

