/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.html.HTMLEditorKit;
import mage.utils.StreamUtils;

public final class UI {
    private static final ConcurrentMap<URI, Image> imageCache = new ConcurrentHashMap<URI, Image>();

    public static JToggleButton getToggleButton() {
        JToggleButton button = new JToggleButton();
        button.setMargin(new Insets(2, 4, 2, 4));
        return button;
    }

    public static JButton getButton() {
        JButton button = new JButton();
        button.setMargin(new Insets(2, 4, 2, 4));
        return button;
    }

    public static void setTitle(JPanel panel, String title) {
        Border border = panel.getBorder();
        if (border instanceof TitledBorder) {
            ((TitledBorder)panel.getBorder()).setTitle(title);
            panel.repaint();
        } else {
            panel.setBorder(BorderFactory.createTitledBorder(title));
        }
    }

    public static ImageIcon getImageIcon(String path) {
        InputStream stream = null;
        try {
            stream = UI.class.getResourceAsStream(path);
            if (stream == null && new File(path).exists()) {
                stream = new FileInputStream(path);
            }
            if (stream == null) {
                throw new RuntimeException("Image not found: " + path);
            }
            byte[] data = new byte[stream.available()];
            stream.read(data);
            ImageIcon imageIcon = new ImageIcon(data);
            return imageIcon;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading image: " + path);
        }
        finally {
            StreamUtils.closeQuietly((Closeable)stream);
        }
    }

    public static void setHTMLEditorKit(JEditorPane editorPane) {
        editorPane.setEditorKit(new HTMLEditorKit());
    }

    public static void setVerticalScrollingView(JScrollPane scrollPane, final Component view) {
        final JViewport viewport = new JViewport();
        viewport.setLayout(new ViewportLayout(){
            private static final long serialVersionUID = 7701568740313788935L;

            @Override
            public void layoutContainer(Container parent) {
                viewport.setViewPosition(new Point(0, 0));
                Dimension viewportSize = viewport.getSize();
                int width = viewportSize.width;
                int height = Math.max(view.getPreferredSize().height, viewportSize.height);
                viewport.setViewSize(new Dimension(width, height));
            }
        });
        viewport.setView(view);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewport(viewport);
    }

    public static String getDisplayManaCost(String manaCost) {
        int pipePosition = manaCost.indexOf("{|}");
        if (pipePosition != -1) {
            manaCost = manaCost.substring(pipePosition + 3);
        }
        return manaCost;
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setDefaultFont(Font font) {
        for (Object key : Collections.list(UIManager.getDefaults().keys())) {
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font);
        }
    }
}

