/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import mage.util.StreamUtils;

public final class Util {
    public static final boolean isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    public static final boolean isWindows = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    public static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            threadCount++;
            Thread thread = new Thread(runnable, "Util" + threadCount);
            thread.setDaemon(true);
            return thread;
        }
    });
    private static int threadCount;

    public static void broadcast(byte[] data, int port) throws IOException {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            Util.broadcast(socket, data, port, NetworkInterface.getNetworkInterfaces());
        }
        finally {
            StreamUtils.closeQuietly(socket);
        }
    }

    private static void broadcast(DatagramSocket socket, byte[] data, int port, Enumeration<NetworkInterface> ifaces) throws IOException {
        for (NetworkInterface iface : Collections.list(ifaces)) {
            for (InetAddress address : Collections.list(iface.getInetAddresses())) {
                if (!address.isSiteLocalAddress()) continue;
                byte[] ip = address.getAddress();
                ip[3] = -1;
                socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), port));
                ip[2] = -1;
                socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), port));
            }
        }
    }

    public static void sleep(int millis) {
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Object lock) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error invoking runnable in UI thread.", ex);
        }
    }

    static {
        threadPool.prestartAllCoreThreads();
    }
}

