/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.mage.plugins.card.dl.beans.properties.Property;
import org.mage.plugins.card.dl.lm.AbstractLaternaBean;

public class DownloadJob
extends AbstractLaternaBean {
    private final String name;
    private String url;
    private final Destination destination;
    private final boolean forceToDownload;
    private final Property<State> state;
    private final Property<String> message;
    private final Property<Exception> error;
    private final BoundedRangeModel progress;

    public DownloadJob(String name, String url, Destination destination, boolean forceToDownload) {
        this.state = this.properties.property("state", State.NEW);
        this.message = this.properties.property("message");
        this.error = this.properties.property("error");
        this.progress = new DefaultBoundedRangeModel();
        this.name = name;
        this.url = url;
        this.destination = destination;
        this.forceToDownload = forceToDownload;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setState(State state) {
        if (state == State.ABORTED) {
            this.setError("ABORTED");
        } else {
            this.state.setValue(state);
        }
    }

    public void setError(String message) {
        this.setError(message, null);
    }

    public void setError(Exception error) {
        this.setError(null, error);
    }

    public void setError(String message, Exception error) {
        if (message == null) {
            message = "Download: " + this.name + " from " + this.url + " caused error - " + error;
        }
        this.state.setValue(State.ABORTED);
        this.error.setValue(error);
        this.message.setValue(message);
    }

    public void doPrepareAndStartWork() {
        if (this.state.getValue() != State.NEW) {
            this.setError("Can't call prepare at this point.");
            return;
        }
        this.state.setValue(State.PREPARING);
        try {
            this.onPreparing();
        }
        catch (Exception e) {
            this.setError("Prepare error: " + e.getMessage(), e);
            return;
        }
        this.state.setValue(State.WORKING);
    }

    public void onPreparing() throws Exception {
    }

    public void setMessage(String message) {
        this.message.setValue(message);
    }

    public BoundedRangeModel getProgress() {
        return this.progress;
    }

    public State getState() {
        return this.state.getValue();
    }

    public Exception getError() {
        return this.error.getValue();
    }

    public String getMessage() {
        return this.message.getValue();
    }

    public String getName() {
        return this.name;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public boolean isForceToDownload() {
        return this.forceToDownload;
    }

    public static Destination toFile(String file) {
        return DownloadJob.toFile(new File(file));
    }

    public static Destination toFile(final File file) {
        return new Destination(){

            @Override
            public OutputStream open() throws IOException {
                File parent = file.getAbsoluteFile().getParentFile();
                if (!parent.mkdirs() && !parent.exists()) {
                    throw new IOException(parent + ": directory could not be created");
                }
                return new FileOutputStream(file);
            }

            @Override
            public boolean isValid() throws IOException {
                if (file.isFile()) {
                    return file.length() > 0L;
                }
                return false;
            }

            @Override
            public boolean exists() {
                return file.isFile();
            }

            @Override
            public void delete() throws IOException {
                if (file.exists() && !file.delete()) {
                    throw new IOException(file + " couldn't be deleted");
                }
            }
        };
    }

    public static interface Destination {
        public OutputStream open() throws IOException;

        public boolean exists() throws IOException;

        public boolean isValid() throws IOException;

        public void delete() throws IOException;
    }

    public static enum State {
        NEW,
        PREPARING,
        WORKING,
        FINISHED,
        ABORTED;

    }
}

