/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.beans.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public final class ListenableCollections {
    private ListenableCollections() {
    }

    public static <E> List<E> listenableList(List<E> list, ListListener<E> listener) {
        if (list instanceof RandomAccess) {
            return new ListenableList<E>(list, listener);
        }
        return new ListenableSequentialList<E>(list, listener);
    }

    public static <E> Set<E> listenableSet(Set<E> set, SetListener<E> listener) {
        return new ListenableSet<E>(set, listener);
    }

    public static <K, V> Map<K, V> listenableMap(Map<K, V> map, MapListener<K, V> listener) {
        return new ListenableMap<K, V>(map, listener);
    }

    private static class ListenableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 4032087477448965103L;
        private final Map<K, V> delegate;
        private final MapListener<K, V> listener;
        private final Set<Map.Entry<K, V>> entrySet;

        public ListenableMap(Map<K, V> map, MapListener<K, V> listener) {
            this.listener = listener;
            this.delegate = map;
            this.entrySet = new EntrySet();
        }

        @Override
        public V put(K key, V value) {
            if (this.delegate.containsKey(key)) {
                V old = this.delegate.put(key, value);
                this.listener.set(key, old, value);
                return old;
            }
            this.delegate.put(key, value);
            this.listener.put(key, value);
            return null;
        }

        @Override
        public V remove(Object key) {
            if (this.delegate.containsKey(key)) {
                V old = this.delegate.remove(key);
                this.listener.remove(key, old);
                return old;
            }
            return null;
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>>
        implements Serializable {
            private static final long serialVersionUID = -780485106953107075L;
            private final Set<Map.Entry<K, V>> delegate;

            private EntrySet() {
                this.delegate = ListenableMap.this.delegate.entrySet();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> it;
                    private boolean hasLast;
                    private Map.Entry<K, V> last;
                    {
                        this.it = EntrySet.this.delegate.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.last = this.it.next();
                        this.hasLast = true;
                        return this.last;
                    }

                    @Override
                    public void remove() {
                        if (!this.hasLast) {
                            throw new IllegalStateException();
                        }
                        this.hasLast = false;
                        this.it.remove();
                        ListenableMap.this.listener.remove(this.last.getKey(), this.last.getValue());
                    }
                };
            }
        }
    }

    public static interface MapListener<K, V>
    extends Serializable {
        public void put(K var1, V var2);

        public void set(K var1, V var2, V var3);

        public void remove(K var1, V var2);
    }

    private static class ListenableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 7728087988927063221L;
        private final Set<E> delegate;
        private final SetListener<E> listener;

        public ListenableSet(Set<E> set, SetListener<E> listener) {
            this.delegate = set;
            this.listener = listener;
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean add(E o) {
            boolean b = this.delegate.add(o);
            if (b) {
                this.listener.add(o);
            }
            return b;
        }

        @Override
        public boolean remove(Object o) {
            boolean b = this.delegate.remove(o);
            if (b) {
                this.listener.remove(o);
            }
            return b;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<E> it;
                private boolean hasLast;
                private E last;
                {
                    this.it = delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public E next() {
                    this.last = this.it.next();
                    this.hasLast = true;
                    return this.last;
                }

                @Override
                public void remove() {
                    if (!this.hasLast) {
                        throw new IllegalStateException();
                    }
                    this.it.remove();
                    listener.remove(this.last);
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    public static interface SetListener<E>
    extends Serializable {
        public void add(E var1);

        public void remove(E var1);
    }

    private static class ListenableSequentialList<E>
    extends AbstractSequentialList<E>
    implements Serializable {
        private static final long serialVersionUID = 3630474556578001885L;
        private final List<E> delegate;
        private final ListListener<E> listener;

        public ListenableSequentialList(List<E> delegate, ListListener<E> listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<E> it;
                private int lastIndex;
                private E lastValue;
                {
                    this.it = delegate.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public E next() {
                    this.lastIndex = this.it.nextIndex();
                    this.lastValue = this.it.next();
                    return this.lastValue;
                }

                @Override
                public int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public E previous() {
                    this.lastIndex = this.it.previousIndex();
                    this.lastValue = this.it.previous();
                    return this.lastValue;
                }

                @Override
                public int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public void add(E o) {
                    this.it.add(o);
                    listener.add(this.previousIndex(), o);
                }

                @Override
                public void set(E o) {
                    this.it.set(o);
                    listener.set(this.lastIndex, this.lastValue, o);
                }

                @Override
                public void remove() {
                    this.it.remove();
                    listener.remove(this.lastIndex, this.lastValue);
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    private static class ListenableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8622608480525537692L;
        private final List<E> delegate;
        private final ListListener<E> listener;

        public ListenableList(List<E> delegate, ListListener<E> listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        public void add(int index, E e) {
            this.delegate.add(index, e);
            this.listener.add(index, e);
        }

        @Override
        public E set(int index, E element) {
            E e = this.delegate.set(index, element);
            this.listener.set(index, e, element);
            return e;
        }

        @Override
        public E remove(int index) {
            E e = this.delegate.remove(index);
            this.listener.remove(index, e);
            return e;
        }

        @Override
        public E get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    public static interface ListListener<E>
    extends Serializable {
        public void add(int var1, E var2);

        public void set(int var1, E var2, E var3);

        public void remove(int var1, E var2);
    }
}

