/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.beans.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mage.plugins.card.dl.beans.properties.AbstractProperties;
import org.mage.plugins.card.dl.beans.properties.Properties;
import org.mage.plugins.card.dl.beans.properties.Property;

public class CompoundProperties
extends AbstractProperties {
    private final List<Properties> delegates;

    public CompoundProperties(Properties ... delegates) {
        this.delegates = Arrays.asList(delegates);
        Collections.reverse(this.delegates);
    }

    public CompoundProperties(List<Properties> delegates) {
        this.delegates = new ArrayList<Properties>(delegates);
        Collections.reverse(this.delegates);
    }

    @Override
    public <T> Property<T> property(String name, Property<T> property) {
        for (Properties p : this.delegates) {
            property = p.property(name, property);
        }
        return property;
    }

    @Override
    public <E> List<E> list(String name, List<E> list) {
        for (Properties p : this.delegates) {
            list = p.list(name, list);
        }
        return list;
    }

    @Override
    public <E> Set<E> set(String name, Set<E> set) {
        for (Properties p : this.delegates) {
            set = p.set(name, set);
        }
        return set;
    }

    @Override
    public <K, V> Map<K, V> map(String name, Map<K, V> map) {
        for (Properties p : this.delegates) {
            map = p.map(name, map);
        }
        return map;
    }
}

