/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.beans.properties.bound;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import org.mage.plugins.card.dl.beans.PropertyChangeSupport;
import org.mage.plugins.card.dl.beans.collections.ListenableCollections;

public class PropertyChangeMapListener<K, V>
implements ListenableCollections.MapListener<K, V> {
    private static final long serialVersionUID = 625853864429729560L;
    private final PropertyChangeSupport s;
    private final Map<K, V> map;
    private final String propertyName;

    public PropertyChangeMapListener(PropertyChangeSupport s, Map<K, V> map, String propertyName) {
        this.s = s;
        this.map = map;
        this.propertyName = propertyName;
    }

    @Override
    public void put(K key, V newValue) {
        this.s.firePropertyChange(new MapPutEvent<K, V>(this.s.getSourceBean(), this.propertyName, this.map, key, newValue));
    }

    @Override
    public void set(K key, V oldValue, V newValue) {
        this.s.firePropertyChange(new MapSetEvent<K, V>(this.s.getSourceBean(), this.propertyName, this.map, key, oldValue, newValue));
    }

    @Override
    public void remove(K key, V oldValue) {
        this.s.firePropertyChange(new MapRemoveEvent<K, V>(this.s.getSourceBean(), this.propertyName, this.map, key, oldValue));
    }

    public static class MapRemoveEvent<K, V>
    extends MapEvent<K, V> {
        private static final long serialVersionUID = -2644879706878221895L;
        private final V oldElement;

        public MapRemoveEvent(Object source, String propertyName, Map<K, V> map, K key, V oldElement) {
            super(source, propertyName, map, key);
            this.oldElement = oldElement;
        }

        public V getOldElement() {
            return this.oldElement;
        }
    }

    public static class MapSetEvent<K, V>
    extends MapEvent<K, V> {
        private static final long serialVersionUID = -2419438379909500079L;
        private final V oldElement;
        private final V newElement;

        public MapSetEvent(Object source, String propertyName, Map<K, V> map, K key, V oldElement, V newElement) {
            super(source, propertyName, map, key);
            this.oldElement = oldElement;
            this.newElement = newElement;
        }

        public V getOldElement() {
            return this.oldElement;
        }

        public V getNewElement() {
            return this.newElement;
        }
    }

    public static class MapPutEvent<K, V>
    extends MapEvent<K, V> {
        private static final long serialVersionUID = 6006291474676939650L;
        private final V newElement;

        public MapPutEvent(Object source, String propertyName, Map<K, V> map, K key, V newElement) {
            super(source, propertyName, map, key);
            this.newElement = newElement;
        }

        public V getNewElement() {
            return this.newElement;
        }
    }

    public static abstract class MapEvent<K, V>
    extends PropertyChangeEvent {
        private static final long serialVersionUID = -651568020675693544L;
        private final Map<K, V> map;
        private final K key;

        public MapEvent(Object source, String propertyName, Map<K, V> map, K key) {
            super(source, propertyName, null, null);
            this.map = map;
            this.key = key;
        }

        @Override
        public Map<K, V> getOldValue() {
            return null;
        }

        @Override
        public Map<K, V> getNewValue() {
            return this.map;
        }

        public K getKey() {
            return this.key;
        }
    }
}

