/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.beans.properties.bound;

import java.beans.PropertyChangeEvent;
import java.util.Set;
import org.mage.plugins.card.dl.beans.PropertyChangeSupport;
import org.mage.plugins.card.dl.beans.collections.ListenableCollections;

public class PropertyChangeSetListener<E>
implements ListenableCollections.SetListener<E> {
    private static final long serialVersionUID = 625853864429729560L;
    private final PropertyChangeSupport s;
    private final Set<E> set;
    private final String propertyName;

    public PropertyChangeSetListener(PropertyChangeSupport s, Set<E> set, String propertyName) {
        this.s = s;
        this.set = set;
        this.propertyName = propertyName;
    }

    @Override
    public void add(E newValue) {
        this.s.firePropertyChange(new SetAddEvent<E>(this.s.getSourceBean(), this.propertyName, this.set, newValue));
    }

    @Override
    public void remove(E oldValue) {
        this.s.firePropertyChange(new SetRemoveEvent<E>(this.s.getSourceBean(), this.propertyName, this.set, oldValue));
    }

    public static class SetRemoveEvent<E>
    extends SetEvent<E> {
        private static final long serialVersionUID = -1315342339926392385L;
        private final E oldElement;

        public SetRemoveEvent(Object source, String propertyName, Set<E> set, E oldElement) {
            super(source, propertyName, set);
            this.oldElement = oldElement;
        }

        public E getOldElement() {
            return this.oldElement;
        }
    }

    public static class SetAddEvent<E>
    extends SetEvent<E> {
        private static final long serialVersionUID = 9041766866796759871L;
        private final E newElement;

        public SetAddEvent(Object source, String propertyName, Set<E> set, E newElement) {
            super(source, propertyName, set);
            this.newElement = newElement;
        }

        public E getNewElement() {
            return this.newElement;
        }
    }

    public static abstract class SetEvent<E>
    extends PropertyChangeEvent {
        private static final long serialVersionUID = -651568020675693544L;
        private final Set<E> set;

        public SetEvent(Object source, String propertyName, Set<E> set) {
            super(source, propertyName, null, null);
            this.set = set;
        }

        @Override
        public Set<E> getOldValue() {
            return null;
        }

        @Override
        public Set<E> getNewValue() {
            return this.set;
        }
    }
}

