/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mage.util.StreamUtils;

public class CopyPasteImageSourceDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JEditorPane txtDeckList;
    private String tmpPath;
    Set<String> missingCards = null;

    public CopyPasteImageSourceDialog() {
        this.initComponents();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(e -> this.onOK());
        this.buttonCancel.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CopyPasteImageSourceDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        BufferedWriter bw = null;
        try {
            File temp = File.createTempFile("import_images_from_url", ".txt");
            bw = new BufferedWriter(new FileWriter(temp));
            bw.write(this.txtDeckList.getText());
            this.tmpPath = temp.getPath();
            StreamUtils.closeQuietly(bw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            StreamUtils.closeQuietly(bw);
        }
        this.onCancel();
    }

    private void onCancel() {
        this.dispose();
    }

    public String getTmpPath() {
        return this.tmpPath;
    }

    private void initComponents() {
        this.contentPane = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        JPanel panel3 = new JPanel();
        this.txtDeckList = new JEditorPane();
        this.contentPane.setMinimumSize(new Dimension(540, 450));
        this.contentPane.setBorder(new CompoundBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Download Images from Copy/Pasted Text", 2, 2, new Font("Dialog", 0, 12), Color.BLACK), this.contentPane.getBorder()));
        this.contentPane.addPropertyChangeListener(e -> {
            if ("border".equals(e.getPropertyName())) {
                throw new RuntimeException();
            }
        });
        this.contentPane.addPropertyChangeListener(e -> {
            if ("border".equals(e.getPropertyName())) {
                throw new RuntimeException();
            }
        });
        this.contentPane.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPane.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.contentPane.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.contentPane.getLayout()).columnWeights = new double[]{0.01, 1.0E-4};
        ((GridBagLayout)this.contentPane.getLayout()).rowWeights = new double[]{0.01, 0.0, 1.0E-4};
        panel1.setLayout(new GridBagLayout());
        ((GridBagLayout)panel1.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)panel1.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)panel1.getLayout()).columnWeights = new double[]{0.0, 0.01, 1.0E-4};
        ((GridBagLayout)panel1.getLayout()).rowWeights = new double[]{0.01, 1.0E-4};
        panel2.setLayout(new GridBagLayout());
        ((GridBagLayout)panel2.getLayout()).columnWidths = new int[]{0, 4, 0, 0};
        ((GridBagLayout)panel2.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)panel2.getLayout()).columnWeights = new double[]{0.01, 0.0, 0.01, 1.0E-4};
        ((GridBagLayout)panel2.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        this.buttonOK.setText("Download from URLs");
        panel2.add((Component)this.buttonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonCancel.setText("Cancel");
        panel2.add((Component)this.buttonCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)panel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.add((Component)panel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel3.setLayout(new GridBagLayout());
        ((GridBagLayout)panel3.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)panel3.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)panel3.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)panel3.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.txtDeckList.setMinimumSize(new Dimension(250, 400));
        this.txtDeckList.setPreferredSize(new Dimension(550, 400));
        this.txtDeckList.setText("// Example follows. \nNB: **DELETE ALL TEXT AND GO SELECT THIS SOURCE AGAIN TO SEE THE NAMES CARDS YOU'RE MISSING IMAGES FOR!!!***\n\"SWS/Might of the Wild\", \"http://i.imgur.com/eNXOdxp.jpg\"\n\"PPRE/Wolf of Devil's Breach\", \"https://img.scryfall.com/cards/large/en/psoi/192s.jpg\"\n\nExpected columns: Name of Card (Set Trigraph\\Name), URL of image\n\n\n");
        JScrollPane txtScrollableDeckList = new JScrollPane(this.txtDeckList);
        panel3.add((Component)txtScrollableDeckList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.add((Component)panel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void addMissingCards(Set<String> missingCards) {
        this.missingCards = missingCards;
        String missingCardsStr = "";
        boolean found = false;
        if (this.missingCards != null) {
            for (String card : this.missingCards) {
                found = true;
                missingCardsStr = missingCardsStr + card + "\n";
            }
        }
        if (!found) {
            missingCardsStr = "\n\nNote: Leave blank to see your missing card names!\n";
        }
        this.txtDeckList.setText(this.txtDeckList.getText() + "\n\nYour missing card images are:\n" + missingCardsStr);
    }

    public String getPastedData() {
        return this.txtDeckList.getText();
    }
}

