/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mage.client.constants.Constants;
import org.mage.plugins.card.dl.DownloadJob;
import org.mage.plugins.card.utils.CardImageUtils;

public class DirectLinksForDownload
implements Iterable<DownloadJob> {
    private static final Map<String, String> directLinks = new LinkedHashMap<String, String>();
    public static final String cardbackFilename = "cardback.jpg";
    private final File outDir = new File(CardImageUtils.getImagesDir() + Constants.RESOURCE_PATH_DEFAULT_IMAGES);

    public DirectLinksForDownload() {
        if (!this.outDir.exists()) {
            this.outDir.mkdirs();
        }
    }

    @Override
    public Iterator<DownloadJob> iterator() {
        ArrayList<DownloadJob> jobs = new ArrayList<DownloadJob>();
        for (Map.Entry<String, String> url : directLinks.entrySet()) {
            File dst = new File(this.outDir, url.getKey());
            jobs.add(new DownloadJob(url.getKey(), url.getValue(), DownloadJob.toFile(dst), true));
        }
        return jobs.iterator();
    }

    static {
        directLinks.put(cardbackFilename, "https://upload.wikimedia.org/wikipedia/en/a/aa/Magic_the_gathering-card_back.jpg");
    }
}

