/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageSource;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.images.CardDownloadData;

public enum GrabbagImageSource implements CardImageSource
{
    instance;

    private static final Logger LOGGER;
    private static final String IMGUR_IMAGE_URL = "https://i.imgur.com/";
    static final Pattern IMGUR_IMAGE_ID_PATTERN;
    private static final Set<String> supportedSets;
    Map<String, String> singleLinks = null;

    @Override
    public String getSourceName() {
        return "Grabbag";
    }

    @Override
    public float getAverageSizeKb() {
        return 74.8f;
    }

    @Override
    public String getNextHttpImageUrl() {
        return null;
    }

    @Override
    public String getFileForHttpImage(String httpImageUrl) {
        return null;
    }

    @Override
    public boolean prepareDownloadList(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        return true;
    }

    @Override
    public CardImageUrls generateCardUrl(CardDownloadData card) throws Exception {
        String postfix;
        String url;
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        if ((url = (postfix = card.getCollectorIdPostfix()).isEmpty() ? this.singleLinks.get(card.getSet() + "/" + card.getName()) : this.singleLinks.get(card.getSet() + "/" + card.getName() + "-" + postfix)) != null) {
            url = this.prepareFullUrl(card, url);
        }
        if (url != null) {
            return new CardImageUrls(url);
        }
        return null;
    }

    private void setupLinks() {
        if (this.singleLinks != null) {
            return;
        }
        this.singleLinks = new HashMap<String, String>();
        this.singleLinks.put("SWS/Forest-a", "LIpeeP9.jpeg");
        this.singleLinks.put("SWS/Forest-b", "jKwDwH7.jpeg");
        this.singleLinks.put("SWS/Forest-c", "CVb3582.jpeg");
        this.singleLinks.put("SWS/Forest-d", "q09fMW0.jpeg");
        this.singleLinks.put("SWS/Island-a", "GxITXBO.jpeg");
        this.singleLinks.put("SWS/Island-b", "vKdg4fG.jpeg");
        this.singleLinks.put("SWS/Island-c", "NPMxIew.jpeg");
        this.singleLinks.put("SWS/Island-d", "cnqFMa6.jpeg");
        this.singleLinks.put("SWS/Mountain-a", "MCii4g1.jpeg");
        this.singleLinks.put("SWS/Mountain-b", "Tb0ic31.jpeg");
        this.singleLinks.put("SWS/Mountain-c", "wqXTdsC.jpeg");
        this.singleLinks.put("SWS/Mountain-d", "9oBNCHk.jpeg");
        this.singleLinks.put("SWS/Plains-a", "HgXaAKh.jpeg");
        this.singleLinks.put("SWS/Plains-b", "Y0i7MBh.jpeg");
        this.singleLinks.put("SWS/Plains-c", "4grXQVd.jpeg");
        this.singleLinks.put("SWS/Plains-d", "kTmN8MM.jpeg");
        this.singleLinks.put("SWS/Swamp-a", "kBGj6vk.jpeg");
        this.singleLinks.put("SWS/Swamp-b", "BLJl2lf.jpeg");
        this.singleLinks.put("SWS/Swamp-c", "MLH5o2u.jpeg");
        this.singleLinks.put("SWS/Swamp-d", "Rmrv9tC.jpeg");
        this.singleLinks.put("SWS/AAT-1", "CqmDY8V.jpeg");
        this.singleLinks.put("SWS/Acklay of the Arena", "ESVRm6F.jpeg");
        this.singleLinks.put("SWS/Acquire Target", "FOskB4q.jpeg");
        this.singleLinks.put("SWS/Admiral Ackbar", "JdGpP3p.jpeg");
        this.singleLinks.put("SWS/Adroit Hateflayer", "0gSIQ4K.jpeg");
        this.singleLinks.put("SWS/Anakin Skywalker", "3pGvZZEg.png");
        this.singleLinks.put("SWS/Ancient Holocron", "fH2dVP5.jpeg");
        this.singleLinks.put("SWS/Aqualish Bounty Hunter", "Wm2aKa2.jpeg");
        this.singleLinks.put("SWS/Armed Protocol Droid", "mywdKgN.jpeg");
        this.singleLinks.put("SWS/Arrest", "VXLnNUo.jpeg");
        this.singleLinks.put("SWS/Asajj Ventress", "rOXSIwO.jpeg");
        this.singleLinks.put("SWS/AT-ST", "9sMcy3C.jpeg");
        this.singleLinks.put("SWS/Aurra Sing, Bane of Jedi", "VgbndqZ.png");
        this.singleLinks.put("SWS/A-Wing", "4TaYoRO.jpeg");
        this.singleLinks.put("SWS/Bantha Herd", "9rLPE2a.jpeg");
        this.singleLinks.put("SWS/Bathe in Bacta", "sPynQAZ.jpeg");
        this.singleLinks.put("SWS/Battle Tactics", "zoon1p4.jpeg");
        this.singleLinks.put("SWS/Bib Fortuna", "AqAmOEw.jpeg");
        this.singleLinks.put("SWS/Black Market Dealer", "EJpIxna.jpeg");
        this.singleLinks.put("SWS/Blind Worship", "GonJyeF.jpeg");
        this.singleLinks.put("SWS/Boba Fett", "XE83Ks7.jpeg");
        this.singleLinks.put("SWS/Bossk", "m91vUdJ.jpeg");
        this.singleLinks.put("SWS/Bounty Collector", "GHHxvb0.jpeg");
        this.singleLinks.put("SWS/Bounty Sniper", "ANTNrsS.jpeg");
        this.singleLinks.put("SWS/Bounty Spotter", "aB6LAZs.jpeg");
        this.singleLinks.put("SWS/Bull Rancor", "eG4mJ7o.jpeg");
        this.singleLinks.put("SWS/C-3PO and R2D2", "RTv4ikx.jpeg");
        this.singleLinks.put("SWS/Cantina Band", "PqMQP0o.jpeg");
        this.singleLinks.put("SWS/Capture", "jxoTOyC.jpeg");
        this.singleLinks.put("SWS/Carbonite Chamber", "rqEr1gm.jpeg");
        this.singleLinks.put("SWS/Chewbacca", "D3D5T42.jpeg");
        this.singleLinks.put("SWS/Chief Chirpa", "Gx3hLsg.jpeg");
        this.singleLinks.put("SWS/Cloaking Device", "Vtz1NZU.jpeg");
        this.singleLinks.put("SWS/Commander Cody", "9PGV2pV.jpeg");
        this.singleLinks.put("SWS/Condemn", "36yejT2.jpeg");
        this.singleLinks.put("SWS/Corellian Corvette", "j8uPQDY.jpeg");
        this.singleLinks.put("SWS/Crossfire", "Iz9OdPh.jpeg");
        this.singleLinks.put("SWS/Cruelty of the Sith", "q3WIYAt.jpeg");
        this.singleLinks.put("SWS/Cunning Abduction", "CueTNo7.jpeg");
        this.singleLinks.put("SWS/Dagobah Maw Slug", "SqmdUMp.jpeg");
        this.singleLinks.put("SWS/Dark Apprenticeship", "yf5MthH.jpeg");
        this.singleLinks.put("SWS/Dark Decision", "2HB5lYN.jpeg");
        this.singleLinks.put("SWS/Dark Trooper", "atKdUTA.jpeg");
        this.singleLinks.put("SWS/Darth Maul", "EwC1e1Q.jpeg");
        this.singleLinks.put("SWS/Darth Sidious, Sith Lord", "UYk3KnH.png");
        this.singleLinks.put("SWS/Darth Tyranus, Count of Serenno", "AXUfNuO.png");
        this.singleLinks.put("SWS/Darth Vader", "3pGvZZE.png");
        this.singleLinks.put("SWS/Death Trooper", "j7lWmPJ.jpeg");
        this.singleLinks.put("SWS/Deploy The Troops", "QtcN0qV.jpeg");
        this.singleLinks.put("SWS/Doom Blade", "cSuxWUr.jpeg");
        this.singleLinks.put("SWS/Droid Commando", "HkKiaBQ.jpeg");
        this.singleLinks.put("SWS/Droid Factory", "34L3ykD.jpeg");
        this.singleLinks.put("SWS/Droid Foundry", "qYijxSk.jpeg");
        this.singleLinks.put("SWS/Droideka", "BXN7t1i.jpeg");
        this.singleLinks.put("SWS/Drone Holocron", "cHzqK4v.jpeg");
        this.singleLinks.put("SWS/Echo Base Commando", "AdLjV4Y.jpeg");
        this.singleLinks.put("SWS/EMP Blast", "Y0JWgRO.jpeg");
        this.singleLinks.put("SWS/Escape Pod", "vj8gQ1u.jpeg");
        this.singleLinks.put("SWS/Ewok Ambush", "219aufH.jpeg");
        this.singleLinks.put("SWS/Ewok Firedancers", "DFAB3h4.jpeg");
        this.singleLinks.put("SWS/Ewok Village", "rgQevhZ.jpeg");
        this.singleLinks.put("SWS/Exogorth", "cS6fq3u.jpeg");
        this.singleLinks.put("SWS/Ferocity of the Underworld", "lTqtVab.jpeg");
        this.singleLinks.put("SWS/Flames of Remembrance", "WAKhi9i.jpeg");
        this.singleLinks.put("SWS/Force Choke", "Uu1QUf9.jpeg");
        this.singleLinks.put("SWS/Force Denial", "qwYGiUg.jpeg");
        this.singleLinks.put("SWS/Force Drain", "prHdDXa.jpeg");
        this.singleLinks.put("SWS/Force Healing", "kDGRFoj.jpeg");
        this.singleLinks.put("SWS/Force Lightning", "DhAE9lZ.jpeg");
        this.singleLinks.put("SWS/Force Mastery", "XPCWaP8.jpeg");
        this.singleLinks.put("SWS/Force Pull", "rWWfkhX.jpeg");
        this.singleLinks.put("SWS/Force Push", "aN8n4sk.jpeg");
        this.singleLinks.put("SWS/Force Reflex", "RIlvXTz.jpeg");
        this.singleLinks.put("SWS/Force Scream", "EsagOnR.jpeg");
        this.singleLinks.put("SWS/Force Spark", "14MOM1y.jpeg");
        this.singleLinks.put("SWS/Fulfill Contract", "FtLMpHK.jpeg");
        this.singleLinks.put("SWS/Gamorrean Prison Guard", "4dgOMPA.jpeg");
        this.singleLinks.put("SWS/General Grievous", "tRLM8Hz.jpeg");
        this.singleLinks.put("SWS/Gifted Initiate", "NDePdLv.jpeg");
        this.singleLinks.put("SWS/Grand Moff Tarkin", "QXq1V40.jpeg");
        this.singleLinks.put("SWS/Greater Krayt Dragon", "dzIiXXg.jpeg");
        this.singleLinks.put("SWS/Greedo", "IRKwsX0.jpeg");
        this.singleLinks.put("SWS/Gundark", "zLxfLM8.jpeg");
        this.singleLinks.put("SWS/Gungan Captain", "1Q4DNWh.jpeg");
        this.singleLinks.put("SWS/Han Solo", "G0Awota.jpeg");
        this.singleLinks.put("SWS/Hazard Trooper", "ZOutamG.jpeg");
        this.singleLinks.put("SWS/Head Hunting", "7OT1bGZ.jpeg");
        this.singleLinks.put("SWS/Heavy Trooper", "HhZWs2N.jpeg");
        this.singleLinks.put("SWS/Hot Pursuit (Star Wars)", "ih1GT5Z.jpeg");
        this.singleLinks.put("SWS/Hungry Dragonsnake", "23v7RTm.jpeg");
        this.singleLinks.put("SWS/Hunt to Extinction", "3eJyfzZ.jpeg");
        this.singleLinks.put("SWS/Hutt Crime Lord", "NAzK7Hp.jpeg");
        this.singleLinks.put("SWS/Hutt Palace", "HEb2JN5.jpeg");
        this.singleLinks.put("SWS/IG-88B", "YZUZJC8.jpeg");
        this.singleLinks.put("SWS/Images of the Past", "sOXEk4Q.jpeg");
        this.singleLinks.put("SWS/Imperial Gunner", "9KpZ8AX.jpeg");
        this.singleLinks.put("SWS/Impulsive Wager", "lLutRRs.jpeg");
        this.singleLinks.put("SWS/Insatiable Rakghoul", "IYqBnTK.jpeg");
        this.singleLinks.put("SWS/Interrogation", "kI2bIbo.jpeg");
        this.singleLinks.put("SWS/Ion Cannon", "Tb546IK.jpeg");
        this.singleLinks.put("SWS/Iron Fist of the Empire", "9Ui7NRn.jpeg");
        this.singleLinks.put("SWS/Ithorian Initiate", "2RYpp5o.jpeg");
        this.singleLinks.put("SWS/Jabba the Hutt", "QMz0sKa.jpeg");
        this.singleLinks.put("SWS/Jango Fett", "nEnspQP.jpeg");
        this.singleLinks.put("SWS/Jar Jar Binks", "GCnx72b.jpeg");
        this.singleLinks.put("SWS/Jar'Kai Battle Stance", "GLavgj7.jpeg");
        this.singleLinks.put("SWS/Jedi Battle Healer", "RyIJON5.jpeg");
        this.singleLinks.put("SWS/Jedi Battle Mage", "V9qHRGq.jpeg");
        this.singleLinks.put("SWS/Jedi Battle Sage", "sZVlGWE.jpeg");
        this.singleLinks.put("SWS/Jedi Enclave", "FlibBhx.jpeg");
        this.singleLinks.put("SWS/Jedi Holocron", "ojbt2av.jpeg");
        this.singleLinks.put("SWS/Jedi Inquirer", "ghFQA76.jpeg");
        this.singleLinks.put("SWS/Jedi Instructor", "IwEpVkz.jpeg");
        this.singleLinks.put("SWS/Jedi Knight", "VXNHpZs.jpeg");
        this.singleLinks.put("SWS/Jedi Mind Trick", "aaVfgSA.jpeg");
        this.singleLinks.put("SWS/Jedi Sentinel", "cae3O1s.jpeg");
        this.singleLinks.put("SWS/Jedi Starfighter", "Ta20jjD.jpeg");
        this.singleLinks.put("SWS/Jedi Temple", "ZkOUJnM.jpeg");
        this.singleLinks.put("SWS/Jedi Training", "7L1LWie.jpeg");
        this.singleLinks.put("SWS/Jump Trooper", "62Pg5r4.jpeg");
        this.singleLinks.put("SWS/Jungle Village", "3a1KN8u.jpeg");
        this.singleLinks.put("SWS/Kamino Cloning Facility", "kwBudvf.jpeg");
        this.singleLinks.put("SWS/Ki-Adi-Mundi", "atqNF3H.jpeg");
        this.singleLinks.put("SWS/LAAT Gunship", "DEMXleY.jpeg");
        this.singleLinks.put("SWS/Lando Calrissian", "jcoTjGV.jpeg");
        this.singleLinks.put("SWS/Legacy of the Beloved", "Y0ObvQg.jpeg");
        this.singleLinks.put("SWS/Lightning Bolt", "XSNGQYi.jpeg");
        this.singleLinks.put("SWS/Lightsaber", "YrpWygk.jpeg");
        this.singleLinks.put("SWS/Loyal Tauntaun", "JKDV2WK.jpeg");
        this.singleLinks.put("SWS/Luke Skywalker", "9worW6q.jpeg");
        this.singleLinks.put("SWS/Mace Windu", "rmTuBGT.jpeg");
        this.singleLinks.put("SWS/Maintenance Droid", "A66IIC1.jpeg");
        this.singleLinks.put("SWS/Maintenance Hangar", "DzCYnH3.jpeg");
        this.singleLinks.put("SWS/Mantellian Savrip", "a9JIDEM.jpeg");
        this.singleLinks.put("SWS/March of the Droids", "A4HIQ5V.jpeg");
        this.singleLinks.put("SWS/Massiff Swarm", "0qRPfbC.jpeg");
        this.singleLinks.put("SWS/Might of the Wild", "eNXOdxp.jpeg");
        this.singleLinks.put("SWS/Millennium Falcon", "aZ6sIn2.jpeg");
        this.singleLinks.put("SWS/Miraculous Recovery", "DH6Cei8.jpeg");
        this.singleLinks.put("SWS/Moisture Farm", "S6kJHtL.jpeg");
        this.singleLinks.put("SWS/Mon Calamari Cruiser", "ZHdTV7p.jpeg");
        this.singleLinks.put("SWS/Mon Calamari Initiate", "GBuXdGP.jpeg");
        this.singleLinks.put("SWS/N-1 Starfighter", "UH3qd7x.jpeg");
        this.singleLinks.put("SWS/Nebulon-B Frigate", "F0yIR08.jpeg");
        this.singleLinks.put("SWS/Neophyte Hateflayer", "Has2AIW.jpeg");
        this.singleLinks.put("SWS/Nerf Herder", "VUX0LHV.jpeg");
        this.singleLinks.put("SWS/Nexu Stalker", "E1xxHe1.jpeg");
        this.singleLinks.put("SWS/Nightspider", "H1po0uV.jpeg");
        this.singleLinks.put("SWS/No Contest", "6SwC9ri.jpeg");
        this.singleLinks.put("SWS/Novice Bounty Hunter", "WfNSsLY.jpeg");
        this.singleLinks.put("SWS/Nute Gunray", "UZg12DD.jpeg");
        this.singleLinks.put("SWS/Obi-Wan Kenobi", "BHkbjdL.png");
        this.singleLinks.put("SWS/Open Season", "E4iM90K.jpeg");
        this.singleLinks.put("SWS/Orbital Bombardment", "Ov1mB3A.jpeg");
        this.singleLinks.put("SWS/Order 66", "jZituQQ.jpeg");
        this.singleLinks.put("SWS/Ortolan Keyboardist", "dYDgEUB.jpeg");
        this.singleLinks.put("SWS/Outer Rim Slaver", "xq8ozqq.jpeg");
        this.singleLinks.put("SWS/Outlaw Holocron", "mWbyX78.jpeg");
        this.singleLinks.put("SWS/Personal Energy Shield", "v6TGLne.jpeg");
        this.singleLinks.put("SWS/Plo Koon", "dDNi8CV.jpeg");
        this.singleLinks.put("SWS/Precipice of Mortis", "TRAPT86.jpeg");
        this.singleLinks.put("SWS/Predator's Strike", "pcBoUny.jpeg");
        this.singleLinks.put("SWS/Preordain", "u8nSNQW.jpeg");
        this.singleLinks.put("SWS/Primal Instinct", "bInouYH.jpeg");
        this.singleLinks.put("SWS/Princess Leia", "pnHyPWg.jpeg");
        this.singleLinks.put("SWS/Probe Droid", "0r84uUM.jpeg");
        this.singleLinks.put("SWS/Qui-Gon Jinn", "7DdumG2.jpeg");
        this.singleLinks.put("SWS/Raging Reek", "9maXaMR.jpeg");
        this.singleLinks.put("SWS/Rallying Fire", "wtaTlhd.jpeg");
        this.singleLinks.put("SWS/Ravenous Wampa", "rHDaKDD.jpeg");
        this.singleLinks.put("SWS/Regression", "j5z0TOE.jpeg");
        this.singleLinks.put("SWS/Republic Frigate", "LzNpjxP.jpeg");
        this.singleLinks.put("SWS/Repurpose", "BvRMy3f.jpeg");
        this.singleLinks.put("SWS/Revenge (Star Wars)", "xkKzMRX.jpeg");
        this.singleLinks.put("SWS/Riding Ronto", "xECBi7G.jpeg");
        this.singleLinks.put("SWS/Rocket Trooper", "94wUTH5.jpeg");
        this.singleLinks.put("SWS/Rogue's Passage", "UunpJPZ.jpeg");
        this.singleLinks.put("SWS/Rule of two", "wNqZWLJ.jpeg");
        this.singleLinks.put("SWS/Rumination", "nSD3UHQ.jpeg");
        this.singleLinks.put("SWS/Rumor Monger", "wSN6H6v.jpeg");
        this.singleLinks.put("SWS/Sabacc Game", "qIcFb3U.jpeg");
        this.singleLinks.put("SWS/Salvage Squad", "ThYSxmD.jpeg");
        this.singleLinks.put("SWS/Sand Trooper", "ysfpyL8.jpeg");
        this.singleLinks.put("SWS/Sarlacc Pit", "N4dcnln.png");
        this.singleLinks.put("SWS/Scout the Perimeter", "2cObUbz.jpeg");
        this.singleLinks.put("SWS/Scout Trooper", "9RAY4U1.jpeg");
        this.singleLinks.put("SWS/Security Droid", "dzy8m4v.jpeg");
        this.singleLinks.put("SWS/Senator Bail Organa", "BRkUuYU.jpeg");
        this.singleLinks.put("SWS/Senator Lott Dod", "yYQtXZo.jpeg");
        this.singleLinks.put("SWS/Senator Onaconda Farr", "oPez77z.png");
        this.singleLinks.put("SWS/Senator Padme Amidala", "287deD9.jpeg");
        this.singleLinks.put("SWS/Senator Passel Argente", "51qpnaE.jpeg");
        this.singleLinks.put("SWS/Shaak Herd", "PtnZD0I.jpeg");
        this.singleLinks.put("SWS/Shadow Trooper", "09NAiGa.jpeg");
        this.singleLinks.put("SWS/Shock Trooper", "UVNOxMR.jpeg");
        this.singleLinks.put("SWS/Show of Dominance", "ru2D3Qp.jpeg");
        this.singleLinks.put("SWS/Sith Assassin", "Nt8WUCj.jpeg");
        this.singleLinks.put("SWS/Sith Citadel", "bBCbK30.jpeg");
        this.singleLinks.put("SWS/Sith Evoker", "jwRzCEB.jpeg");
        this.singleLinks.put("SWS/Sith Holocron", "07Ufx5X.jpeg");
        this.singleLinks.put("SWS/Sith Inquisitor", "NivI1E5.jpeg");
        this.singleLinks.put("SWS/Sith Lord", "lWBfQoA.jpeg");
        this.singleLinks.put("SWS/Sith Magic", "cDPFeve.jpeg");
        this.singleLinks.put("SWS/Sith Manipulator", "Q7CIvyz.jpeg");
        this.singleLinks.put("SWS/Sith Marauder", "9zZUSJW.jpeg");
        this.singleLinks.put("SWS/Sith Mindseer", "Lmps3oO.jpeg");
        this.singleLinks.put("SWS/Sith Ravager", "nl9Dp41.jpeg");
        this.singleLinks.put("SWS/Sith Ruins", "oSqiYyO.jpeg");
        this.singleLinks.put("SWS/Sith Sorcerer", "Pq37iop.jpeg");
        this.singleLinks.put("SWS/Sith Thoughtseeker", "YzIY1di.jpeg");
        this.singleLinks.put("SWS/Slave I", "QUGpxlb.jpeg");
        this.singleLinks.put("SWS/Smash to Smithereens", "UlzDZWp.jpeg");
        this.singleLinks.put("SWS/Snow Trooper", "28Jp5JL.jpeg");
        this.singleLinks.put("SWS/Speeder Trooper", "BIEnTDL.jpeg");
        this.singleLinks.put("SWS/Star Destroyer", "DYUMXHZ.jpeg");
        this.singleLinks.put("SWS/Strike Team Commando", "783ZFsF.jpeg");
        this.singleLinks.put("SWS/Super Battle Droid", "T8IjrKD.jpeg");
        this.singleLinks.put("SWS/Surprise Maneuver", "uaAmzz8.jpeg");
        this.singleLinks.put("SWS/Swarm the Skies", "Ti1McaV.jpeg");
        this.singleLinks.put("SWS/Syndicate Enforcer", "xZ0g2Sx.jpeg");
        this.singleLinks.put("SWS/Tank Droid", "N4YyMje.jpeg");
        this.singleLinks.put("SWS/Terentatek Cub", "nbmBxst.jpeg");
        this.singleLinks.put("SWS/The Battle of Endor", "vhL6gdI.jpeg");
        this.singleLinks.put("SWS/The Battle of Geonosis", "7Fnr2MD.jpeg");
        this.singleLinks.put("SWS/The Battle of Hoth", "wcVJwKP.jpeg");
        this.singleLinks.put("SWS/The Battle of Naboo", "aesSN9E.jpeg");
        this.singleLinks.put("SWS/The Battle of Yavin", "AtGE49k.jpeg");
        this.singleLinks.put("SWS/The Death Star", "2LjSXa9.jpeg");
        this.singleLinks.put("SWS/TIE Bomber", "R2l7ZXQ.jpeg");
        this.singleLinks.put("SWS/TIE Interceptor", "fYY4PUR.jpeg");
        this.singleLinks.put("SWS/Trade Federation Battleship", "sKN9Gzv.jpeg");
        this.singleLinks.put("SWS/Tri-Fighter", "IhwHzqT.jpeg");
        this.singleLinks.put("SWS/Trooper Armor", "nqnFj9f.jpeg");
        this.singleLinks.put("SWS/Trooper Commando", "PiAYXJv.jpeg");
        this.singleLinks.put("SWS/Twi'lek Seductress", "iPhUxUV.jpeg");
        this.singleLinks.put("SWS/Ugnaught Scrap Worker", "fuuNN3n.jpeg");
        this.singleLinks.put("SWS/Underworld Slums", "o4CFq3x.jpeg");
        this.singleLinks.put("SWS/Unity of the Droids", "WFAIRy3.jpeg");
        this.singleLinks.put("SWS/Unruly Sureshot", "AHymfLc.jpeg");
        this.singleLinks.put("SWS/Vapor Snag", "8g3q0ny.jpeg");
        this.singleLinks.put("SWS/V-Wing", "7eThuU9.jpeg");
        this.singleLinks.put("SWS/Weequay Beastmaster", "metAs1p.jpeg");
        this.singleLinks.put("SWS/Wild Holocron", "adw7dFO.jpeg");
        this.singleLinks.put("SWS/Wisdom of the Jedi", "TgTj2Dd.jpeg");
        this.singleLinks.put("SWS/Womp Rat", "XKF79Hr.jpeg");
        this.singleLinks.put("SWS/Wookiee Bounty Hunter", "A76UGTJ.jpeg");
        this.singleLinks.put("SWS/Wookiee Mystic", "8DCkOVe.jpeg");
        this.singleLinks.put("SWS/Wookiee Raidleader", "ZZTduL5.jpeg");
        this.singleLinks.put("SWS/X-Wing", "AV1LPuZ.jpeg");
        this.singleLinks.put("SWS/Yoda, Jedi Master", "6arN1Hl.png");
        this.singleLinks.put("SWS/Y-Wing", "aQQ5zwA.jpeg");
        this.singleLinks.put("SWS/Zam Wesell", "ToG0C1r.jpeg");
        this.singleLinks.put("SWS/Astromech Droid", "v0TpHMh.jpeg");
        this.singleLinks.put("SWS/Buried Ruin", "QkmIWYg.png");
        this.singleLinks.put("SWS/Flame Trooper", "RkY7KFJ.jpeg");
        this.singleLinks.put("SWS/Force Stasis", "FavLrcY.jpeg");
        this.singleLinks.put("SWS/Salvage Trader", "qGwk7Bn.jpeg");
        this.singleLinks.put("SWS/Outer Rim Gang", "kEjKQGy.png");
        this.singleLinks.put("SWS/Rathtar", "CYhHRqF.png");
        this.singleLinks.put("SWS/Riot Trooper", "PusvaQB.jpeg");
        this.singleLinks.put("SWS/Sins of the Father", "32YHTPB.jpeg");
        this.singleLinks.put("SWS/Upsilon-class Shuttle", "Le3F3oW.jpeg");
        this.singleLinks.put("SWS/Finn", "TU2LI2q.jpeg");
        this.singleLinks.put("SWS/General Hux", "UpWfcV6.png");
        this.singleLinks.put("SWS/Poe Dameron", "v8i21dn.png");
        this.singleLinks.put("SWS/Rey", "7n5ZZFA.png");
        this.singleLinks.put("SWS/Kylo Ren", "fFzDMTz.png");
        this.singleLinks.put("SWS/TIE Striker", "6b5GDUQ.jpeg");
        this.singleLinks.put("SWS/Bludgeoning Pain", "ap5k3Wl.jpeg");
        this.singleLinks.put("SWS/Force Protection", "GrOQLHO.jpeg");
        this.singleLinks.put("SWS/Gerrera's Revolutionary", "FQFE1Jt.jpeg");
        this.singleLinks.put("SWS/Thermal Detonator", "gTPLM83.jpeg");
        this.singleLinks.put("SWS/Hammerhead Corvette", "IlhOAGv.jpeg");
        this.singleLinks.put("SWS/U-Wing", "FmoRCmG.jpeg");
        this.singleLinks.put("SWS/Bor Gullet", "jXafYHX.jpeg");
        this.singleLinks.put("SWS/Imperial Hovertank", "6X1wL4d.jpeg");
        this.singleLinks.put("SWS/Occupation", "h4mmkA5.jpeg");
        this.singleLinks.put("SWS/Resistance", "lbNhA59.jpeg");
        this.singleLinks.put("SWS/Jyn Erso and Cassian Andor", "o0SCGiJ.jpeg");
        this.singleLinks.put("SWS/Chirrut Imwe", "wgtXfUF.jpeg");
        this.singleLinks.put("SWS/Director Krennic", "52PGsH5.jpeg");
        this.singleLinks.put("SWS/Vader's Command", "7Lql6UT.jpeg");
        this.singleLinks.put("SWS/Delay Tactic", "ubmzD1m.jpeg");
        this.singleLinks.put("SWS/Resistance Bomber", "Sudfkd7.jpeg");
        this.singleLinks.put("SWS/Mouse Droid", "oO0p8QE.jpeg");
        this.singleLinks.put("SWS/First Order Dreadnought", "80pO9Cc.jpeg");
        this.singleLinks.put("SWS/TIE Silencer", "7yeYIjX.jpeg");
        this.singleLinks.put("SWS/Canto Bight Enforcer", "VKPQVsn.jpeg");
        this.singleLinks.put("SWS/Cantonica Casino", "7LiSvy6.jpeg");
        this.singleLinks.put("SWS/Fathier", "0oKquQp.jpeg");
        this.singleLinks.put("SWS/Code Slice", "7uNASji.jpeg");
        this.singleLinks.put("SWS/Captain Phasma", "LWujx1B.jpeg");
        this.singleLinks.put("SWS/Force Telepathy", "e90hswX.jpeg");
        this.singleLinks.put("SWS/Praetorian Trooper", "pjS1wyS.jpeg");
        this.singleLinks.put("SWS/Supreme Leader Snoke", "eewWiKE.jpeg");
        this.singleLinks.put("SWS/Sai Tok", "FVn29tT.jpeg");
        this.singleLinks.put("SWS/Porg Nest", "8DnNZKc.jpeg");
        this.singleLinks.put("SWS/Inspire", "7lIXhtd.jpeg");
        this.singleLinks.put("SWS/Force Projection", "5EfOwyn.jpeg");
        this.singleLinks.put("SWS/Luke Skywalker, the Last Jedi", "WMmQcyD.jpeg");
        this.singleLinks.put("SWS/Vulptex", "30WeCkw.jpeg");
        this.singleLinks.put("SWS/Glorious Charge", "yJwvKzk.jpeg");
        this.singleLinks.put("SWS/Plains-520b", "Fx59r9J.jpeg");
        this.singleLinks.put("SWS/Island-520a", "jIPpWp5.jpeg");
        this.singleLinks.put("SWS/Conscription", "An01yAe.jpeg");
        this.singleLinks.put("SWS/Afterburn", "2ydqSvT.jpeg");
        this.singleLinks.put("SWS/Corellian Gunship", "mZdDQWH.jpeg");
        this.singleLinks.put("SWS/Despair", "TLTddMI.jpeg");
        this.singleLinks.put("SWS/Dryden Vos", "6LbtUzN.jpeg");
        this.singleLinks.put("SWS/Droid Uprising", "aWuoxho.jpeg");
        this.singleLinks.put("SWS/Gamble", "Hwzr60O.jpeg");
        this.singleLinks.put("SWS/Han Solo, Scrumrat", "Hqj39dG.jpeg");
        this.singleLinks.put("SWS/Mud Trooper", "af8JaDy.jpeg");
        this.singleLinks.put("SWS/Enfys Nest", "pstVfQg.jpeg");
        this.singleLinks.put("SWS/Kalevan Star Yacht", "nHmSizp.jpeg");
        this.singleLinks.put("SWS/Maelstrom Blockade", "sUYT0pc.jpeg");
        this.singleLinks.put("SWS/Range Trooper", "kXGvTkE.jpeg");
        this.singleLinks.put("SWS/Tobias Beckett", "hzm6ilE.jpeg");
        this.singleLinks.put("SWS/Underground Forum", "FH2pRfU.jpeg");
        this.singleLinks.put("SWS/Chewbacca, the Beast", "Zb5TitZ.jpeg");
        this.singleLinks.put("SWS/A Jedi's Fervor", "5MjPOpE.jpeg");
        this.singleLinks.put("SWS/Allegiant General Pryde", "Ucithhc.jpeg");
        this.singleLinks.put("SWS/Balance", "EMdbTBj.jpeg");
        this.singleLinks.put("SWS/Band Together", "xc9dQaZ.jpeg");
        this.singleLinks.put("SWS/Ben Solo", "4GXbkI3.jpeg");
        this.singleLinks.put("SWS/Betray", "SjyF6Nq.jpeg");
        this.singleLinks.put("SWS/Brave the Elements", "z2etu3V.jpeg");
        this.singleLinks.put("SWS/Culling Dais", "NHRMrmo.jpeg");
        this.singleLinks.put("SWS/Droidsmith", "HYyiEI7.jpeg");
        this.singleLinks.put("SWS/Dyad Force Transfer", "dmyQ7Jm.jpeg");
        this.singleLinks.put("SWS/Festival of the Ancestors", "JUPnIEr.jpeg");
        this.singleLinks.put("SWS/First Order Jet Trooper", "wVqmWMK.jpeg");
        this.singleLinks.put("SWS/Force Lift", "46eGWAq.jpeg");
        this.singleLinks.put("SWS/General Organa", "YSv61yR.jpeg");
        this.singleLinks.put("SWS/Hidden Base", "M6BR6aH.jpeg");
        this.singleLinks.put("SWS/Hold Captive", "3dR542o.jpeg");
        this.singleLinks.put("SWS/Holochess", "lPS1mR6.jpeg");
        this.singleLinks.put("SWS/Knights of Ren", "vdXyRpy.jpeg");
        this.singleLinks.put("SWS/Lightspeed Skipping", "VRquVqA.jpeg");
        this.singleLinks.put("SWS/Luke's Lightsaber", "Ty3j9y3.jpeg");
        this.singleLinks.put("SWS/Mimic Vat", "9bAK1LC.jpeg");
        this.singleLinks.put("SWS/Orbak", "8RvSbhX.jpeg");
        this.singleLinks.put("SWS/Propaganda", "TBNlxqj.jpeg");
        this.singleLinks.put("SWS/Rey Skywalker", "dOyjNXc.jpeg");
        this.singleLinks.put("SWS/Rey's Lightsaber", "eMzKXAP.jpeg");
        this.singleLinks.put("SWS/Sith Eternal Lightning", "oaFkj3N.jpeg");
        this.singleLinks.put("SWS/Sith Wayfinder", "AznLRt0.jpeg");
        this.singleLinks.put("SWS/Swamp-e", "LrbqB3U.jpeg");
        this.singleLinks.put("SWS/Training Droid", "JCY9KOM.jpeg");
        this.singleLinks.put("SWS/Unpleasant Discovery", "lDKoeAu.jpeg");
        this.singleLinks.put("SWS/Vexis", "cNQX9Ue.jpeg");
        this.singleLinks.put("SWS/War Room (Star Wars)", "pqQ9kzt.jpeg");
        this.singleLinks.put("SWS/Xyston Star Destroyer", "oqbHtUC.jpeg");
        this.singleLinks.put("SWS/Zorii Bliss", "vOyNE39.jpeg");
        this.singleLinks.put("ATC/Blinding Radiance", "4B4lBl5.jpeg");
        this.singleLinks.put("ATC/Goblin Bruiser", "Di5I8tS.jpeg");
        this.singleLinks.put("ATC/Ogre Painbringer", "eA3zL7Y.jpeg");
        this.singleLinks.put("ATC/Titanic Pelagosaur", "KWSsiKD.jpeg");
        this.singleLinks.put("ATC/Treetop Recluse", "uHnQYpp.jpeg");
        this.singleLinks.put("SWS/Emblem Obi-Wan Kenobi", "Qyc10aT.png");
        this.singleLinks.put("SWS/Emblem Aurra Sing", "BLWbVJC.png");
        this.singleLinks.put("SWS/Emblem Yoda", "zH0sYxg.png");
        this.singleLinks.put("SWS/Emblem Luke Skywalker", "kHELZDJ.jpeg");
        this.singleLinks.put("SWS/Ewok", "N2MvJyr.png");
        this.singleLinks.put("SWS/B-Wing", "oH62AUD.png");
        this.singleLinks.put("SWS/Hunter", "oJiawFA.png");
        this.singleLinks.put("SWS/TIE Fighter", "CLOuJ05.png");
        this.singleLinks.put("SWS/Trooper", "2XKqdX5.png");
        this.singleLinks.put("SWS/AT-AT", "Tv5b7h1.png");
        this.singleLinks.put("SWS/Rebel", "pVoShnF.png");
        this.singleLinks.put("SWS/Royal Guard", "9tqE8vL.png");
        this.singleLinks.put("SWS/Tusken Raider", "gPMiSmP.png");
        this.singleLinks.put("SWS/Droid", "4PRrWFF.png");
        this.singleLinks.put("SWS/Trooper 2", "tcxvGOn.jpeg");
        this.singleLinks.put("SWS/Porg", "HBjt1A3.jpeg");
    }

    @Override
    public CardImageUrls generateTokenUrl(CardDownloadData card) throws IOException {
        try {
            return this.generateCardUrl(card);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getTotalImages() {
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        if (this.singleLinks != null) {
            return this.singleLinks.size();
        }
        return -1;
    }

    @Override
    public boolean isTokenSource() {
        return true;
    }

    @Override
    public Map<String, String> getHttpRequestHeaders(String fullUrl) {
        Map<String, String> headers = CardImageSource.super.getHttpRequestHeaders(fullUrl);
        if (fullUrl.startsWith(IMGUR_IMAGE_URL)) {
            Matcher matcher = IMGUR_IMAGE_ID_PATTERN.matcher(fullUrl);
            if (matcher.find()) {
                headers.put("Host", "imgur.com");
                headers.put("Referer", "https://imgur.com/" + matcher.group(1));
            } else {
                LOGGER.error((Object)("Can't find image id from url " + fullUrl));
            }
        }
        return headers;
    }

    @Override
    public boolean isCardSource() {
        return true;
    }

    private String prepareFullUrl(CardDownloadData card, String url) {
        if (url.startsWith("http")) {
            return url;
        }
        return IMGUR_IMAGE_URL + url;
    }

    @Override
    public List<String> getSupportedSets() {
        return new ArrayList<String>(supportedSets);
    }

    @Override
    public boolean isCardImageProvided(String setCode, String cardName) {
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        return this.singleLinks.containsKey(setCode + "/" + cardName) || this.singleLinks.containsKey(setCode + "/" + cardName + "-a") || this.singleLinks.containsKey(setCode + "/" + cardName + "-b") || this.singleLinks.containsKey(setCode + "/" + cardName + "-c") || this.singleLinks.containsKey(setCode + "/" + cardName + "-d");
    }

    @Override
    public boolean isTokenImageProvided(String setCode, String cardName, Integer tokenNumber) {
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        return this.singleLinks.containsKey(setCode + "/" + cardName);
    }

    static {
        LOGGER = Logger.getLogger(GrabbagImageSource.class);
        IMGUR_IMAGE_ID_PATTERN = Pattern.compile("imgur\\.com\\/(\\w+)");
        supportedSets = new LinkedHashSet<String>(){
            {
                this.add("SWS");
                this.add("ATC");
            }
        };
    }
}

