/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import mage.MageException;
import mage.client.remote.XmageURLConnection;
import mage.client.util.CardLanguage;
import mage.util.JsonUtil;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileOutputStream;
import net.java.truevfs.access.TVFS;
import org.apache.log4j.Logger;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageSource;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.dl.sources.ScryfallApiBulkData;
import org.mage.plugins.card.dl.sources.ScryfallApiCard;
import org.mage.plugins.card.dl.sources.ScryfallImageSupportCards;
import org.mage.plugins.card.dl.sources.ScryfallImageSupportTokens;
import org.mage.plugins.card.images.CardDownloadData;
import org.mage.plugins.card.utils.CardImageUtils;

public class ScryfallImageSource
implements CardImageSource {
    private static final ScryfallImageSource instance = new ScryfallImageSource();
    private static final Logger logger = Logger.getLogger(ScryfallImageSource.class);
    private final Map<CardLanguage, String> languageAliases;
    private CardLanguage currentLanguage = CardLanguage.ENGLISH;
    private final Map<CardDownloadData, String> preparedUrls = new HashMap<CardDownloadData, String>();
    private static final ReentrantLock waitBeforeRequestLock = new ReentrantLock();
    private static final int DOWNLOAD_TIMEOUT_MS = 300;
    private static final boolean SCRYFALL_BULK_FILES_ENABLED = true;
    private static final long SCRYFALL_BULK_FILES_OUTDATE_IN_MILLIS = 604800000L;
    private static final String SCRYFALL_BULK_FILES_DATABASE_SOURCE_API = "https://api.scryfall.com/bulk-data/all-cards";
    private static final boolean SCRYFALL_BULK_FILES_DEBUG_READ_ONLY_MODE = false;
    private static final String SCRYFALL_BULK_FILES_PROPERTY = "xmage.scryfallEnableBulkData";
    private static final List<ScryfallApiCard> bulkCardsDatabaseAll = new ArrayList<ScryfallApiCard>();
    private static final Map<String, ScryfallApiCard> bulkCardsDatabaseDefault = new HashMap<String, ScryfallApiCard>();

    public static ScryfallImageSource getInstance() {
        return instance;
    }

    ScryfallImageSource() {
        this.languageAliases = new HashMap<CardLanguage, String>();
        this.languageAliases.put(CardLanguage.ENGLISH, "en");
        this.languageAliases.put(CardLanguage.SPANISH, "es");
        this.languageAliases.put(CardLanguage.FRENCH, "fr");
        this.languageAliases.put(CardLanguage.GERMAN, "de");
        this.languageAliases.put(CardLanguage.ITALIAN, "it");
        this.languageAliases.put(CardLanguage.PORTUGUESE, "pt");
        this.languageAliases.put(CardLanguage.JAPANESE, "ja");
        this.languageAliases.put(CardLanguage.KOREAN, "ko");
        this.languageAliases.put(CardLanguage.RUSSIAN, "ru");
        this.languageAliases.put(CardLanguage.CHINES_SIMPLE, "zhs");
        this.languageAliases.put(CardLanguage.CHINES_TRADITION, "zht");
    }

    private CardImageUrls innerGenerateURL(CardDownloadData card, boolean isToken) {
        String link;
        String prepared = this.preparedUrls.getOrDefault(card, null);
        if (prepared != null) {
            return new CardImageUrls(prepared);
        }
        String defaultCode = CardLanguage.ENGLISH.getCode();
        String localizedCode = this.languageAliases.getOrDefault((Object)this.getCurrentLanguage(), defaultCode);
        String baseUrl = null;
        String alternativeUrl = null;
        if (isToken) {
            baseUrl = ScryfallImageSupportTokens.findTokenLink(card.getSet(), card.getName(), card.getImageNumber());
            alternativeUrl = null;
        }
        if (baseUrl == null && (link = ScryfallImageSupportCards.findDirectDownloadLink(card.getSet(), card.getName(), card.getCollectorId())) != null) {
            if (ScryfallImageSupportCards.isApiLink(link)) {
                baseUrl = link + localizedCode + "?format=image";
                if (link.endsWith("/")) {
                    alternativeUrl = link.substring(0, link.length() - 1) + "?format=image";
                }
            } else {
                baseUrl = link;
                if (link.contains("/?format=image")) {
                    baseUrl = link.replaceFirst("\\?format=image", localizedCode + "?format=image");
                    alternativeUrl = link.replaceFirst("/\\?format=image", "?format=image");
                }
            }
        }
        if (card.isSecondSide()) {
            logger.warn((Object)("Can't find back face info in prepared list " + card.getName() + " (" + card.getSet() + ") #" + card.getCollectorId()));
            return new CardImageUrls(null, null);
        }
        if (baseUrl == null) {
            String cn = ScryfallApiCard.transformCardNumberFromXmageToScryfall(card.getCollectorId());
            baseUrl = String.format("https://api.scryfall.com/cards/%s/%s/%s?format=image", this.formatSetName(card.getSet(), isToken), cn, localizedCode);
            alternativeUrl = String.format("https://api.scryfall.com/cards/%s/%s?format=image&include_variations=true", this.formatSetName(card.getSet(), isToken), cn);
        }
        return new CardImageUrls(baseUrl, alternativeUrl);
    }

    private String getFaceImageUrl(CardDownloadData card, boolean isToken) throws Exception {
        String defaultCode = CardLanguage.ENGLISH.getCode();
        String localizedCode = this.languageAliases.getOrDefault((Object)this.getCurrentLanguage(), defaultCode);
        ArrayList<String> needUrls = new ArrayList<String>();
        int needFaceIndex = card.isSecondSide() ? 1 : 0;
        String apiUrl = ScryfallImageSupportCards.findDirectDownloadLink(card.getSet(), card.getName(), card.getCollectorId());
        if (apiUrl != null) {
            if (localizedCode.equals(defaultCode)) {
                needUrls.add(apiUrl);
            } else {
                needUrls.add(apiUrl + localizedCode);
                needUrls.add(apiUrl + defaultCode);
            }
        } else {
            String cn = ScryfallApiCard.transformCardNumberFromXmageToScryfall(card.getCollectorId());
            needUrls.add(String.format("https://api.scryfall.com/cards/%s/%s/%s", this.formatSetName(card.getSet(), isToken), cn, localizedCode));
            if (!localizedCode.equals(defaultCode)) {
                needUrls.add(String.format("https://api.scryfall.com/cards/%s/%s", this.formatSetName(card.getSet(), isToken), cn));
            }
        }
        InputStream jsonStream = null;
        String jsonUrl = null;
        for (String currentUrl : needUrls) {
            this.waitBeforeRequest();
            jsonStream = XmageURLConnection.downloadBinary(currentUrl);
            if (jsonStream == null) continue;
            jsonUrl = currentUrl;
            break;
        }
        if (jsonStream == null) {
            throw new MageException("Couldn't find card's JSON data on the server");
        }
        JsonObject jsonCard = JsonParser.parseReader(new InputStreamReader(jsonStream)).getAsJsonObject();
        JsonArray jsonFaces = JsonUtil.getAsArray(jsonCard, "card_faces");
        if (jsonFaces == null) {
            throw new MageException("Couldn't find card_faces in card's JSON data: " + jsonUrl);
        }
        if (jsonFaces.size() < needFaceIndex + 1) {
            throw new MageException("card_faces doesn't contains face index in card's JSON data: " + jsonUrl);
        }
        JsonObject jsonFace = jsonFaces.get(needFaceIndex).getAsJsonObject();
        JsonObject jsonImages = JsonUtil.getAsObject(jsonFace, "image_uris");
        if (jsonImages == null) {
            throw new MageException("Couldn't find image_uris in card's JSON data: " + jsonUrl);
        }
        return JsonUtil.getAsString(jsonImages, "large");
    }

    @Override
    public boolean prepareDownloadList(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        this.preparedUrls.clear();
        if (!this.prepareBulkData(downloadServiceInfo, downloadList)) {
            return false;
        }
        this.analyseBulkData(downloadServiceInfo, downloadList);
        return this.prepareSecondSideImages(downloadServiceInfo, downloadList);
    }

    private boolean prepareSecondSideImages(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        int needPrepareCount = 0;
        int currentPrepareCount = 0;
        for (CardDownloadData card : downloadList) {
            if (!card.isSecondSide()) continue;
            ++needPrepareCount;
        }
        this.updatePrepareStats(downloadServiceInfo, needPrepareCount, currentPrepareCount);
        for (CardDownloadData card : downloadList) {
            if (downloadServiceInfo.isNeedCancel()) {
                return false;
            }
            if (this.preparedUrls.containsKey(card) || !card.isSecondSide()) continue;
            ++currentPrepareCount;
            try {
                String url = this.getFaceImageUrl(card, card.isToken());
                this.preparedUrls.put(card, url);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to prepare image URL (back face) for " + card.getName() + " (" + card.getSet() + ") #" + card.getCollectorId() + ", Error Message: " + e.getMessage()));
                downloadServiceInfo.incErrorCount();
            }
            this.updatePrepareStats(downloadServiceInfo, needPrepareCount, currentPrepareCount);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean prepareBulkData(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        String s;
        boolean isEnabled = true;
        if (System.getProperty(SCRYFALL_BULK_FILES_PROPERTY) != null) {
            isEnabled = Boolean.parseBoolean(System.getProperty(SCRYFALL_BULK_FILES_PROPERTY));
        }
        if (!isEnabled) {
            return true;
        }
        if (this.isBulkDataPrepared(downloadServiceInfo)) {
            return true;
        }
        if (downloadServiceInfo.isNeedCancel()) {
            return false;
        }
        TFile bulkTempFile = this.prepareTempFileForBulkData();
        if (bulkTempFile.exists()) {
            try {
                bulkTempFile.rm();
                TVFS.umount();
            }
            catch (IOException e) {
                return false;
            }
        }
        if ((s = XmageURLConnection.downloadText(SCRYFALL_BULK_FILES_DATABASE_SOURCE_API)).isEmpty()) {
            logger.error((Object)"Can't get bulk info from scryfall api https://api.scryfall.com/bulk-data/all-cards");
            return false;
        }
        ScryfallApiBulkData bulkData = new Gson().fromJson(s, ScryfallApiBulkData.class);
        if (bulkData == null || bulkData.download_uri == null || bulkData.download_uri.isEmpty() || bulkData.size == 0L) {
            logger.error((Object)"Unknown bulk info format from scryfall api https://api.scryfall.com/bulk-data/all-cards");
            return false;
        }
        logger.info((Object)("Scryfall: downloading additional data files, size " + bulkData.size / 0x100000L + " MB"));
        String url = bulkData.download_uri;
        InputStream inputStream = XmageURLConnection.downloadBinary(url, true);
        TFileOutputStream outputStream = null;
        try {
            try {
                int len;
                if (inputStream == null) {
                    logger.error((Object)("Can't get bulk data from scryfall api " + url));
                    boolean bl = false;
                    return bl;
                }
                outputStream = new TFileOutputStream((File)bulkTempFile);
                byte[] buf = new byte[0x500000];
                long needDownload = bulkData.size / 7L;
                long doneDownload = 0L;
                while ((len = inputStream.read(buf)) != -1) {
                    if (downloadServiceInfo.isNeedCancel()) {
                        inputStream.close();
                        outputStream.close();
                        if (bulkTempFile.exists()) {
                            bulkTempFile.rm();
                        }
                        boolean bl = false;
                        return bl;
                    }
                    outputStream.write(buf, 0, len);
                    this.updateBulkDownloadStats(downloadServiceInfo, doneDownload += (long)len, needDownload);
                }
                outputStream.flush();
                logger.info((Object)"Scryfall: unpacking files...");
                Path zippedBulkPath = Paths.get(this.getBulkTempFileName(), new String[0]);
                Path textBulkPath = Paths.get(this.getBulkStaticFileName(), new String[0]);
                Files.deleteIfExists(textBulkPath);
                try (GZIPInputStream in = new GZIPInputStream(Files.newInputStream(zippedBulkPath, new OpenOption[0]));
                     FileOutputStream out = new FileOutputStream(textBulkPath.toString());){
                    byte[] buffer = new byte[0x500000];
                    long needUnpack = bulkData.size;
                    long doneUnpack = 0L;
                    while ((len = in.read(buffer)) > 0) {
                        if (downloadServiceInfo.isNeedCancel()) {
                            out.flush();
                            Files.deleteIfExists(textBulkPath);
                            boolean bl = false;
                            return bl;
                        }
                        out.write(buffer, 0, len);
                        this.updateBulkUnpackingStats(downloadServiceInfo, doneUnpack += (long)len, needUnpack);
                    }
                }
                logger.info((Object)"Scryfall: unpacking done");
                return this.isBulkDataPrepared(downloadServiceInfo);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Catch unknown error while download bulk data from scryfall api " + url), (Throwable)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isBulkDataPrepared(DownloadServiceInfo downloadServiceInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 43[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void analyseBulkData(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        Map<String, String> bulkImagesIndexAll = this.createBulkImagesIndex(downloadServiceInfo, bulkCardsDatabaseAll, true);
        Map<String, String> bulkImagesIndexDefault = this.createBulkImagesIndex(downloadServiceInfo, bulkCardsDatabaseDefault.values(), false);
        AtomicInteger statsOldPrepared = new AtomicInteger();
        AtomicInteger statsDirectLinks = new AtomicInteger();
        AtomicInteger statsNewPrepared = new AtomicInteger();
        AtomicInteger statsNotFound = new AtomicInteger();
        for (CardDownloadData card : downloadList) {
            if (downloadServiceInfo.isNeedCancel()) {
                return;
            }
            if (this.preparedUrls.containsKey(card)) {
                statsOldPrepared.incrementAndGet();
                continue;
            }
            if (card.isToken()) continue;
            String directLink = ScryfallImageSupportCards.findDirectDownloadLink(card.getSet(), card.getName(), card.getCollectorId());
            if (directLink != null) {
                statsDirectLinks.incrementAndGet();
                continue;
            }
            String searchingName = card.getName();
            String searchingSet = card.getSet().toLowerCase(Locale.ENGLISH);
            String searchingNumber = card.getCollectorId();
            String key = String.format("%s/%s/%s/%s", new Object[]{searchingName, searchingSet, searchingNumber, this.currentLanguage});
            String link = bulkImagesIndexAll.getOrDefault(key, "");
            if (link.isEmpty()) {
                key = String.format("%s/%s/%s/%s", searchingName, searchingSet, searchingNumber, CardLanguage.ENGLISH.getCode());
                link = bulkImagesIndexAll.getOrDefault(key, "");
            }
            if (link.isEmpty()) {
                key = String.format("%s/%s/%s/", searchingName, searchingSet, searchingNumber);
                link = bulkImagesIndexDefault.getOrDefault(key, "");
            }
            if (link.isEmpty()) {
                logger.info((Object)("Scryfall: bulk image not found (outdated cards data in xmage?): " + key + " "));
                statsNotFound.incrementAndGet();
                continue;
            }
            this.preparedUrls.put(card, link);
            statsNewPrepared.incrementAndGet();
        }
        logger.info((Object)String.format("Scryfall: bulk optimization result - need cards: %d, already prepared: %d, direct links: %d, new prepared: %d, NOT FOUND: %d", downloadList.size(), statsOldPrepared.get(), statsDirectLinks.get(), statsNewPrepared.get(), statsNotFound.get()));
    }

    private Map<String, String> createBulkImagesIndex(DownloadServiceInfo downloadServiceInfo, Collection<ScryfallApiCard> sourceList, boolean useLocalization) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (ScryfallApiCard card : sourceList) {
            if (downloadServiceInfo.isNeedCancel()) {
                return res;
            }
            String image = card.findImage(this.getImageQuality());
            if (!image.isEmpty()) {
                String mainKey = String.format("%s/%s/%s/%s", card.name, card.set, card.collector_number, useLocalization ? card.lang : "");
                if (res.containsKey(mainKey)) {
                    throw new IllegalArgumentException("Wrong code usage: scryfall used unique card numbers, but found duplicated: " + mainKey);
                }
                res.put(mainKey, image);
            }
            if (card.card_faces == null) continue;
            HashSet usedNames = new HashSet();
            card.card_faces.forEach(face -> {
                if (usedNames.contains(face.name)) {
                    return;
                }
                usedNames.add(face.name);
                String faceImage = face.findImage(this.getImageQuality());
                if (!faceImage.isEmpty()) {
                    String faceKey = String.format("%s/%s/%s/%s", face.name, card.set, card.collector_number, useLocalization ? card.lang : "");
                    if (card.layout.equals("flip") && card.name.equals(face.name) && res.containsKey(faceKey)) {
                        return;
                    }
                    if (res.containsKey(faceKey)) {
                        throw new IllegalArgumentException("Wrong code usage: scryfall used unique card numbers, but found duplicated: " + faceKey);
                    }
                    res.put(faceKey, faceImage);
                }
            });
        }
        return res;
    }

    private String getBulkTempFileName() {
        return CardImageUtils.getImagesDir() + File.separator + "downloading" + File.separator + "scryfall_bulk_cards.json.gz";
    }

    private String getBulkStaticFileName() {
        return CardImageUtils.getImagesDir() + File.separator + "downloading" + File.separator + "scryfall_bulk_cards.json";
    }

    private TFile prepareTempFileForBulkData() {
        TFile file = new TFile(this.getBulkTempFileName());
        TFile parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBulkDownloadStats(DownloadServiceInfo service, long done, long need) {
        int doneMb = (int)(done / 0x100000L);
        int needMb = (int)(need / 0x100000L);
        Object object = service.getSync();
        synchronized (object) {
            service.updateProgressMessage(String.format("Step 1 of 3. Downloading additional data... %d of %d MB", doneMb, needMb), doneMb, needMb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBulkUnpackingStats(DownloadServiceInfo service, long done, long need) {
        int doneMb = (int)(done / 0x100000L);
        int needMb = (int)(need / 0x100000L);
        Object object = service.getSync();
        synchronized (object) {
            service.updateProgressMessage(String.format("Step 2 of 3. Unpacking additional files... %d of %d MB", doneMb, needMb), doneMb, needMb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrepareStats(DownloadServiceInfo service, int need, int current) {
        Object object = service.getSync();
        synchronized (object) {
            service.updateProgressMessage(String.format("Step 3 of 3. Preparing download list... %d of %d", current, need), current, need);
        }
    }

    @Override
    public CardImageUrls generateCardUrl(CardDownloadData card) throws Exception {
        return this.innerGenerateURL(card, false);
    }

    @Override
    public CardImageUrls generateTokenUrl(CardDownloadData card) throws Exception {
        return this.innerGenerateURL(card, true);
    }

    @Override
    public String getNextHttpImageUrl() {
        return null;
    }

    @Override
    public String getFileForHttpImage(String httpImageUrl) {
        return null;
    }

    @Override
    public String getSourceName() {
        return "scryfall.com - big";
    }

    @Override
    public float getAverageSizeKb() {
        return 140.0f;
    }

    @Override
    public int getTotalImages() {
        return -1;
    }

    @Override
    public boolean isTokenSource() {
        return true;
    }

    @Override
    public boolean isCardSource() {
        return true;
    }

    @Override
    public boolean isLanguagesSupport() {
        return true;
    }

    @Override
    public void setCurrentLanguage(CardLanguage cardLanguage) {
        this.currentLanguage = cardLanguage;
    }

    @Override
    public CardLanguage getCurrentLanguage() {
        return this.currentLanguage;
    }

    @Override
    public void doPause(String fullUrl) {
        if (fullUrl.contains("scryfall.io")) {
            return;
        }
        this.waitBeforeRequest();
    }

    private void waitBeforeRequest() {
        try {
            waitBeforeRequestLock.lock();
            try {
                Thread.sleep(300L);
            }
            finally {
                waitBeforeRequestLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String formatSetName(String setName, boolean isToken) {
        if (isToken) {
            return setName.toLowerCase(Locale.ENGLISH);
        }
        return ScryfallImageSupportCards.findScryfallSetCode(setName);
    }

    @Override
    public List<String> getSupportedSets() {
        ArrayList<String> supportedSetsCopy = new ArrayList<String>(ScryfallImageSupportCards.getSupportedSets());
        for (String code : ScryfallImageSupportTokens.getSupportedSets().keySet()) {
            if (supportedSetsCopy.contains(code)) continue;
            supportedSetsCopy.add(code);
        }
        return supportedSetsCopy;
    }

    @Override
    public boolean isCardImageProvided(String setCode, String cardName) {
        return ScryfallImageSupportCards.getSupportedSets().contains(setCode);
    }

    @Override
    public boolean isTokenImageProvided(String setCode, String cardName, Integer tokenNumber) {
        return ScryfallImageSupportTokens.findTokenLink(setCode, cardName, tokenNumber) != null;
    }

    public String getImageQuality() {
        return "large";
    }

    @Override
    public void onFinished() {
        bulkCardsDatabaseAll.clear();
        bulkCardsDatabaseDefault.clear();
    }
}

