/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tritonus.share.ArraySet;

public class ScryfallImageSupportCards {
    static final Pattern REGEXP_DIRECT_KEY_SET_CODE_PATTERN = Pattern.compile("(\\w+)\\/", 8);
    static final Pattern REGEXP_DIRECT_KEY_CARD_NAME_PATTERN = Pattern.compile("\\/(.+?)\\/", 8);
    private static final Set<String> supportedSets = new ArraySet<String>(){
        {
            this.add("LEA");
            this.add("LEB");
            this.add("2ED");
            this.add("RIN");
            this.add("REN");
            this.add("ARN");
            this.add("ATQ");
            this.add("3ED");
            this.add("LEG");
            this.add("SUM");
            this.add("PDRC");
            this.add("DRK");
            this.add("FEM");
            this.add("PLGM");
            this.add("PHPR");
            this.add("4ED");
            this.add("ICE");
            this.add("CHR");
            this.add("HML");
            this.add("PTC");
            this.add("ALL");
            this.add("RQS");
            this.add("PARL");
            this.add("MIR");
            this.add("MGB");
            this.add("ITP");
            this.add("VIS");
            this.add("5ED");
            this.add("POR");
            this.add("WTH");
            this.add("WC97");
            this.add("TMP");
            this.add("JGP");
            this.add("STH");
            this.add("P02");
            this.add("EXO");
            this.add("UGL");
            this.add("WC98");
            this.add("PALP");
            this.add("USG");
            this.add("ATH");
            this.add("PAL99");
            this.add("G99");
            this.add("ULG");
            this.add("6ED");
            this.add("PTK");
            this.add("UDS");
            this.add("S99");
            this.add("PGRU");
            this.add("WC99");
            this.add("PWOS");
            this.add("MMQ");
            this.add("BRB");
            this.add("PAL00");
            this.add("G00");
            this.add("FNM");
            this.add("PELP");
            this.add("NEM");
            this.add("S00");
            this.add("PCY");
            this.add("WC00");
            this.add("BTD");
            this.add("INV");
            this.add("PAL01");
            this.add("MPR");
            this.add("G01");
            this.add("F01");
            this.add("PLS");
            this.add("7ED");
            this.add("APC");
            this.add("PSDG");
            this.add("WC01");
            this.add("ODY");
            this.add("DKM");
            this.add("PAL02");
            this.add("G02");
            this.add("F02");
            this.add("TOR");
            this.add("JUD");
            this.add("WC02");
            this.add("ONS");
            this.add("PAL03");
            this.add("P03");
            this.add("G03");
            this.add("F03");
            this.add("LGN");
            this.add("SCG");
            this.add("8ED");
            this.add("WC03");
            this.add("MRD");
            this.add("PAL04");
            this.add("P04");
            this.add("G04");
            this.add("F04");
            this.add("DST");
            this.add("5DN");
            this.add("WC04");
            this.add("CHK");
            this.add("UNH");
            this.add("PAL05");
            this.add("P05");
            this.add("G05");
            this.add("F05");
            this.add("BOK");
            this.add("SOK");
            this.add("9ED");
            this.add("RAV");
            this.add("P2HG");
            this.add("PAL06");
            this.add("PHUK");
            this.add("DCI");
            this.add("P06");
            this.add("G06");
            this.add("F06");
            this.add("GPT");
            this.add("DIS");
            this.add("CST");
            this.add("CSP");
            this.add("TSP");
            this.add("TSB");
            this.add("P07");
            this.add("HHO");
            this.add("G07");
            this.add("F07");
            this.add("PLC");
            this.add("FUT");
            this.add("10E");
            this.add("P10E");
            this.add("ME1");
            this.add("LRW");
            this.add("DD1");
            this.add("PSUS");
            this.add("PJSE");
            this.add("PJAS");
            this.add("P08");
            this.add("G08");
            this.add("F08");
            this.add("MOR");
            this.add("PCMP");
            this.add("P15A");
            this.add("SHM");
            this.add("EVE");
            this.add("DRB");
            this.add("ME2");
            this.add("ALA");
            this.add("PALA");
            this.add("DD2");
            this.add("PDTP");
            this.add("P09");
            this.add("G09");
            this.add("F09");
            this.add("CON");
            this.add("DDC");
            this.add("ARB");
            this.add("PM10");
            this.add("M10");
            this.add("V09");
            this.add("HOP");
            this.add("ME3");
            this.add("PZEN");
            this.add("ZEN");
            this.add("DDD");
            this.add("H09");
            this.add("PDP10");
            this.add("P10");
            this.add("G10");
            this.add("F10");
            this.add("WWK");
            this.add("DDE");
            this.add("ROE");
            this.add("DPA");
            this.add("ARC");
            this.add("PM11");
            this.add("M11");
            this.add("PWWK");
            this.add("PROE");
            this.add("V10");
            this.add("DDF");
            this.add("PSOM");
            this.add("SOM");
            this.add("TD0");
            this.add("PD2");
            this.add("PW11");
            this.add("P11");
            this.add("G11");
            this.add("F11");
            this.add("ME4");
            this.add("PMBS");
            this.add("MBS");
            this.add("DDG");
            this.add("PNPH");
            this.add("NPH");
            this.add("TD2");
            this.add("PCMD");
            this.add("CMD");
            this.add("PM12");
            this.add("M12");
            this.add("V11");
            this.add("DDH");
            this.add("PISD");
            this.add("ISD");
            this.add("PD3");
            this.add("PIDW");
            this.add("PW12");
            this.add("PDP12");
            this.add("J12");
            this.add("F12");
            this.add("PDKA");
            this.add("DKA");
            this.add("DDI");
            this.add("PHEL");
            this.add("PAVR");
            this.add("AVR");
            this.add("PC2");
            this.add("PM13");
            this.add("M13");
            this.add("V12");
            this.add("DDJ");
            this.add("RTR");
            this.add("PRTR");
            this.add("CM1");
            this.add("PDP13");
            this.add("J13");
            this.add("F13");
            this.add("PGTC");
            this.add("GTC");
            this.add("DDK");
            this.add("PDGM");
            this.add("DGM");
            this.add("MMA");
            this.add("PM14");
            this.add("PSDC");
            this.add("M14");
            this.add("V13");
            this.add("DDL");
            this.add("PTHS");
            this.add("THS");
            this.add("C13");
            this.add("PDP14");
            this.add("J14");
            this.add("F14");
            this.add("PBNG");
            this.add("BNG");
            this.add("DDM");
            this.add("PJOU");
            this.add("JOU");
            this.add("MD1");
            this.add("CNS");
            this.add("VMA");
            this.add("PS14");
            this.add("PM15");
            this.add("M15");
            this.add("CP1");
            this.add("V14");
            this.add("DDN");
            this.add("KTK");
            this.add("PKTK");
            this.add("C14");
            this.add("JVC");
            this.add("GVL");
            this.add("EVG");
            this.add("DVD");
            this.add("PDP15");
            this.add("J15");
            this.add("F15");
            this.add("UGIN");
            this.add("PURL");
            this.add("CP2");
            this.add("FRF");
            this.add("PFRF");
            this.add("DDO");
            this.add("DTK");
            this.add("PDTK");
            this.add("PTKDF");
            this.add("TPR");
            this.add("MM2");
            this.add("PS15");
            this.add("CP3");
            this.add("PORI");
            this.add("ORI");
            this.add("V15");
            this.add("DDP");
            this.add("BFZ");
            this.add("PSS1");
            this.add("EXP");
            this.add("PBFZ");
            this.add("C15");
            this.add("PZ1");
            this.add("J16");
            this.add("F16");
            this.add("OGW");
            this.add("POGW");
            this.add("DDQ");
            this.add("SOI");
            this.add("W16");
            this.add("PSOI");
            this.add("EMA");
            this.add("PEMN");
            this.add("EMN");
            this.add("V16");
            this.add("CN2");
            this.add("DDR");
            this.add("PKLD");
            this.add("KLD");
            this.add("MPS");
            this.add("PS16");
            this.add("C16");
            this.add("PCA");
            this.add("J17");
            this.add("F17");
            this.add("AER");
            this.add("PAER");
            this.add("MM3");
            this.add("DDS");
            this.add("W17");
            this.add("PAKH");
            this.add("AKH");
            this.add("MP2");
            this.add("CMA");
            this.add("E01");
            this.add("PHOU");
            this.add("HOU");
            this.add("PS17");
            this.add("C17");
            this.add("WMC");
            this.add("H17");
            this.add("PHTR");
            this.add("PXLN");
            this.add("XLN");
            this.add("PSS2");
            this.add("G17");
            this.add("DDT");
            this.add("PUST");
            this.add("IMA");
            this.add("V17");
            this.add("PXTC");
            this.add("E02");
            this.add("UST");
            this.add("J18");
            this.add("PRIX");
            this.add("RIX");
            this.add("PNAT");
            this.add("A25");
            this.add("DDU");
            this.add("PDOM");
            this.add("DOM");
            this.add("CM2");
            this.add("BBD");
            this.add("PBBD");
            this.add("PGPX");
            this.add("SS1");
            this.add("GS1");
            this.add("PM19");
            this.add("PSS3");
            this.add("M19");
            this.add("ANA");
            this.add("XANA");
            this.add("OANA");
            this.add("PS18");
            this.add("PH17");
            this.add("C18");
            this.add("PGRN");
            this.add("PRWK");
            this.add("GRN");
            this.add("GK1");
            this.add("GNT");
            this.add("G18");
            this.add("PZ2");
            this.add("PUMA");
            this.add("UMA");
            this.add("PF19");
            this.add("PRNA");
            this.add("RNA");
            this.add("GK2");
            this.add("PRW2");
            this.add("J19");
            this.add("PRM");
            this.add("MED");
            this.add("WAR");
            this.add("PWAR");
            this.add("PMH1");
            this.add("MH1");
            this.add("SS2");
            this.add("PRES");
            this.add("PPP1");
            this.add("PM20");
            this.add("M20");
            this.add("PS19");
            this.add("C19");
            this.add("PELD");
            this.add("ELD");
            this.add("CMB1");
            this.add("MB1");
            this.add("GN2");
            this.add("HA1");
            this.add("OVNT");
            this.add("OLGC");
            this.add("PPRO");
            this.add("PF20");
            this.add("J20");
            this.add("PTHB");
            this.add("THB");
            this.add("PWOR");
            this.add("PANA");
            this.add("UND");
            this.add("HA2");
            this.add("SLD");
            this.add("PMEI");
            this.add("SLU");
            this.add("SS3");
            this.add("HA3");
            this.add("PLG20");
            this.add("IKO");
            this.add("C20");
            this.add("M21");
            this.add("JMP");
            this.add("PH19");
            this.add("2XM");
            this.add("AKR");
            this.add("ANB");
            this.add("ZNR");
            this.add("ZNC");
            this.add("ZNE");
            this.add("KLR");
            this.add("CMR");
            this.add("CC1");
            this.add("PJ21");
            this.add("PL21");
            this.add("KHM");
            this.add("KHC");
            this.add("TSR");
            this.add("STX");
            this.add("STA");
            this.add("HA4");
            this.add("HA5");
            this.add("C21");
            this.add("MH2");
            this.add("H1R");
            this.add("PW21");
            this.add("PLG21");
            this.add("AFR");
            this.add("AFC");
            this.add("J21");
            this.add("MID");
            this.add("MIC");
            this.add("VOW");
            this.add("VOC");
            this.add("YMID");
            this.add("P22");
            this.add("DBL");
            this.add("CC2");
            this.add("NEO");
            this.add("YNEO");
            this.add("NEC");
            this.add("PL22");
            this.add("PW22");
            this.add("GDY");
            this.add("SNC");
            this.add("NCC");
            this.add("SLX");
            this.add("CLB");
            this.add("PLG22");
            this.add("2X2");
            this.add("SCH");
            this.add("DMU");
            this.add("DMC");
            this.add("YDMU");
            this.add("PRCQ");
            this.add("40K");
            this.add("UNF");
            this.add("GN3");
            this.add("BRO");
            this.add("BRC");
            this.add("BRR");
            this.add("BOT");
            this.add("J22");
            this.add("SCD");
            this.add("PW23");
            this.add("P23");
            this.add("SLC");
            this.add("DMR");
            this.add("ONE");
            this.add("ONC");
            this.add("PL23");
            this.add("UNK");
            this.add("SIS");
            this.add("SIR");
            this.add("SLP");
            this.add("MOM");
            this.add("MOC");
            this.add("MAT");
            this.add("MUL");
            this.add("30A");
            this.add("P30A");
            this.add("P30M");
            this.add("P30H");
            this.add("PEWK");
            this.add("LTR");
            this.add("LTC");
            this.add("PF23");
            this.add("CMM");
            this.add("WHO");
            this.add("WOE");
            this.add("WOT");
            this.add("WOC");
            this.add("LCI");
            this.add("LCC");
            this.add("REX");
            this.add("SPG");
            this.add("PW24");
            this.add("PF24");
            this.add("RVR");
            this.add("PL24");
            this.add("PIP");
            this.add("MKM");
            this.add("MKC");
            this.add("PSS4");
            this.add("CLU");
            this.add("OTJ");
            this.add("OTC");
            this.add("OTP");
            this.add("BIG");
            this.add("MH3");
            this.add("M3C");
            this.add("H2R");
            this.add("ACR");
            this.add("BLB");
            this.add("BLC");
            this.add("PLG24");
            this.add("PCBB");
            this.add("MB2");
            this.add("DSK");
            this.add("DSC");
            this.add("FDN");
            this.add("J25");
            this.add("PIO");
            this.add("PW25");
            this.add("PSPL");
            this.add("INR");
            this.add("PF25");
            this.add("PL25");
            this.add("DFT");
            this.add("DRC");
            this.add("PLG25");
            this.add("TDM");
            this.add("TDC");
            this.add("FIN");
            this.add("FIC");
            this.add("FCA");
            this.add("PSS5");
            this.add("EOE");
            this.add("EOC");
            this.add("EOS");
            this.add("SPM");
            this.add("SPE");
            this.add("MAR");
            this.add("TLA");
            this.add("TLE");
            this.add("ECL");
            this.add("CALC");
        }
    };
    private static final Map<String, String> directDownloadLinks = new HashMap<String, String>(){
        {
            this.put("SOI/Tamiyo's Journal/265+a", "https://api.scryfall.com/cards/soi/265\u2020a/");
            this.put("SOI/Tamiyo's Journal/265+b", "https://api.scryfall.com/cards/soi/265\u2020b/");
            this.put("SOI/Tamiyo's Journal/265+c", "https://api.scryfall.com/cards/soi/265\u2020c/");
            this.put("SOI/Tamiyo's Journal/265+d", "https://api.scryfall.com/cards/soi/265\u2020d/");
            this.put("SOI/Tamiyo's Journal/265+e", "https://api.scryfall.com/cards/soi/265\u2020e/");
            this.put("SLD/Adrix and Nev, Twincasters/1544b", "https://api.scryfall.com/cards/sld/1544/en?format=image&face=back");
            this.put("SLD/Aesi, Tyrant of Gyre Strait/1873b", "https://api.scryfall.com/cards/sld/1873/en?format=image&face=back");
            this.put("SLD/Ajani Goldmane/745b", "https://api.scryfall.com/cards/sld/745/en?format=image&face=back");
            this.put("SLD/Ajani Goldmane/1453b", "https://api.scryfall.com/cards/sld/1453/en?format=image&face=back");
            this.put("SLD/Anje Falkenrath/1874b", "https://api.scryfall.com/cards/sld/1874/en?format=image&face=back");
            this.put("SLD/Anointed Procession/1511b", "https://api.scryfall.com/cards/sld/1511/en?format=image&face=back");
            this.put("SLD/Birds of Paradise/1675b", "https://api.scryfall.com/cards/sld/1675/en?format=image&face=back");
            this.put("SLD/Blightsteel Colossus/1079b", "https://api.scryfall.com/cards/sld/1079/en?format=image&face=back");
            this.put("SLD/Chandra Nalaar/748b", "https://api.scryfall.com/cards/sld/748/en?format=image&face=back");
            this.put("SLD/Chandra Nalaar/1456b", "https://api.scryfall.com/cards/sld/1456/en?format=image&face=back");
            this.put("SLD/Chulane, Teller of Tales/1875b", "https://api.scryfall.com/cards/sld/1875/en?format=image&face=back");
            this.put("SLD/Darksteel Colossus/1081b", "https://api.scryfall.com/cards/sld/1081/en?format=image&face=back");
            this.put("SLD/Death Baron/1458b", "https://api.scryfall.com/cards/sld/1458/en?format=image&face=back");
            this.put("SLD/Doubling Cube/1080b", "https://api.scryfall.com/cards/sld/1080/en?format=image&face=back");
            this.put("SLD/Dragonlord Atarka/1970b", "https://api.scryfall.com/cards/sld/1970/en?format=image&face=back");
            this.put("SLD/Dragonlord Dromoka/1971b", "https://api.scryfall.com/cards/sld/1971/en?format=image&face=back");
            this.put("SLD/Dragonlord Kolaghan/1972b", "https://api.scryfall.com/cards/sld/1972/en?format=image&face=back");
            this.put("SLD/Dragonlord Ojutai/1973b", "https://api.scryfall.com/cards/sld/1973/en?format=image&face=back");
            this.put("SLD/Dragonlord Silumgar/1974b", "https://api.scryfall.com/cards/sld/1974/en?format=image&face=back");
            this.put("SLD/Estrid's Invocation/1325b", "https://api.scryfall.com/cards/sld/1325/en?format=image&face=back");
            this.put("SLD/Estrid, the Masked/1327b", "https://api.scryfall.com/cards/sld/1327/en?format=image&face=back");
            this.put("SLD/Etali, Primal Storm/1123b", "https://api.scryfall.com/cards/sld/1123/en?format=image&face=back");
            this.put("SLD/Garruk Wildspeaker/749b", "https://api.scryfall.com/cards/sld/749/en?format=image&face=back");
            this.put("SLD/Garruk Wildspeaker/1457b", "https://api.scryfall.com/cards/sld/1457/en?format=image&face=back");
            this.put("SLD/Ghalta, Primal Hunger/1124b", "https://api.scryfall.com/cards/sld/1124/en?format=image&face=back");
            this.put("SLD/Grimgrin, Corpse-Born/1461b", "https://api.scryfall.com/cards/sld/1461/en?format=image&face=back");
            this.put("SLD/Jace Beleren/746b", "https://api.scryfall.com/cards/sld/746/en?format=image&face=back");
            this.put("SLD/Jace Beleren/1454b", "https://api.scryfall.com/cards/sld/1454/en?format=image&face=back");
            this.put("SLD/Jetmir, Nexus of Revels/1509b", "https://api.scryfall.com/cards/sld/1509/en?format=image&face=back");
            this.put("SLD/Jetmir, Nexus of Revels/1555b", "https://api.scryfall.com/cards/sld/1555/en?format=image&face=back");
            this.put("SLD/Jinnie Fay, Jetmir's Second/1510b", "https://api.scryfall.com/cards/sld/1510/en?format=image&face=back");
            this.put("SLD/Jinnie Fay, Jetmir's Second/1556b", "https://api.scryfall.com/cards/sld/1556/en?format=image&face=back");
            this.put("SLD/Kardur, Doomscourge/1807b", "https://api.scryfall.com/cards/sld/1807/en?format=image&face=back");
            this.put("SLD/Krark's Thumb/383b", "https://api.scryfall.com/cards/sld/383/en?format=image&face=back");
            this.put("SLD/Krark, the Thumbless/1543b", "https://api.scryfall.com/cards/sld/1543/en?format=image&face=back");
            this.put("SLD/Liliana Vess/747b", "https://api.scryfall.com/cards/sld/747/en?format=image&face=back");
            this.put("SLD/Liliana Vess/1455b", "https://api.scryfall.com/cards/sld/1455/en?format=image&face=back");
            this.put("SLD/Mechtitan Core/1969b", "https://api.scryfall.com/cards/sld/1969/en?format=image&face=back");
            this.put("SLD/Mechtitan Core/1965b", "https://api.scryfall.com/cards/sld/1965/en?format=image&face=back");
            this.put("SLD/Norin the Wary/827b", "https://api.scryfall.com/cards/sld/827/en?format=image&face=back");
            this.put("SLD/Noxious Ghoul/1459b", "https://api.scryfall.com/cards/sld/1459/en?format=image&face=back");
            this.put("SLD/Okaun, Eye of Chaos/380b", "https://api.scryfall.com/cards/sld/380/en?format=image&face=back");
            this.put("SLD/Okaun, Eye of Chaos/380*b", "https://api.scryfall.com/cards/sld/380\u2605/en?format=image&face=back");
            this.put("SLD/Parhelion II/1964b", "https://api.scryfall.com/cards/sld/1964/en?format=image&face=back");
            this.put("SLD/Peacewalker Colossus/1966b", "https://api.scryfall.com/cards/sld/1966/en?format=image&face=back");
            this.put("SLD/Propaganda/381b", "https://api.scryfall.com/cards/sld/381/en?format=image&face=back");
            this.put("SLD/Radha, Heart of Keld/1876b", "https://api.scryfall.com/cards/sld/1876/en?format=image&face=back");
            this.put("SLD/Reckoner Bankbuster/1967b", "https://api.scryfall.com/cards/sld/1967/en?format=image&face=back");
            this.put("SLD/Rin and Seri, Inseparable/1508b", "https://api.scryfall.com/cards/sld/1508/en?format=image&face=back");
            this.put("SLD/Rin and Seri, Inseparable/1554b", "https://api.scryfall.com/cards/sld/1554/en?format=image&face=back");
            this.put("SLD/Sakashima of a Thousand Faces/1541b", "https://api.scryfall.com/cards/sld/1541/en?format=image&face=back");
            this.put("SLD/Smuggler's Copter/1968b", "https://api.scryfall.com/cards/sld/1968/en?format=image&face=back");
            this.put("SLD/Sol Ring/1512b", "https://api.scryfall.com/cards/sld/1512/en?format=image&face=back");
            this.put("SLD/Steely Resolve/1326b", "https://api.scryfall.com/cards/sld/1326/en?format=image&face=back");
            this.put("SLD/Stitch in Time/382b", "https://api.scryfall.com/cards/sld/382/en?format=image&face=back");
            this.put("SLD/Terror/750b", "https://api.scryfall.com/cards/sld/750/en?format=image&face=back");
            this.put("SLD/Tuvasa the Sunlit/1328b", "https://api.scryfall.com/cards/sld/1328/en?format=image&face=back");
            this.put("SLD/Ulamog, the Ceaseless Hunger/1122b", "https://api.scryfall.com/cards/sld/1122/en?format=image&face=back");
            this.put("SLD/Unholy Grotto/1462b", "https://api.scryfall.com/cards/sld/1462/en?format=image&face=back");
            this.put("SLD/Yargle, Glutton of Urborg/1542b", "https://api.scryfall.com/cards/sld/1542/en?format=image&face=back");
            this.put("SLD/Zndrsplt, Eye of Wisdom/379b", "https://api.scryfall.com/cards/sld/379/en?format=image&face=back");
            this.put("SLD/Zndrsplt, Eye of Wisdom/379*b", "https://api.scryfall.com/cards/sld/379\u2605/en?format=image&face=back");
            this.put("SLD/Zombie Master/1460b", "https://api.scryfall.com/cards/sld/1460/en?format=image&face=back");
            this.put("SLD/Counterspell/99999SCTLR", "https://api.scryfall.com/cards/sld/SCTLR/");
            this.put("SLD/Viscera Seer/99999VS", "https://api.scryfall.com/cards/sld/VS/");
            this.put("CALC/C-Pillar of the Paruns", "https://api.scryfall.com/cards/dis/176/");
            this.put("MB1/Goblin Trenches", "https://api.scryfall.com/cards/plst/EMA-203/");
            this.put("MB1/Prophetic Bolt", "https://api.scryfall.com/cards/plst/C15-231/");
            this.put("LTR/The One Ring/001", "https://api.scryfall.com/cards/ltr/0/qya?format=image");
            this.put("REX/Command Tower/26b", "https://api.scryfall.com/cards/rex/26/en?format=image&face=back");
            this.put("REX/Forest/25b", "https://api.scryfall.com/cards/rex/25/en?format=image&face=back");
            this.put("REX/Island/22b", "https://api.scryfall.com/cards/rex/22/en?format=image&face=back");
            this.put("REX/Mountain/24b", "https://api.scryfall.com/cards/rex/24/en?format=image&face=back");
            this.put("REX/Plains/21b", "https://api.scryfall.com/cards/rex/21/en?format=image&face=back");
            this.put("REX/Swamp/23b", "https://api.scryfall.com/cards/rex/23/en?format=image&face=back");
            this.put("TDM/Bloomvine Regent/381b", "https://api.scryfall.com/cards/tdm/381/en?format=image&face=back");
            this.put("TDM/Clarion Conqueror/377b", "https://api.scryfall.com/cards/tdm/377/en?format=image&face=back");
            this.put("TDM/Magmatic Hellkite/380b", "https://api.scryfall.com/cards/tdm/380/en?format=image&face=back");
            this.put("TDM/Marang River Regent/378b", "https://api.scryfall.com/cards/tdm/378/en?format=image&face=back");
            this.put("TDM/Scavenger Regent/379b", "https://api.scryfall.com/cards/tdm/379/en?format=image&face=back");
            this.put("TDM/Ugin, Eye of the Storms/382b", "https://api.scryfall.com/cards/tdm/382/en?format=image&face=back");
        }
    };

    public static String findScryfallSetCode(String xmageCode) {
        return xmageCode.toLowerCase(Locale.ENGLISH);
    }

    public static Set<String> getSupportedSets() {
        return supportedSets;
    }

    public static String findDirectDownloadKey(String setCode, String cardName, String cardNumber) {
        String linkCode1 = setCode + "/" + cardName + "/" + cardNumber;
        if (directDownloadLinks.containsKey(linkCode1)) {
            return linkCode1;
        }
        String linkCode2 = setCode + "/" + cardName;
        if (directDownloadLinks.containsKey(linkCode2)) {
            return linkCode2;
        }
        return null;
    }

    public static String findDirectDownloadLink(String setCode, String cardName, String cardNumber) {
        String key = ScryfallImageSupportCards.findDirectDownloadKey(setCode, cardName, cardNumber);
        return directDownloadLinks.get(key);
    }

    public static String extractSetCodeFromDirectKey(String key) {
        Matcher matcher = REGEXP_DIRECT_KEY_SET_CODE_PATTERN.matcher(key);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String extractCardNameFromDirectKey(String key) {
        Matcher matcher = REGEXP_DIRECT_KEY_CARD_NAME_PATTERN.matcher(key + "/");
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static boolean isApiLink(String link) {
        return !link.endsWith(".jpg") && !link.endsWith(".png") && !link.contains("format=image");
    }

    public static Map<String, String> getDirectDownloadLinks() {
        return directDownloadLinks;
    }
}

