/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.client.remote.XmageURLConnection;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.mage.card.arcane.ManaSymbols;
import org.mage.plugins.card.dl.DownloadJob;
import org.mage.plugins.card.utils.CardImageUtils;

public class ScryfallSymbolsSource
implements Iterable<DownloadJob> {
    static final String CSS_SOURCE_URL = "https://scryfall.com/docs/api/colors";
    static final String CSS_SOURCE_SELECTOR = "link[rel=stylesheet]";
    static final String STATE_PROP_NAME = "state";
    static final String DOWNLOAD_TEMP_FILE = CardImageUtils.getImagesDir() + File.separator + "temp" + File.separator + "scryfall-symbols-source.txt";
    static final String REGEXP_MANA_PATTERN = "card-symbol-(.{1,10})\\{background-image.+base64,(.+)(\"\\)\\})";
    protected static final Logger LOGGER = Logger.getLogger(ScryfallSymbolsSource.class);
    private static final int SYMBOLS_NUMBER_START = 0;
    private static final int SYMBOLS_NUMBER_END = 20;
    private static final String[] SYMBOLS_LIST = new String[]{"W", "U", "B", "R", "G", "W/U", "U/B", "B/R", "R/G", "G/W", "W/B", "U/R", "B/G", "R/W", "G/U", "W/U/P", "U/B/P", "B/R/P", "R/G/P", "G/W/P", "W/B/P", "U/R/P", "B/G/P", "R/W/P", "G/U/P", "2/W", "2/U", "2/B", "2/R", "2/G", "C/W", "C/U", "C/B", "C/R", "C/G", "WP", "UP", "BP", "RP", "GP", "X", "S", "T", "Q", "C", "E", "H", "P"};

    @Override
    public Iterator<DownloadJob> iterator() {
        ArrayList<DownloadJob> jobs = new ArrayList<DownloadJob>();
        jobs.add(this.generateDownloadJob());
        return jobs.iterator();
    }

    private void parseData(String sourcePath) {
        String sourceData = "";
        try {
            sourceData = new String(Files.readAllBytes(Paths.get(sourcePath, new String[0])));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Can't open file to parse svg data: " + sourcePath + ", reason: " + e));
            return;
        }
        ArrayList<String> allMageSymbols = new ArrayList<String>(Arrays.asList(SYMBOLS_LIST));
        Integer i = 0;
        while (i <= 20) {
            allMageSymbols.add(String.valueOf(0 + i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        HashMap<String, String> foundedData = new HashMap<String, String>();
        sourceData = sourceData.replaceAll(".card-symbol", "\n.card-symbol");
        Pattern regex = Pattern.compile(REGEXP_MANA_PATTERN);
        Matcher regexMatcher = regex.matcher(sourceData);
        while (regexMatcher.find()) {
            String symbolCode = regexMatcher.group(1).trim();
            String symbolData = regexMatcher.group(2).trim().replace(" ", "").replaceAll("\n", "");
            foundedData.put(symbolCode, symbolData);
        }
        File dir = ManaSymbols.getSymbolFileNameAsSVG("W").getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (String needCode : allMageSymbols) {
            String searchCode = needCode.replace("/", "");
            if (!foundedData.containsKey(searchCode)) {
                LOGGER.warn((Object)("Can't found symbol code from scryfall: " + searchCode));
                continue;
            }
            File destFile = ManaSymbols.getSymbolFileNameAsSVG(searchCode);
            if (destFile.exists() && destFile.length() > 0L) continue;
            try {
                FileOutputStream stream = new FileOutputStream(destFile);
                Throwable throwable = null;
                try {
                    String data64 = (String)foundedData.get(searchCode);
                    Base64.Decoder dec = Base64.getDecoder();
                    byte[] fileData = dec.decode(data64);
                    stream.write(fileData);
                    LOGGER.info((Object)("New svg symbol downloaded: " + needCode));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Can't decode svg icon and save to file: " + destFile.getPath() + ", reason: " + e.getMessage()));
            }
        }
    }

    private DownloadJob generateDownloadJob() {
        return new ScryfallSymbolsDownloadJob();
    }

    private class ScryfallSymbolsDownloadJob
    extends DownloadJob {
        private String cssUrl;

        @Override
        public void onPreparing() {
            this.cssUrl = "";
            String sourceData = XmageURLConnection.downloadText(ScryfallSymbolsSource.CSS_SOURCE_URL);
            Document doc = Jsoup.parse((String)sourceData);
            Elements cssList = doc.select(ScryfallSymbolsSource.CSS_SOURCE_SELECTOR);
            if (cssList.size() == 1) {
                this.cssUrl = cssList.first().attr("href");
            }
            if (this.cssUrl.isEmpty()) {
                throw new IllegalStateException("Can't find stylesheet url from scryfall colors page.");
            }
            this.setUrl(this.cssUrl);
        }

        public ScryfallSymbolsDownloadJob() {
            super("Scryfall symbols source", "", ScryfallSymbolsDownloadJob.toFile(DOWNLOAD_TEMP_FILE), true);
            this.cssUrl = "";
            String destFile = DOWNLOAD_TEMP_FILE;
            this.addPropertyChangeListener(ScryfallSymbolsSource.STATE_PROP_NAME, new ScryfallDownloadOnFinishedListener(destFile));
            File file = new File(destFile);
            if (file.exists()) {
                file.delete();
            }
        }

        private class ScryfallDownloadOnFinishedListener
        implements PropertyChangeListener {
            private String downloadedFile;

            public ScryfallDownloadOnFinishedListener(String downloadedFile) {
                this.downloadedFile = downloadedFile;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals(ScryfallSymbolsSource.STATE_PROP_NAME)) {
                    throw new IllegalArgumentException("Unknown download property " + evt.getPropertyName());
                }
                if (evt.getNewValue() != DownloadJob.State.FINISHED) {
                    return;
                }
                ScryfallSymbolsSource.this.parseData(this.downloadedFile);
            }
        }
    }
}

