/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.images;

import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.TokenRepository;
import mage.client.MageFrame;
import mage.client.dialog.DownloadImagesDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.remote.XmageURLConnection;
import mage.client.util.CardLanguage;
import mage.client.util.GUISizeHelper;
import mage.client.util.sets.ConstructedFormats;
import mage.util.XmageThreadFactory;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileInputStream;
import net.java.truevfs.access.TFileOutputStream;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import org.apache.log4j.Logger;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageSource;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.dl.sources.CopyPasteImageSource;
import org.mage.plugins.card.dl.sources.GrabbagImageSource;
import org.mage.plugins.card.dl.sources.ScryfallImageSource;
import org.mage.plugins.card.dl.sources.ScryfallImageSourceNormal;
import org.mage.plugins.card.dl.sources.ScryfallImageSourceSmall;
import org.mage.plugins.card.dl.sources.WizardCardsImageSource;
import org.mage.plugins.card.images.CardDownloadData;
import org.mage.plugins.card.images.LoadMissingCardDataNew;
import org.mage.plugins.card.utils.CardImageUtils;

public class DownloadPicturesService
extends DefaultBoundedRangeModel
implements DownloadServiceInfo,
Runnable {
    private static DownloadPicturesService instance = null;
    private static Thread loadMissingDataThread = null;
    private static final Logger logger = Logger.getLogger(DownloadPicturesService.class);
    private static final String ALL_IMAGES = "- ALL images from selected source (can be slow)";
    private static final String ALL_MODERN_IMAGES = "- MODERN images (can be slow)";
    private static final String ALL_STANDARD_IMAGES = "- STANDARD images";
    private static final String ALL_TOKENS = "- TOKEN images";
    private static final String ALL_BASICS = "- BASIC LAND images";
    private static final List<String> basicList = Arrays.asList("Plains", "Island", "Swamp", "Mountain", "Forest");
    private static final int MAX_ERRORS_COUNT_BEFORE_CANCEL = 50;
    private static final int DEFAULT_DOWNLOAD_THREADS = 5;
    private static final int MIN_FILE_SIZE_OF_GOOD_IMAGE = 6144;
    private static final int MIN_FILE_SIZE_OF_POSSIBLE_BAD_IMAGE = 8192;
    private final DownloadImagesDialog uiDialog;
    private boolean needCancel;
    private int errorCount;
    private int cardIndex;
    private List<CardInfo> cardsAll;
    private List<CardDownloadData> cardsMissing;
    private List<CardDownloadData> cardsDownloadQueue;
    private final List<String> selectedSets = new ArrayList<String>();
    private CardImageSource selectedSource;
    private final Object sync = new Object();
    private static final long serialVersionUID = 1L;

    public static DownloadPicturesService getInstance() {
        return instance;
    }

    public static void startDownload() {
        CardRepository.instance.getNonLandAndNonCreatureNames();
        if (instance == null) {
            instance = new DownloadPicturesService();
        }
        if (loadMissingDataThread != null) {
            // empty if block
        }
        DownloadPicturesService.instance.uiDialog.setGlobalInfo("Initializing image download...");
        DownloadPicturesService.instance.uiDialog.getProgressBar().setValue(0);
        loadMissingDataThread = new Thread(new LoadMissingCardDataNew(instance));
        loadMissingDataThread.setDaemon(true);
        loadMissingDataThread.start();
        instance.setNeedCancel(false);
        instance.resetErrorCount();
        DownloadPicturesService.instance.uiDialog.showDialog(() -> DownloadPicturesService.doStopAndClose());
    }

    private static void doStopAndClose() {
        instance.setNeedCancel(true);
        DownloadPicturesService.instance.uiDialog.hideDialog();
    }

    @Override
    public boolean isNeedCancel() {
        return this.needCancel || this.errorCount > 50 || Thread.currentThread().isInterrupted();
    }

    private void setNeedCancel(boolean needCancel) {
        this.needCancel = needCancel;
    }

    @Override
    public void incErrorCount() {
        ++this.errorCount;
        if (this.errorCount == 51) {
            logger.warn((Object)"Too many errors (> 50) in images download. Stop.");
        }
    }

    private void resetErrorCount() {
        this.errorCount = 0;
    }

    public DownloadPicturesService() {
        this.cardsAll = Collections.synchronizedList(new ArrayList());
        this.cardsMissing = Collections.synchronizedList(new ArrayList());
        this.cardsDownloadQueue = Collections.synchronizedList(new ArrayList());
        this.uiDialog = new DownloadImagesDialog();
        this.uiDialog.getSourcesCombo().setModel(new DefaultComboBoxModel<DownloadSources>(DownloadSources.values()));
        this.uiDialog.getSourcesCombo().setSelectedItem((Object)DownloadSources.SCRYFALL_NORM);
        this.selectedSource = ScryfallImageSource.getInstance();
        this.uiDialog.getSourcesCombo().addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.comboboxSourceSelected(event);
            }
        });
        this.uiDialog.getLaunguagesCombo().setModel(new DefaultComboBoxModel<CardLanguage>(CardLanguage.values()));
        this.uiDialog.getLaunguagesCombo().setSelectedItem((Object)PreferencesDialog.getPrefImagesLanguage());
        this.reloadLanguagesForSelectedSource();
        this.uiDialog.getDownloadThreadsCombo().setModel(new DefaultComboBoxModel<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1"}));
        this.uiDialog.getDownloadThreadsCombo().setSelectedItem(String.valueOf(5));
        this.uiDialog.getRedownloadCheckbox().setSelected(false);
        this.uiDialog.getRedownloadCheckbox().addItemListener(this::checkboxRedowloadChanged);
        this.uiDialog.getSetsCombo().addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.comboboxSetSelected(event);
            }
        });
        this.uiDialog.getStartButton().addActionListener(e -> {
            if (this.selectedSource != null && this.selectedSource.isLanguagesSupport()) {
                this.selectedSource.setCurrentLanguage((CardLanguage)((Object)((Object)this.uiDialog.getLaunguagesCombo().getSelectedItem())));
            }
            this.uiDialog.enableActionControls(false);
            this.uiDialog.getStartButton().setEnabled(false);
            new Thread(this).start();
        });
        this.uiDialog.getCancelButton().addActionListener(e -> DownloadPicturesService.doStopAndClose());
        this.uiDialog.getStopButton().addActionListener(e -> DownloadPicturesService.doStopAndClose());
    }

    public void findMissingCards() {
        this.updateGlobalMessage("Loading...");
        this.cardsAll.clear();
        this.cardsMissing.clear();
        this.cardsDownloadQueue.clear();
        try {
            this.updateGlobalMessage("Loading cards list...");
            this.cardsAll.addAll(CardRepository.instance.findCards(new CardCriteria().nightCard(null)));
            if (this.isNeedCancel()) {
                return;
            }
            this.updateGlobalMessage("Finding missing images...");
            this.cardsMissing.addAll(DownloadPicturesService.prepareMissingCards(this.cardsAll, this.uiDialog.getRedownloadCheckbox().isSelected()));
            if (this.isNeedCancel()) {
                return;
            }
            this.updateGlobalMessage("Finding available sets from selected source...");
            this.uiDialog.getSetsCombo().setModel(new DefaultComboBoxModel<Object>(this.getSetsForCurrentImageSource()));
            this.reloadCardsToDownload(this.uiDialog.getSetsCombo().getSelectedItem().toString());
        }
        finally {
            this.updateGlobalMessage("");
            this.uiDialog.showDownloadControls(true);
        }
    }

    private void reloadLanguagesForSelectedSource() {
        this.uiDialog.showLanguagesSupport(this.selectedSource != null && this.selectedSource.isLanguagesSupport());
    }

    private void reloadSetsForSelectedSource() {
        Object oldSelection = this.uiDialog.getSetsCombo().getSelectedItem();
        this.uiDialog.getSetsCombo().setModel(new DefaultComboBoxModel<Object>(this.getSetsForCurrentImageSource()));
        if (oldSelection != null) {
            this.uiDialog.getSetsCombo().setSelectedItem(oldSelection);
        }
        this.reloadCardsToDownload(this.uiDialog.getSetsCombo().getSelectedItem().toString());
    }

    private void comboboxSourceSelected(ItemEvent evt) {
        if (this.uiDialog.getSourcesCombo().isEnabled()) {
            this.selectedSource = ((DownloadSources)((Object)evt.getItem())).getSource();
            this.reloadSetsForSelectedSource();
            this.reloadLanguagesForSelectedSource();
        }
    }

    @Override
    public void updateGlobalMessage(String text) {
        this.uiDialog.setGlobalInfo(text);
    }

    @Override
    public void updateProgressMessage(String text) {
        this.updateProgressMessage(text, 0, 0);
    }

    @Override
    public void updateProgressMessage(String text, int progressCurrent, int progressNeed) {
        this.uiDialog.getProgressBar().setString(text);
        this.uiDialog.getProgressBar().setMaximum(progressNeed);
        this.uiDialog.getProgressBar().setValue(progressCurrent);
    }

    private String getSetNameWithYear(ExpansionSet exp) {
        return exp.getName() + " (" + exp.getCode() + ", " + exp.getReleaseYear() + ")";
    }

    private ExpansionSet findSetByNameWithYear(String name) {
        return Sets.getInstance().values().stream().filter(exp -> this.getSetNameWithYear((ExpansionSet)exp).equals(name)).findFirst().orElse(null);
    }

    private Object[] getSetsForCurrentImageSource() {
        List<String> supportedSets = this.selectedSource.getSupportedSets();
        ArrayList<String> setNames = new ArrayList<String>();
        if (this.selectedSource.isCardSource()) {
            setNames.add(ALL_IMAGES);
            setNames.add(ALL_MODERN_IMAGES);
            setNames.add(ALL_STANDARD_IMAGES);
            setNames.add(ALL_BASICS);
        }
        if (this.selectedSource.isTokenSource()) {
            setNames.add(ALL_TOKENS);
        }
        Collection dbSets = Sets.getInstance().values();
        Collection comboSets = dbSets.stream().filter(exp -> supportedSets.contains(exp.getCode())).sorted(Comparator.comparing(ExpansionSet::getReleaseDate).reversed()).map(this::getSetNameWithYear).collect(Collectors.toList());
        setNames.addAll(comboSets);
        if (setNames.isEmpty()) {
            logger.error((Object)("Source " + this.selectedSource.getSourceName() + " creates no selectable items."));
            setNames.add("not available");
        }
        return setNames.toArray(new String[0]);
    }

    private void reloadCardsToDownload(String selectedItem) {
        this.selectedSets.clear();
        boolean onlyTokens = false;
        boolean onlyBasics = false;
        List<String> sourceSets = this.selectedSource.getSupportedSets();
        switch (selectedItem) {
            case "- ALL images from selected source (can be slow)": {
                this.selectedSets.addAll(this.selectedSource.getSupportedSets());
                break;
            }
            case "- STANDARD images": {
                List<String> formatSets = ConstructedFormats.getSetsByFormat("- Standard");
                formatSets.stream().filter(sourceSets::contains).forEachOrdered(this.selectedSets::add);
                break;
            }
            case "- MODERN images (can be slow)": {
                List<String> formatSets = ConstructedFormats.getSetsByFormat("- Modern");
                formatSets.stream().filter(sourceSets::contains).forEachOrdered(this.selectedSets::add);
                break;
            }
            case "- BASIC LAND images": {
                this.selectedSets.addAll(this.selectedSource.getSupportedSets());
                onlyBasics = true;
                break;
            }
            case "- TOKEN images": {
                this.selectedSets.addAll(this.selectedSource.getSupportedSets());
                onlyTokens = true;
                break;
            }
            default: {
                ExpansionSet selectedExp = this.findSetByNameWithYear(selectedItem);
                if (selectedExp == null) break;
                this.selectedSets.add(selectedExp.getCode());
            }
        }
        this.cardsDownloadQueue.clear();
        int numberTokenImagesAvailable = 0;
        int numberCardImagesAvailable = 0;
        for (CardDownloadData data : this.cardsMissing) {
            if (data.isToken()) {
                if (onlyBasics || !this.selectedSource.isTokenSource() || !this.selectedSource.isTokenImageProvided(data.getSet(), data.getName(), data.getImageNumber()) || !this.selectedSets.contains(data.getSet())) continue;
                ++numberTokenImagesAvailable;
                this.cardsDownloadQueue.add(data);
                continue;
            }
            if (onlyTokens || !this.selectedSource.isCardSource() || !this.selectedSource.isCardImageProvided(data.getSet(), data.getName()) || !this.selectedSets.contains(data.getSet()) || onlyBasics && !basicList.contains(data.getName())) continue;
            ++numberCardImagesAvailable;
            this.cardsDownloadQueue.add(data);
        }
        this.updateProgressText(numberCardImagesAvailable, numberTokenImagesAvailable);
    }

    private void comboboxSetSelected(ItemEvent event) {
        this.reloadCardsToDownload(event.getItem().toString());
    }

    private void checkboxRedowloadChanged(ItemEvent event) {
        MageFrame.getDesktop().setCursor(new Cursor(3));
        try {
            this.cardsMissing.clear();
            this.cardsMissing.addAll(DownloadPicturesService.prepareMissingCards(this.cardsAll, this.uiDialog.getRedownloadCheckbox().isSelected()));
            this.reloadCardsToDownload(this.uiDialog.getSetsCombo().getSelectedItem().toString());
        }
        finally {
            MageFrame.getDesktop().setCursor(new Cursor(0));
        }
    }

    private void updateProgressText(int cardCount, int tokenCount) {
        int missingTokensCount = 0;
        for (CardDownloadData card : this.cardsMissing) {
            if (!card.isToken()) continue;
            ++missingTokensCount;
        }
        int missingCardsCount = this.cardsMissing.size() - missingTokensCount;
        this.uiDialog.setCurrentInfo("Missing: " + missingCardsCount + " card images / " + missingTokensCount + " token images");
        int imageSum = cardCount + tokenCount;
        float mb = (float)imageSum * this.selectedSource.getAverageSizeKb() / 1024.0f;
        String statusEnd = imageSum == 0 ? "you have all images. Please close." : (this.cardIndex == 0 ? "image download NOT STARTED. Please start." : String.format("image downloading... Please wait [%.1f MB left].", Float.valueOf(mb)));
        this.updateProgressMessage(String.format("%d of %d (%d cards and %d tokens) %s", 0, imageSum, cardCount, tokenCount, statusEnd), 0, imageSum);
    }

    private static String createDownloadName(CardInfo card) {
        String className = card.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static List<CardDownloadData> prepareMissingCards(List<CardInfo> allCards, boolean redownloadMode) {
        List allCardsUrls = Collections.synchronizedList(new ArrayList());
        try {
            allCards.parallelStream().forEach(card -> {
                if (!(card.getCardNumber().isEmpty() || "0".equals(card.getCardNumber()) || card.getSetCode().isEmpty())) {
                    CardDownloadData cardDownloadData;
                    CardDownloadData url;
                    if (!card.isNightCard() || card.isMeldCard()) {
                        String cardName = card.getName();
                        url = new CardDownloadData(cardName, card.getSetCode(), card.getCardNumber(), card.usesVariousArt(), 0);
                        if (url.getUsesVariousArt()) {
                            url.setDownloadName(DownloadPicturesService.createDownloadName(card));
                        }
                        url.setSplitCard(card.isSplitCard());
                        allCardsUrls.add(url);
                    }
                    if (card.isDoubleFaced()) {
                        if (card.getSecondSideName() == null || card.getSecondSideName().trim().isEmpty()) {
                            throw new IllegalStateException("Second side card can't have empty name.");
                        }
                        CardInfo secondSideCard = CardRepository.instance.findCardWithPreferredSetAndNumber(card.getSecondSideName(), card.getSetCode(), card.getCardNumber());
                        if (secondSideCard == null) {
                            throw new IllegalStateException("Can't find second side card in database: " + card.getSecondSideName());
                        }
                        url = new CardDownloadData(card.getSecondSideName(), card.getSetCode(), secondSideCard.getCardNumber(), card.usesVariousArt(), 0);
                        url.setSecondSide(true);
                        allCardsUrls.add(url);
                    }
                    if (card.isFlipCard()) {
                        if (card.getFlipCardName() == null || card.getFlipCardName().trim().isEmpty()) {
                            throw new IllegalStateException("Flipped card can't have empty name.");
                        }
                        cardDownloadData = new CardDownloadData(card.getFlipCardName(), card.getSetCode(), card.getCardNumber(), card.usesVariousArt(), 0);
                        cardDownloadData.setFlippedSide(true);
                        cardDownloadData.setSecondSide(card.isNightCard() && !card.isMeldCard());
                        allCardsUrls.add(cardDownloadData);
                    }
                    if (card.getMeldsToCardName() != null) {
                        if (card.getMeldsToCardName().trim().isEmpty()) {
                            throw new IllegalStateException("MeldsToCardName can't be empty in " + card.getName());
                        }
                        CardInfo meldsToCard = CardRepository.instance.findCardWithPreferredSetAndNumber(card.getMeldsToCardName(), card.getSetCode(), card.getCardNumber());
                        if (meldsToCard == null) {
                            throw new IllegalStateException("Can't find meldsToCard in database: " + card.getMeldsToCardName());
                        }
                        url = new CardDownloadData(card.getMeldsToCardName(), card.getSetCode(), meldsToCard.getCardNumber(), card.usesVariousArt(), 0);
                        allCardsUrls.add(url);
                    }
                    if (card.isModalDoubleFacedCard()) {
                        if (card.getModalDoubleFacedSecondSideName() == null || card.getModalDoubleFacedSecondSideName().trim().isEmpty()) {
                            throw new IllegalStateException("MDF card can't have empty name.");
                        }
                        cardDownloadData = new CardDownloadData(card.getModalDoubleFacedSecondSideName(), card.getSetCode(), card.getCardNumber(), card.usesVariousArt(), 0);
                        cardDownloadData.setSecondSide(true);
                        allCardsUrls.add(cardDownloadData);
                    }
                } else if (card.getCardNumber().isEmpty() || "0".equals(card.getCardNumber())) {
                    logger.error((Object)("Card has no collector ID and won't be sent to client: " + card.getName()));
                } else if (card.getSetCode().isEmpty()) {
                    logger.error((Object)("Card has no set name and won't be sent to client:" + card.getName()));
                } else {
                    logger.info((Object)("Card was not selected: " + card.getName()));
                }
            });
            TokenRepository.instance.getAll().forEach(token -> {
                CardDownloadData card = new CardDownloadData(token.getName(), token.getSetCode(), "0", false, token.getImageNumber());
                card.setToken(true);
                allCardsUrls.add(card);
            });
        }
        catch (Exception e) {
            logger.error((Object)("Error on prepare images list: " + e), (Throwable)e);
        }
        List cardsToDownload = Collections.synchronizedList(new ArrayList());
        AtomicInteger badContentChecks = new AtomicInteger();
        allCardsUrls.parallelStream().forEach(card -> {
            if (redownloadMode) {
                cardsToDownload.add(card);
            } else {
                String imagePath = CardImageUtils.buildImagePathToCardOrToken(card);
                TFile file = new TFile(imagePath);
                if (!file.exists()) {
                    cardsToDownload.add(card);
                } else if (file.length() < 6144L) {
                    logger.error((Object)("Found broken file (small size): " + imagePath));
                    cardsToDownload.add(card);
                } else if (file.length() < 8192L) {
                    badContentChecks.incrementAndGet();
                    try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                        BufferedImage image = ImageIO.read((InputStream)inputStream);
                        if (image.getWidth() <= 0) {
                            throw new IOException("bad format");
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Found broken file (bad format): " + imagePath));
                        cardsToDownload.add(card);
                    }
                }
            }
        });
        if (badContentChecks.get() > 1000) {
            logger.warn((Object)("Wrong code usage: too many file content checks (" + badContentChecks.get() + ") - try to decrease min file size"));
        }
        return Collections.synchronizedList(new ArrayList(cardsToDownload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            this.cardIndex = 0;
            this.resetErrorCount();
            try {
                File base = new File(CardImageUtils.getImagesDir());
                if (!base.exists()) {
                    base.mkdir();
                }
                int downloadThreadsAmount = Math.max(1, Integer.parseInt((String)this.uiDialog.getDownloadThreadsCombo().getSelectedItem()));
                logger.info((Object)("Started download of " + this.cardsDownloadQueue.size() + " images from source: " + this.selectedSource.getSourceName() + ", language: " + this.selectedSource.getCurrentLanguage().getCode() + ", threads: " + downloadThreadsAmount));
                this.updateProgressMessage("Preparing download list...");
                if (!this.selectedSource.prepareDownloadList(this, this.cardsDownloadQueue)) break block26;
                this.update(0, this.cardsDownloadQueue.size());
                ExecutorService executor = Executors.newFixedThreadPool(downloadThreadsAmount, new XmageThreadFactory("XMAGE images downloader", false));
                for (int i = 0; i < this.cardsDownloadQueue.size() && !this.isNeedCancel(); ++i) {
                    try {
                        CardImageUrls urls;
                        CardDownloadData card = this.cardsDownloadQueue.get(i);
                        logger.debug((Object)("Downloading image: " + card.getName() + " (" + card.getSet() + ')'));
                        if (card.isToken()) {
                            if (!"0".equals(card.getCollectorId())) continue;
                            urls = this.selectedSource.generateTokenUrl(card);
                        } else {
                            urls = this.selectedSource.generateCardUrl(card);
                        }
                        if (urls == null) {
                            String imageRef = this.selectedSource.getNextHttpImageUrl();
                            String fileName = this.selectedSource.getFileForHttpImage(imageRef);
                            if (imageRef != null && fileName != null) {
                                imageRef = this.selectedSource.getSourceName() + imageRef;
                                try {
                                    card.setToken(this.selectedSource.isTokenSource());
                                    DownloadTask task = new DownloadTask(card, imageRef, fileName, this.selectedSource.getTotalImages());
                                    executor.execute(task);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (this.selectedSource.getTotalImages() != -1) continue;
                            logger.info((Object)("Image not available on " + this.selectedSource.getSourceName() + ": " + card.getName() + " (" + card.getSet() + ')'));
                            Object object = this.sync;
                            synchronized (object) {
                                this.update(this.cardIndex + 1, this.cardsDownloadQueue.size());
                                continue;
                            }
                        }
                        DownloadTask task = new DownloadTask(card, urls, this.cardsDownloadQueue.size());
                        executor.execute(task);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex, (Throwable)ex);
                    }
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.info((Object)"Images: search broken files...");
                CardImageUtils.checkAndFixImageFiles();
            }
            catch (Throwable e) {
                logger.error((Object)("Catch unknown error while downloading: " + e), e);
                MageFrame.getInstance().showErrorDialog("Catch unknown error while downloading " + e, e);
            }
            finally {
                try {
                    TVFS.umount();
                }
                catch (FsSyncException e) {
                    logger.error((Object)("Couldn't unmount zip files " + (Object)((Object)e)), (Throwable)e);
                }
            }
        }
        Arrays.stream(DownloadSources.values()).forEach(resource -> ((DownloadSources)resource).source.onFinished());
        this.reloadCardsToDownload(this.uiDialog.getSetsCombo().getSelectedItem().toString());
        this.enableDialogButtons();
        GUISizeHelper.refreshGUIAndCards(false);
    }

    private void update(int lastCardIndex, int needDownloadCount) {
        this.cardIndex = lastCardIndex;
        if (this.cardIndex < needDownloadCount) {
            float mb = (float)(needDownloadCount - lastCardIndex) * this.selectedSource.getAverageSizeKb() / 1024.0f;
            this.updateProgressMessage(String.format("%d of %d image downloading... Please wait [%.1f MB left].", lastCardIndex, needDownloadCount, Float.valueOf(mb)), lastCardIndex, needDownloadCount);
        } else {
            this.updateProgressMessage("Image download DONE, saving last files and refreshing stats... Please wait.");
            List downloadedCards = Collections.synchronizedList(new ArrayList());
            this.cardsMissing.parallelStream().forEach(cardDownloadData -> {
                TFile file = new TFile(CardImageUtils.buildImagePathToCardOrToken(cardDownloadData));
                if (file.exists() && file.length() > 6144L) {
                    downloadedCards.add(cardDownloadData);
                }
            });
            HashSet finished = new HashSet(downloadedCards);
            this.cardsDownloadQueue = Collections.synchronizedList(this.cardsDownloadQueue.stream().filter(c -> !finished.contains(c)).collect(Collectors.toList()));
            this.cardsMissing = Collections.synchronizedList(this.cardsMissing.stream().filter(c -> !finished.contains(c)).collect(Collectors.toList()));
            if (this.cardsDownloadQueue.isEmpty()) {
                this.updateProgressMessage("Nothing to download. Please close.");
            }
            this.enableDialogButtons();
        }
    }

    private void enableDialogButtons() {
        this.uiDialog.getRedownloadCheckbox().setSelected(false);
        this.uiDialog.enableActionControls(true);
        this.uiDialog.getStartButton().setEnabled(true);
    }

    @Override
    public Object getSync() {
        return this.sync;
    }

    private final class DownloadTask
    implements Runnable {
        private final CardDownloadData card;
        private final CardImageUrls urls;
        private final int count;
        private final String actualFilename;
        private final boolean useSpecifiedPaths;

        DownloadTask(CardDownloadData card, CardImageUrls urls, int count) {
            this.card = card;
            this.urls = urls;
            this.count = count;
            this.actualFilename = "";
            this.useSpecifiedPaths = false;
        }

        DownloadTask(CardDownloadData card, String baseUrl, String actualFilename, int count) {
            this.card = card;
            this.urls = new CardImageUrls(baseUrl);
            this.count = count;
            this.actualFilename = actualFilename;
            this.useSpecifiedPaths = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block83: {
                if (DownloadPicturesService.getInstance().isNeedCancel()) {
                    Object object = DownloadPicturesService.this.sync;
                    synchronized (object) {
                        DownloadPicturesService.this.update(DownloadPicturesService.this.cardIndex + 1, this.count);
                    }
                    return;
                }
                try {
                    if (this.card == null) {
                        Object object = DownloadPicturesService.this.sync;
                        synchronized (object) {
                            DownloadPicturesService.this.update(DownloadPicturesService.this.cardIndex + 1, this.count);
                        }
                        return;
                    }
                    String tempPath = CardImageUtils.getImagesDir() + File.separator + "downloading" + File.separator;
                    TFile fileTempImage = this.useSpecifiedPaths ? new TFile(tempPath + this.actualFilename + "-" + this.card.hashCode() + ".jpg") : new TFile(tempPath + CardImageUtils.prepareCardNameForFile(this.card.getName()) + "-" + this.card.hashCode() + ".jpg");
                    TFile parentFile = fileTempImage.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    TFile destFile = this.useSpecifiedPaths ? (this.card.isToken() ? new TFile(CardImageUtils.buildImagePathToSet(this.card) + this.actualFilename + ".jpg") : new TFile(CardImageUtils.buildImagePathToTokens() + this.actualFilename + ".jpg")) : new TFile(CardImageUtils.buildImagePathToCardOrToken(this.card));
                    TFile testArchive = destFile.getTopLevelArchive();
                    if (testArchive != null && testArchive.exists()) {
                        try {
                            testArchive.list();
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error reading archive, it's can be corrupted. Try to delete it: " + testArchive.toString()));
                            Object object = DownloadPicturesService.this.sync;
                            synchronized (object) {
                                DownloadPicturesService.this.update(DownloadPicturesService.this.cardIndex + 1, this.count);
                            }
                            return;
                        }
                    }
                    XmageURLConnection connection = null;
                    List<String> downloadUrls = this.urls != null ? this.urls.getDownloadList() : new ArrayList<String>();
                    boolean isDownloadOK = false;
                    ArrayList<String> errorsList = new ArrayList<String>();
                    for (String string : downloadUrls) {
                        if (DownloadPicturesService.getInstance().isNeedCancel()) {
                            return;
                        }
                        DownloadPicturesService.this.selectedSource.doPause(string);
                        connection = new XmageURLConnection(string);
                        connection.startConnection();
                        if (!connection.isConnected()) continue;
                        connection.setRequestHeaders(DownloadPicturesService.this.selectedSource.getHttpRequestHeaders(string));
                        try {
                            connection.connect();
                        }
                        catch (SocketException e) {
                            DownloadPicturesService.this.incErrorCount();
                            errorsList.add("Wrong image URL or java app is not allowed to use network. Check your firewall or proxy settings. Error: " + e.getMessage() + ". Image URL: " + string);
                            break;
                        }
                        catch (UnknownHostException e) {
                            DownloadPicturesService.this.incErrorCount();
                            errorsList.add("Unknown site. Check your DNS settings. Error: " + e.getMessage() + ". Image URL: " + string);
                            break;
                        }
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) {
                            String info = String.format("Image download failed for %s - %s, http code: %d, url: %s", this.card.getSet(), this.card.getName(), responseCode, string);
                            errorsList.add(info);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Returned HTML ERROR:\n" + connection.getErrorResponseAsString()));
                            continue;
                        }
                        isDownloadOK = true;
                        break;
                    }
                    if (isDownloadOK && connection.isConnected()) {
                        Throwable throwable = null;
                        try (BufferedInputStream in = new BufferedInputStream(connection.getGoodResponseAsStream());
                             TFileOutputStream tempFileStream = new TFileOutputStream((File)fileTempImage);
                             BufferedOutputStream out = new BufferedOutputStream((OutputStream)tempFileStream);){
                            byte[] buf = new byte[1024];
                            while (true) {
                                int len;
                                if ((len = ((InputStream)in).read(buf)) == -1) break;
                                if (DownloadPicturesService.getInstance().isNeedCancel()) {
                                    try {
                                        TFile.rm((File)fileTempImage);
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)("Can't delete temp file: " + e.getMessage()), (Throwable)e);
                                    }
                                    return;
                                }
                                ((OutputStream)out).write(buf, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                        if (fileTempImage.exists()) {
                            if (!destFile.getParentFile().exists()) {
                                destFile.getParentFile().mkdirs();
                            }
                            new TFile((File)fileTempImage).cp_rp((File)destFile);
                            try {
                                TFile.rm((File)fileTempImage);
                            }
                            catch (Exception e) {
                                logger.error((Object)("Can't delete temp file: " + e.getMessage()), (Throwable)e);
                            }
                        }
                        break block83;
                    }
                    for (String string : errorsList) {
                        logger.warn((Object)string);
                    }
                }
                catch (AccessDeniedException e) {
                    DownloadPicturesService.this.incErrorCount();
                    logger.error((Object)("Can't access to files: " + this.card.getName() + "(" + this.card.getSet() + "). Try rebooting your system to remove the file lock."));
                }
                catch (Exception e) {
                    DownloadPicturesService.this.incErrorCount();
                    String sampleUrl = this.urls == null ? "null" : (String)this.urls.getDownloadList().stream().findFirst().orElse(null);
                    logger.error((Object)("Unknown error: " + e.getMessage() + ", sample url: " + sampleUrl), (Throwable)e);
                }
            }
            Object object = DownloadPicturesService.this.sync;
            synchronized (object) {
                DownloadPicturesService.this.update(DownloadPicturesService.this.cardIndex + 1, this.count);
            }
        }
    }

    static enum DownloadSources {
        WIZARDS("1. wizards.com - low quality, cards only", WizardCardsImageSource.instance),
        SCRYFALL_BIG("2a. scryfall.com - BIG: high quality (~15 GB)", ScryfallImageSource.getInstance()),
        SCRYFALL_NORM("2b. scryfall.com - normal: good quality (~10 GB)", ScryfallImageSourceNormal.getInstance()),
        SCRYFALL_SMALL("2c. scryfall.com - small: low quality, unreadable text (~1.5 GB)", ScryfallImageSourceSmall.getInstance()),
        GRAB_BAG("3. GrabBag - unofficial STAR WARS + Arena Tutorial cards", GrabbagImageSource.instance),
        COPYPASTE("4. Experimental - copy and paste image URLs", CopyPasteImageSource.instance);

        private final String text;
        private final CardImageSource source;

        private DownloadSources(String text, CardImageSource sourceInstance) {
            this.text = text;
            this.source = sourceInstance;
        }

        public CardImageSource getSource() {
            return this.source;
        }

        public String toString() {
            return this.text;
        }
    }
}

