/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.images;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import mage.abilities.icon.CardIconColor;
import mage.client.constants.Constants;
import mage.client.util.ImageCaches;
import mage.client.util.SoftValuesLoadingCache;
import mage.client.util.TransformedImageCache;
import mage.view.CardView;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileInputStream;
import org.apache.log4j.Logger;
import org.mage.plugins.card.images.CardDownloadData;
import org.mage.plugins.card.images.ImageCacheData;
import org.mage.plugins.card.utils.CardImageUtils;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public final class ImageCache {
    private static final Logger LOGGER = Logger.getLogger(ImageCache.class);
    private static final SoftValuesLoadingCache<String, ImageCacheData> SHARED_CARD_IMAGES_CACHE = ImageCaches.register(SoftValuesLoadingCache.from(ImageCache::createCardOrTokenImage));
    private static final SoftValuesLoadingCache<String, ImageCacheData> SHARED_CARD_ICONS_CACHE = ImageCaches.register(SoftValuesLoadingCache.from(ImageCache::createIcon));
    private static final Pattern CARD_IMAGE_KEY_PATTERN = Pattern.compile("(.*)#(.*)#(.*)#(.*)#(.*)");
    private static final Pattern CARD_ICON_KEY_PATTERN = Pattern.compile("(.*)#(.*)#(.*)");

    private ImageCache() {
    }

    private static ImageCacheData createCardOrTokenImage(String key) {
        Matcher m;
        boolean usesVariousArt = false;
        if (key.matches(".*#usesVariousArt.*")) {
            usesVariousArt = true;
            key = key.replace("#usesVariousArt", "");
        }
        if ((m = CARD_IMAGE_KEY_PATTERN.matcher(key)).matches()) {
            String path;
            String name = m.group(1);
            String setCode = m.group(2);
            Integer imageNumber = Integer.parseInt(m.group(3));
            String collectorId = m.group(4);
            if (collectorId.equals("null")) {
                collectorId = "0";
            }
            CardDownloadData info = new CardDownloadData(name, setCode, collectorId, usesVariousArt, imageNumber);
            if (collectorId.isEmpty() || "0".equals(collectorId)) {
                info.setToken(true);
                path = CardImageUtils.buildImagePathToCardOrToken(info);
                TFile tokenFile = ImageCache.getTFile(path);
                if (tokenFile == null || !tokenFile.exists()) {
                    CardDownloadData tempInfo = new CardDownloadData(info);
                    tempInfo.setToken(false);
                    path = CardImageUtils.buildImagePathToCardOrToken(info);
                    tokenFile = ImageCache.getTFile(path);
                }
                if (tokenFile == null || !tokenFile.exists()) {
                    path = CardImageUtils.buildImagePathToDefault("cardback.jpg");
                }
            } else {
                path = CardImageUtils.buildImagePathToCardOrToken(info);
            }
            TFile file = ImageCache.getTFile(path);
            if (file == null) {
                return new ImageCacheData(path, null);
            }
            BufferedImage image = ImageCache.loadImage(file);
            image = ImageCache.getRoundCorner(image);
            return new ImageCacheData(path, image);
        }
        throw new IllegalArgumentException("Unknown card image's key format: " + key);
    }

    private static ImageCacheData createIcon(String key) {
        Matcher m = CARD_ICON_KEY_PATTERN.matcher(key);
        if (m.matches()) {
            int cardSize = Integer.parseInt(m.group(1));
            String resourceName = m.group(2);
            CardIconColor cardIconColor = CardIconColor.valueOf(m.group(3));
            BufferedImage image = ImageManagerImpl.instance.getCardIcon(resourceName, cardSize, cardIconColor);
            return new ImageCacheData(resourceName, image);
        }
        throw new IllegalArgumentException("Unknown card icon's key format: " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getRoundCorner(BufferedImage image) {
        if (image != null) {
            BufferedImage cornerImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            float ROUNDED_CORNER_SIZE = 0.11f;
            int cornerSizeBorder = Math.max(4, Math.round((float)image.getWidth() * ROUNDED_CORNER_SIZE));
            Graphics2D g2 = cornerImage.createGraphics();
            try {
                g2.setComposite(AlphaComposite.Src);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.white);
                g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, cornerImage.getWidth(), cornerImage.getHeight(), cornerSizeBorder, cornerSizeBorder));
                g2.setComposite(AlphaComposite.SrcAtop);
                g2.drawImage((Image)image, 0, 0, null);
            }
            finally {
                g2.dispose();
            }
            return cornerImage;
        }
        return image;
    }

    public static BufferedImage getWizardsCard(BufferedImage image) {
        if (image != null && image.getWidth() == 265 && image.getHeight() == 370) {
            BufferedImage crop = new BufferedImage(256, 360, 1);
            Graphics2D g2 = crop.createGraphics();
            try {
                g2.drawImage(image, 0, 0, 255, 360, 5, 5, 261, 365, null);
            }
            finally {
                g2.dispose();
            }
            return crop;
        }
        return image;
    }

    public static ImageCacheData getCardImageOriginal(CardView card) {
        return ImageCache.getCardImage(ImageCache.getKey(card, card.getName(), 0));
    }

    public static ImageCacheData getCardImageAlternate(CardView card) {
        return ImageCache.getCardImage(ImageCache.getKey(card, card.getAlternateName(), 0));
    }

    public static ImageCacheData getCardIconImage(String resourceName, int iconSize, String cardColorName) {
        return ImageCache.getCardIconImage(ImageCache.getCardIconKey(resourceName, iconSize, cardColorName));
    }

    private static ImageCacheData getCardImage(String key) {
        try {
            ImageCacheData data = SHARED_CARD_IMAGES_CACHE.getOrNull(key);
            return data != null ? data : new ImageCacheData("ERROR: key - " + key, null);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NullPointerException) {
                return new ImageCacheData("ERROR: possible low memory", null);
            }
            LOGGER.error((Object)("Error while loading card image: " + e), (Throwable)e);
            return new ImageCacheData("ERROR: see client logs for details", null);
        }
    }

    private static ImageCacheData getCardIconImage(String key) {
        try {
            ImageCacheData data = SHARED_CARD_ICONS_CACHE.getOrNull(key);
            return data != null ? data : new ImageCacheData("ERROR: key - " + key, null);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NullPointerException) {
                return new ImageCacheData("ERROR: possible low memory", null);
            }
            LOGGER.error((Object)("Error while loading card icon: " + e), (Throwable)e);
            return new ImageCacheData("ERROR: see client logs for details", null);
        }
    }

    private static ImageCacheData tryGetImage(String key) {
        return SHARED_CARD_IMAGES_CACHE.peekIfPresent(key);
    }

    private static String getKey(CardView card, String cardName, int imageSize) {
        String imageFileName = card.getImageFileName();
        if (imageFileName.isEmpty()) {
            imageFileName = cardName;
        }
        return imageFileName.replace(" Token", "") + '#' + card.getExpansionSetCode() + '#' + card.getImageNumber() + '#' + card.getCardNumber() + '#' + imageSize + (card.getUsesVariousArt() ? "#usesVariousArt" : "");
    }

    private static String getFaceKey(CardView card, String name, String set) {
        return name + '#' + set + "####";
    }

    private static String getCardIconKey(String resourceName, int size, String cardColorName) {
        return size + "#" + resourceName + "#" + cardColorName;
    }

    public static BufferedImage loadImage(TFile file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            LOGGER.debug((Object)("File does not exist: " + file.toString()));
            return null;
        }
        BufferedImage image = null;
        try (TFileInputStream inputStream = new TFileInputStream((File)file);){
            image = ImageIO.read((InputStream)inputStream);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return image;
    }

    public static BufferedImage getNormalSizeImage(BufferedImage original) {
        if (original == null) {
            return null;
        }
        int srcWidth = original.getWidth();
        int srcHeight = original.getHeight();
        int tgtWidth = Constants.CARD_SIZE_FULL.width;
        int tgtHeight = Constants.CARD_SIZE_FULL.height;
        if (srcWidth == tgtWidth && srcHeight == tgtHeight) {
            return original;
        }
        return TransformedImageCache.getResizedImage(original, tgtWidth, tgtHeight);
    }

    public static ImageCacheData getCardImage(CardView card, int width, int height) {
        String key = ImageCache.getKey(card, card.getName(), width);
        ImageCacheData data = ImageCache.getCardImage(key);
        if (data.getImage() == null) {
            LOGGER.debug((Object)("Image doesn't exists in the cache: " + key));
            return data;
        }
        double scale = Math.min((double)width / (double)data.getImage().getWidth(), (double)height / (double)data.getImage().getHeight());
        if (scale >= 1.0) {
            return data;
        }
        BufferedImage newImage = TransformedImageCache.getResizedImage(data.getImage(), (int)((double)data.getImage().getWidth() * scale), (int)((double)data.getImage().getHeight() * scale));
        data.setImage(newImage);
        return data;
    }

    public static ImageCacheData tryGetImage(CardView card, int width, int height) {
        String key = ImageCache.getKey(card, card.getName(), width);
        ImageCacheData data = ImageCache.tryGetImage(key);
        if (data.getImage() == null) {
            LOGGER.debug((Object)(key + " not found"));
            return data;
        }
        double scale = Math.min((double)width / (double)data.getImage().getWidth(), (double)height / (double)data.getImage().getHeight());
        if (scale >= 1.0) {
            return data;
        }
        BufferedImage newImage = TransformedImageCache.getResizedImage(data.getImage(), (int)((double)data.getImage().getWidth() * scale), (int)((double)data.getImage().getHeight() * scale));
        data.setImage(newImage);
        return data;
    }

    public static TFile getTFile(String path) {
        try {
            if (path != null) {
                return new TFile(path);
            }
        }
        catch (NullPointerException ex) {
            LOGGER.warn((Object)("Imagefile does not exist: " + path));
        }
        return null;
    }
}

