/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Locale;
import mage.client.constants.Constants;
import mage.client.dialog.PreferencesDialog;
import mage.view.CardView;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import org.apache.log4j.Logger;
import org.mage.plugins.card.images.CardDownloadData;

public final class CardImageUtils {
    private static final Logger LOGGER = Logger.getLogger(CardImageUtils.class);

    public static String prepareCardNameForFile(String cardName) {
        return cardName.replace(":", "").replace("\"", "").replace("//", "-");
    }

    public static String getImagesDir() {
        String path = null;
        if (!PreferencesDialog.getCachedValue("cardImagesUseDefault", "true").equals("true")) {
            path = PreferencesDialog.getCachedValue("cardImagesPath", null);
        }
        if (path == null) {
            path = Constants.IO.DEFAULT_IMAGES_DIR;
        }
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String buildImagePathToDefault(String defaultFileName) {
        return CardImageUtils.getImagesDir() + Constants.RESOURCE_PATH_DEFAULT_IMAGES + File.separator + defaultFileName;
    }

    public static String fixSetNameForWindows(String setCode) {
        if (setCode.equals("CON") || setCode.equals("con")) {
            return "COX";
        }
        return setCode;
    }

    public static String buildImagePathToTokens() {
        String imagesPath = CardImageUtils.getImagesDir() + File.separator;
        if (PreferencesDialog.isSaveImagesToZip()) {
            return imagesPath + "TOK.zip" + File.separator;
        }
        return imagesPath + "TOK" + File.separator;
    }

    public static String buildImagePathToSet(CardDownloadData card) {
        if (card.getSet() == null) {
            throw new IllegalArgumentException("Card " + card.getName() + " have empty set.");
        }
        String setCode = card.getSet().toUpperCase(Locale.ENGLISH);
        if (card.isToken()) {
            return CardImageUtils.buildImagePathToSetAsToken(setCode);
        }
        return CardImageUtils.buildImagePathToSetAsCard(setCode);
    }

    private static String buildImagePathToSetAsCard(String setCode) {
        String imagesPath = CardImageUtils.getImagesDir() + File.separator;
        if (PreferencesDialog.isSaveImagesToZip()) {
            return imagesPath + CardImageUtils.fixSetNameForWindows(setCode) + ".zip" + File.separator + CardImageUtils.fixSetNameForWindows(setCode) + File.separator;
        }
        return imagesPath + CardImageUtils.fixSetNameForWindows(setCode) + File.separator;
    }

    private static String buildImagePathToSetAsToken(String setCode) {
        return CardImageUtils.buildImagePathToTokens() + CardImageUtils.fixSetNameForWindows(setCode) + File.separator;
    }

    public static String buildImagePathToCardOrToken(CardDownloadData card) {
        String setPath = CardImageUtils.buildImagePathToSet(card);
        String prefixType = "";
        if (card.getImageNumber() != 0) {
            prefixType = " " + card.getImageNumber();
        }
        String cardName = CardImageUtils.prepareCardNameForFile(card.getName());
        String finalFileName = card.getUsesVariousArt() ? cardName + prefixType + '.' + card.getCollectorIdAsFileName() + ".full.jpg" : cardName + prefixType + ".full.jpg";
        return setPath + finalFileName;
    }

    public static String buildImagePathToCardView(CardView card) {
        String imageFile;
        boolean isTokenRepository;
        String imageFileName = card.getImageFileName();
        if (imageFileName.isEmpty()) {
            imageFileName = card.getName();
        }
        if (imageFileName.isEmpty()) {
            return "ERROR: empty image file name, object type - " + (Object)((Object)card.getMageObjectType());
        }
        boolean bl = isTokenRepository = card.getMageObjectType().isUseTokensRepository() || card.getExpansionSetCode().equals("XMAGE");
        if (isTokenRepository && !card.getCardNumber().isEmpty()) {
            isTokenRepository = false;
        }
        if (isTokenRepository) {
            CardDownloadData cardData = new CardDownloadData(imageFileName.replace(" Token", ""), card.getExpansionSetCode(), card.getCardNumber(), card.getUsesVariousArt(), card.getImageNumber());
            cardData.setToken(true);
            imageFile = CardImageUtils.buildImagePathToCardOrToken(cardData);
        } else {
            CardDownloadData cardData = new CardDownloadData(imageFileName, card.getExpansionSetCode(), card.getCardNumber(), card.getUsesVariousArt(), card.getImageNumber());
            imageFile = CardImageUtils.buildImagePathToCardOrToken(cardData);
        }
        return imageFile;
    }

    public static String generateFaceImagePath(String cardName, String setCode) {
        return CardImageUtils.getImagesDir() + File.separator + "FACE" + File.separator + CardImageUtils.fixSetNameForWindows(setCode) + File.separator + CardImageUtils.prepareCardNameForFile(cardName) + ".jpg";
    }

    public static void checkAndFixImageFiles() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException e) {
            LOGGER.error((Object)("Couldn't unmount zip files on searching broken images " + (Object)((Object)e)), (Throwable)e);
        }
        Path rootPath = new File(CardImageUtils.getImagesDir()).toPath();
        if (!Files.exists(rootPath, new LinkOption[0])) {
            return;
        }
        final ArrayList brokenFilesList = new ArrayList();
        final ArrayList tempFilesList = new ArrayList();
        final ArrayList outdatedFilesList = new ArrayList();
        try {
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.size() == 0L) {
                        brokenFilesList.add(file);
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.toString().endsWith(".tmp")) {
                        tempFilesList.add(file);
                    }
                    if (file.toString().endsWith(".thumb.zip")) {
                        outdatedFilesList.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error((Object)("Can't load files list from images folder: " + rootPath.toAbsolutePath().toString()), (Throwable)e);
        }
        ArrayList list = new ArrayList();
        list.addAll(tempFilesList);
        list.addAll(outdatedFilesList);
        for (Path path : list) {
            try {
                Files.delete(path);
            }
            catch (Throwable throwable) {}
        }
        if (!brokenFilesList.isEmpty()) {
            LOGGER.warn((Object)("Images: found " + brokenFilesList.size() + " broken files. Trying to fix it..."));
            for (Path brokenFile : brokenFilesList) {
                try {
                    Files.delete(brokenFile);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)("Images check: ERROR, can't delete broken file: " + brokenFile.toAbsolutePath()), e);
                    break;
                }
            }
        }
    }
}

